package io.keiji.whereami;

import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.support.v7.app.ActionBarActivity;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import java.io.IOException;

import butterknife.ButterKnife;
import butterknife.InjectView;
import butterknife.OnClick;


public class MainActivity extends ActionBarActivity {
    private static final String TAG = MainActivity.class.getSimpleName();

    @InjectView(R.id.textview)
    TextView textView;

    @InjectView(R.id.button)
    Button button;

    @OnClick(R.id.button)
    public void onClick(View v) {
        // ボタンがクリックされたら、textViewの内容をclickに変更する
        textView.setText("click");
    }

    private class GeocodingTask extends AsyncTask<Location, Void, GeocodingApi.Data> {

        @Override
        protected GeocodingApi.Data doInBackground(Location... params) {
            Location location =  params[0];

            GeocodingApi.Data data = null;

            try {
                // GeocodingAPIを使って位置情報をアドレスに変換する
                data = GeocodingApi.getAddressByLocation(location.getLatitude(), location.getLongitude());

            } catch (IOException e) {
                Log.e(TAG, "IOException", e);
            }

            return data;
        }

        @Override
        protected void onPostExecute(GeocodingApi.Data data) {
            super.onPostExecute(data);

            // 結果を表示する
            textView.setText(data.resultList.get(0).formattedAddress);
        }
    }
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        // InjectViewに指定したidの画面の部品をメンバ変数に代入する
        // OnClickに指定したidの画面の部品にOnClickListenerを設定する
        ButterKnife.inject(this);

        Location location = getIntent().getParcelableExtra("location");

        // AsyncTaskの開始
        new GeocodingTask().execute(location);
    }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_settings) {
            return true;
        }

        return super.onOptionsItemSelected(item);
    }
}
