package io.keiji.whereami;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/**
 * Geocoding APIの利用をまとめたクラス.
 */
public class GeocodingApi {
    private static final String TAG = GeocodingApi.class.getSimpleName();

    public static Data getAddressByLocation(double latitude, double longitude) throws IOException {

        // 与えられた緯度(latitude)と経度(longitude)から、逆ジオコーディングをリクエストするURLを構築する
        URL url = new URL(
                String.format(Locale.JAPAN, "http://maps.googleapis.com/maps/api/geocode/json?latlng=%f,%f&sensor=true", latitude, longitude));

        // 指定したURLに接続
        HttpURLConnection connection = (HttpURLConnection) url.openConnection();
        connection.connect();

        // サーバーからの応答を読み取って文字列にする
        BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));

        // GSONを使ってJSONをオブジェクトに変換する
        Data data = new Gson().fromJson(br, Data.class);

        br.close();

        return data;
    }

    public static class Data {

        @SerializedName("results")
        public final List<Result> resultList = new ArrayList<>();

        public class Result {

            @SerializedName("formatted_address")
            public String formattedAddress;
        }
    }

}
