package io.keiji.whereami;

import android.app.Activity;
import android.content.Intent;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;

/**
 * スプラッシュ画面.
 */
public class SplashActivity extends Activity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_splash);

        LocationManager locationManager = (LocationManager) getSystemService(LOCATION_SERVICE);

        // 位置情報の取得をリクエストする。
        // 取得元はGPSから、全ての位置情報更新を受け取る（更新を受け取る最小間隔を0秒、更新を受け取る最小移動間隔を0mに設定）
        locationManager.requestLocationUpdates(LocationManager.GPS_PROVIDER, 0, 0, new LocationListener() {
            @Override
            public void onLocationChanged(final Location location) {
                Intent intent = new Intent(SplashActivity.this, MainActivity.class);
                intent.putExtra("location", location);
                startActivity(intent);
            }

            @Override
            public void onStatusChanged(String provider, int status, Bundle extras) {

            }

            @Override
            public void onProviderEnabled(String provider) {

            }

            @Override
            public void onProviderDisabled(String provider) {

            }
        });

    }
}
