package io.keiji.whereami;

import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.support.v7.app.ActionBarActivity;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import java.io.IOException;


public class MainActivity extends ActionBarActivity {
    private static final String TAG = MainActivity.class.getSimpleName();

    private TextView textView;

    private class GeocodingTask extends AsyncTask<Location, Void, GeocodingApi.Data> {

        @Override
        protected GeocodingApi.Data doInBackground(Location... params) {
            Location location =  params[0];

            GeocodingApi.Data data = null;

            try {
                // GeocodingAPIを使って位置情報をアドレスに変換する
                data = GeocodingApi.getAddressByLocation(location.getLatitude(), location.getLongitude());

            } catch (IOException e) {
                Log.e(TAG, "IOException", e);
            }

            return data;
        }

        @Override
        protected void onPostExecute(GeocodingApi.Data data) {
            super.onPostExecute(data);

            // 結果を表示する
            textView.setText(data.resultList.get(0).formattedAddress);
        }
    }
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        // findViewByIdに、layoutで指定したidを指定してViewを取得する
        // OnClickListenerの中からアクセスするため、finalをつける
        textView = (TextView) findViewById(R.id.textview);
        Button button = (Button) findViewById(R.id.button);
        button.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                // ボタンがクリックされたら、textViewの内容をclickに変更する
                textView.setText("click");
            }
        });

        LocationManager locationManager = (LocationManager) getSystemService(LOCATION_SERVICE);

        // 位置情報の取得をリクエストする。
        // 取得元はGPSから、全ての位置情報更新を受け取る（更新を受け取る最小間隔を0秒、更新を受け取る最小移動間隔を0mに設定）
        locationManager.requestLocationUpdates(LocationManager.GPS_PROVIDER, 0, 0, new LocationListener() {
            @Override
            public void onLocationChanged(final Location location) {
                // 位置情報に変化があれば実行
                textView.setText(location.getLatitude() + ", " + location.getLongitude());

                // AsyncTaskの開始
                new GeocodingTask().execute(location);
            }

            @Override
            public void onStatusChanged(String provider, int status, Bundle extras) {

            }

            @Override
            public void onProviderEnabled(String provider) {

            }

            @Override
            public void onProviderDisabled(String provider) {

            }
        });
    }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_settings) {
            return true;
        }

        return super.onOptionsItemSelected(item);
    }
}
