package io.keiji.whereami;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Locale;

/**
 * Geocoding APIの利用をまとめたクラス.
 */
public class GeocodingApi {
    private static final String TAG = GeocodingApi.class.getSimpleName();

    public static String getAddressByLocation(double latitude, double longitude) throws IOException {

        // 与えられた緯度(latitude)と経度(longitude)から、逆ジオコーディングをリクエストするURLを構築する
        URL url = new URL(
                String.format(Locale.JAPAN, "http://maps.googleapis.com/maps/api/geocode/json?latlng=%f,%f&sensor=true", latitude, longitude));

        // 指定したURLに接続
        HttpURLConnection connection = (HttpURLConnection) url.openConnection();
        connection.connect();

        StringBuilder sb = new StringBuilder();
        String line = null;

        // サーバーからの応答を読み取って文字列にする
        BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }

        br.close();

        return sb.toString();
    }

}
