/***************************************************************************
**
**  Copyright 2004 Pervasive Software Inc. All Rights Reserved.
**
***************************************************************************/
package com.pervasive.open.eclipse.sql.internal;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

/**
 * WordRule based class which allow tokens to be identified
 * regardless of case
 */
public class CaseInsensitiveWordRule extends WordRule
{
    private StringBuffer fBuffer= new StringBuffer();
    
    public CaseInsensitiveWordRule(IWordDetector detector) {
        super(detector, Token.UNDEFINED);
    }
    public CaseInsensitiveWordRule(IWordDetector detector, IToken defaultToken) {
        super(detector,defaultToken);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c= scanner.read();
        if (fDetector.isWordStart((char) c)) {
            if (fColumn == UNDEFINED || (fColumn == scanner.getColumn() - 1)) {
                
                fBuffer.setLength(0);
                do {
                    fBuffer.append((char) c);
                    c= scanner.read();
                } while (c != ICharacterScanner.EOF && fDetector.isWordPart((char) c));
                scanner.unread();
                
                // NOTE: added toUpperCase here so that the Sql editor highlights
                // regardless of case.
                IToken token= (IToken) fWords.get(fBuffer.toString().toUpperCase());
                if (token != null)
                    return token;
                    
                if (fDefaultToken.isUndefined())
                    unreadBuffer(scanner);
                    
                return fDefaultToken;
            }
        }
        
        scanner.unread();
        return Token.UNDEFINED;
    }
    
    /**
     * Returns the characters in the buffer to the scanner.
     *
     * @param scanner the scanner to be used
     */
    protected void unreadBuffer(ICharacterScanner scanner) {
        for (int i= fBuffer.length() - 1; i >= 0; i--)
            scanner.unread();
    }
}
