#!/bin/sh

echo "+++++ Checking current user rights..."

if [ "$(id -u root)" = "$(id -u)" ] ; then
    echo "Passed..."
else
    echo "ERROR: The current user id is not root (`id|awk '{print $1}'`)."
    exit 1
fi
echo

if [ "X$ACTIANZEN_ROOT" = "X" ] ; then
    ACTIANZEN_ROOT=/usr/local/actianzen
fi
export ACTIANZEN_ROOT

LIBDIR=lib64

PATH=$ACTIANZEN_ROOT/bin:$PATH
if [ $(uname -s) = "Darwin" ]
then
    DYLD_LIBRARY_PATH=$ACTIANZEN_ROOT/bin:$ACTIANZEN_ROOT/lib:$ACTIANZEN_ROOT/lib64:$DYLD_LIBRARY_PATH
    export DYLD_LIBRARY_PATH
    SO_EXTENSION="dylib"
    SU_ARGS="-l"
else
    LD_LIBRARY_PATH=$ACTIANZEN_ROOT/bin:$ACTIANZEN_ROOT/lib:$ACTIANZEN_ROOT/$LIBDIR:$LD_LIBRARY_PATH
    export LD_LIBRARY_PATH
    SO_EXTENSION="so"
    SU_ARGS=
fi
SU="su -"
USERNAME=zen-svc
DEMODATADB="DEMODATA"
TEMPDB="TEMPDB"

RUNDAEMONFILE="$ACTIANZEN_ROOT/etc/init.d/actianzen"

for FILE in $ACTIANZEN_ROOT/$LIBDIR/libpsqlmif.${SO_EXTENSION}.[0-9]*
do
    if [ \( -f $FILE \) -a \( ! -h $FILE \) ]; then
        MIF_FILE=$FILE
        break
    fi
done
if [ "$MIF_FILE" ]; then
    # ..../libpsqlmif.so.15.10.NNN.MMM --> 15
    # ..../libpsqlmif.so.15 -> 15
    PSQL_VER=`echo $MIF_FILE | sed -e 's/^.*\.'"${SO_EXTENSION}"'\.\([0-9]*\).*$/\1/'`
else
    if [ $(uname -s) = "Darwin" ]; then
        # ..../libpsqlmif.15.dylib --> 15
        for FILE in $ACTIANZEN_ROOT/$LIBDIR/libpsqlmif.[0-9]*.dylib
        do
            if [ \( -f $FILE \) -a \( ! -h $FILE \) ]; then
                MIF_FILE=$FILE
                break
            fi
        done
        PSQL_VER=`echo $MIF_FILE | sed -e 's/^.*\.\([0-9]*\)\.dylib$/\1/'`
    fi
fi
echo "++++ MIF_FILE: $MIF_FILE (PSQL_VER $PSQL_VER)"
PS_VER=$PSQL_VER

# If Zen isn't running.
if ! $RUNDAEMONFILE status > /dev/null ; then
    echo "+++++ Starting the Zen daemon..."
    $RUNDAEMONFILE start
    #echo
fi


echo "+++++ Removing the $DEMODATADB database..."
DEMODATADBEXIST=`echo "$ACTIANZEN_ROOT/bin/dbmaint l" | $SU $USERNAME $SU_ARGS | grep $DEMODATADB | wc -l | tr -d " "`
if [ "X$DEMODATADBEXIST" != "X0" ] ; then
    echo "$ACTIANZEN_ROOT/bin/dbmaint d -n$DEMODATADB" | $SU $USERNAME $SU_ARGS
fi
echo


echo "+++++ Removing the $TEMPDB database..."
TEMPDBEXIST=`echo "$ACTIANZEN_ROOT/bin/dbmaint l" | $SU $USERNAME $SU_ARGS | grep $TEMPDB | wc -l | tr -d " "`
if [ "X$TEMPDBEXIST" != "X0" ] ; then
    echo "$ACTIANZEN_ROOT/bin/dbmaint d -n$TEMPDB" | $SU $USERNAME $SU_ARGS
fi
echo


echo "+++++ Stopping the Zen daemon..."
$RUNDAEMONFILE force
#echo

# **** temp compat with QA Automation Framework
if [ -f /etc/init.d/actianzen ]; then
    rm -f /etc/init.d/actianzen
elif [ -d /etc/rc.d/init.d ]; then
    rm -f /etc/rc.d/init.d/actianzen
fi
# **** temp compat with QA Automation Framework

if [ $(uname -s) = "Darwin" ]
then
    /bin/launchctl stop com.actian.mkde

    if cd /Library/LaunchDaemons
    then
        /bin/launchctl unload com.actian.mkde.plist
        rm com.actian.mkde.plist
    fi
else
    systemctl disable actianzen.service
    rm -f /usr/lib/systemd/system/actianzen.service
fi

echo "+++++ Unregistering the PCOM libraries..."

PSREGSVR=psregsvr
if [ -f $ACTIANZEN_ROOT/bin/psregsvr64 ] ; then
    PSREGSVR=psregsvr64
fi

dso_unregister () {
    dso=$1
    if [ -f $ACTIANZEN_ROOT/$LIBDIR/$dso ]; then
        $ACTIANZEN_ROOT/bin/$PSREGSVR -u $ACTIANZEN_ROOT/$LIBDIR/$dso
    fi
}

dso_unregister libpseucjp.${SO_EXTENSION}
dso_unregister libmkc3.${SO_EXTENSION}
dso_unregister libexp010.${SO_EXTENSION}
dso_unregister liblicmgrrb.${SO_EXTENSION}
dso_unregister liblegacylm.${SO_EXTENSION}
dso_unregister libmkderb.${SO_EXTENSION}
dso_unregister libpctlgrb.${SO_EXTENSION}
dso_unregister libcobolschemaexecmsgrb.${SO_EXTENSION}
dso_unregister libpsqlcobolschemaexec.${SO_EXTENSION}
dso_unregister libpceurop.${SO_EXTENSION}
dso_unregister libpssax.${SO_EXTENSION}
dso_unregister libpsdom.${SO_EXTENSION}
dso_unregister libpsutilrb.${SO_EXTENSION}
dso_unregister libclientrb.${SO_EXTENSION}
dso_unregister libupiapirb.${SO_EXTENSION}
dso_unregister libpvmsgrb.${SO_EXTENSION}
dso_unregister libpsqlcsm.${SO_EXTENSION}
dso_unregister libpsqlcsp.${SO_EXTENSION}
dso_unregister libdbcsipxy.${SO_EXTENSION}
dso_unregister libdcm100.${SO_EXTENSION}
dso_unregister libcsi100.${SO_EXTENSION}
dso_unregister libpscp932.${SO_EXTENSION}
dso_unregister libsrderb.${SO_EXTENSION}
echo


echo "+++++ Removing symbolic links to libraries..."

dso_unsymlink () {
    dso=$1
    ver=$2
    found="no"
    if [ -h $ACTIANZEN_ROOT/lib/$dso ]; then
        rm -f $ACTIANZEN_ROOT/lib/$dso
        found="yes"
    fi
    if [ -h $ACTIANZEN_ROOT/lib/$dso.$ver ]; then
        rm -f $ACTIANZEN_ROOT/lib/$dso.$ver
        found="yes"
    fi
    if [ -h $ACTIANZEN_ROOT/lib64/$dso ]; then
        rm -f $ACTIANZEN_ROOT/lib64/$dso
        found="yes"
    fi
    #echo checking $ACTIANZEN_ROOT/lib64/$dso.$ver
    if [ -h $ACTIANZEN_ROOT/lib64/$dso.$ver ]; then
        rm -f $ACTIANZEN_ROOT/lib64/$dso.$ver
        found="yes"
    fi
    if [ "x$found" = "xno" ]; then
        echo unsymlink failed: $dso ver $ver
    fi
}

dso_unsymlink libdbuxlt.${SO_EXTENSION} $PSQL_VER
#dso_unsymlink libiodbc.${SO_EXTENSION} 2
#dso_unsymlink libsdba.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libsrde.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsqlcobolschemaexec.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libodbc.${SO_EXTENSION} 1
if [ $(uname -s) = "Darwin" ]
then
    dso_unsymlink libodbccr.${SO_EXTENSION} 1
fi
dso_unsymlink libodbcci.${SO_EXTENSION} $PSQL_VER
dso_unsymlink pam_pvsw.${SO_EXTENSION} 1
dso_unsymlink libpscore.${SO_EXTENSION} $PS_VER
dso_unsymlink libpscl.${SO_EXTENSION} $PS_VER
dso_unsymlink libpsutilrb.${SO_EXTENSION} $PS_VER
dso_unsymlink libpceurop.${SO_EXTENSION} $PS_VER
dso_unsymlink libpseucjp.${SO_EXTENSION} $PS_VER
dso_unsymlink libpscp932.${SO_EXTENSION} $PS_VER
dso_unsymlink libpssax.${SO_EXTENSION} $PS_VER
dso_unsymlink libpsdom.${SO_EXTENSION} $PS_VER
dso_unsymlink libxlate.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsqldti.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libclientlm.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpasupt.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libbtrieveC.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libbtrieveCpp.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libeasysyncapi.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsqlmif.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsqlnsl.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsxdebug.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpctlgrb.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libcobolschemaexecmsgrb.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libclientrb.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libupiapirb.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpvmsgrb.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libdcm100.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libcsi100.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsqlcsm.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsqlcsp.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libdbcsipxy.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libenginelm.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libels.${SO_EXTENSION} $PSQL_VER
dso_unsymlink liblegacylm.${SO_EXTENSION} $PSQL_VER
dso_unsymlink liblicmgrrb.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libmkdemd.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsqlmpm.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpvisr.${SO_EXTENSION} $PSQL_VER

dso_unsymlink libbdulb.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libexp010.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libjavadti.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libjnibtrv.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libmkc3.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libmkderb.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libnotifysupt.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpam.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpvjdbc2.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpvswcore.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libsqlmgr.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libsrderb.${SO_EXTENSION} $PSQL_VER

echo
# At this point it should be safe to remove files
echo "+++++ Removing Zen files..."
HOMEDIR=`grep "^zen-svc:" /etc/passwd | cut -d: -f6`
rm -f  $HOMEDIR/.cshrc
rm -f  $HOMEDIR/.bash_profile
rm -f  $HOMEDIR/.bash_history
rm -f  $HOMEDIR/.bashrc

rm -f  $ACTIANZEN_ROOT/pvinst.log
rm -f  $ACTIANZEN_ROOT/LICENSE
rm -f  $ACTIANZEN_ROOT/Zen_Third_Party_Notice
rm -Rf $ACTIANZEN_ROOT/bin
rm -Rf $ACTIANZEN_ROOT/data/DEMODATA
rm -Rf $ACTIANZEN_ROOT/data/TEMPDB
# PSQL-10998: Remove samples and system dirs too.
rm -Rf  $ACTIANZEN_ROOT/data/samples
rm -Rf $ACTIANZEN_ROOT/data/system/restore
rm -Rf $ACTIANZEN_ROOT/data/system
rmdir $ACTIANZEN_ROOT/data 2>/dev/null
rm -Rf $ACTIANZEN_ROOT/docs
rm -f  $ACTIANZEN_ROOT/etc/confmig.log
rm -f  $ACTIANZEN_ROOT/etc/sqlmgr.pid
rm -f  $ACTIANZEN_ROOT/etc/install.sh
rm -f  $ACTIANZEN_ROOT/etc/uninstall.sh
rm -f  $ACTIANZEN_ROOT/etc/postinstall.cfg
rm -f  $ACTIANZEN_ROOT/etc/psql-unixODBC-2.2.11.tar.gz
rm -Rf $ACTIANZEN_ROOT/etc/pipe
rm -Rf $ACTIANZEN_ROOT/etc/init.d
rm -Rf $ACTIANZEN_ROOT/lib
rm -Rf $ACTIANZEN_ROOT/lib64
rm -Rf $ACTIANZEN_ROOT/log
rm -Rf $ACTIANZEN_ROOT/jre
rm -Rf $ACTIANZEN_ROOT/man
rm -Rf $ACTIANZEN_ROOT/schemas
echo

rm -f /etc/init.d/actianzen /etc/rc.d/init.d/actianzen /usr/lib/ocf/resource.d/heartbeat/actianzen

# remove lock file directory (Debian Linux uses a different lock file directory then the other flavors of Linux)
if [ -d /var/lock/subsys ] ; then
    rm -f /var/lock/subsys/actianzen
else
    if [ $(uname -s) = "Darwin" ]
    then
        rm -f /var/tmp/actianzen
    else
        rm -f /var/state/actianzen
    fi
fi
SERVICES=/etc/services
if [ -f $SERVICES ] ; then
    sed '/PSQL MKDE daemon/d' $SERVICES > /tmp/services
    mv -f /tmp/services $SERVICES
fi
echo


echo "+++++ Removing Zen PAM settings..."

PAMCONF=/etc/pam.conf
PAMDIR=/etc/pam.d
if [ -f $PAMCONF ] ; then
    FOUND=`grep -c "^pvsw64" $PAMCONF`
    if [ $? -eq 0 ] ; then
	sed '/^pvsw64/d' $PAMCONF > /tmp/pam.conf
	mv -f /tmp/pam.conf $PAMCONF
    fi
fi
rm -f $PAMDIR/pvsw64
rm -f $PAMDIR/pvswauth
rm -f /$LIBDIR/security/pvswauth
rm -f /$LIBDIR/security/pam_pvsw.${SO_EXTENSION}*
if [ $(uname -s) = "Darwin" ]
then
    rm -f /usr/lib/pvswauth
    rm -f /usr/lib/pam_pvsw.${SO_EXTENSION}*
fi
echo

# If this is Darwin.
if [ $(uname -s) = "Darwin" ]
then
    APPLICATIONS="/Applications"

    # If there is an applications directory.
    if [ -d "$APPLICATIONS" ]
    then
        ACTIAN_ZEN_15="$APPLICATIONS/Actian Zen 15"
        UTILITIES="$ACTIAN_ZEN_15/Utilities"
        SCRIPTS="$ACTIAN_ZEN_15/Scripts"
        echo "+++++ Unpopulating the \"$ACTIAN_ZEN_15\" directory...."
        ERROR=0

        # If removing "Zen "Repair.app" fails.
        if ! rm -r "$SCRIPTS/Zen Repair.app" || ! rm "$SCRIPTS/.repair"
        then
            ERROR=1
        fi

        # If removing "Zen Authorize.app" fails.
        if ! rm -r "$SCRIPTS/Zen Authorize.app" || ! rm "$SCRIPTS/.authorize"
        then
            ERROR=1
        fi

        # If removing "Zen Licenses.app" fails.
        if ! rm -r "$SCRIPTS/Zen Licenses.app" || ! rm "$SCRIPTS/.licenses"
        then
            ERROR=1
        fi

        # If removing "Zen Deauthorize.app" fails.
        if ! rm -r "$SCRIPTS/Zen Deauthorize.app" || ! rm "$SCRIPTS/.deauthorize"
        then
            ERROR=1
        fi

        # If removing "Zen Start.app" fails.
        if ! rm -r "$SCRIPTS/Zen Start.app" || ! rm "$SCRIPTS/.start"
        then
            ERROR=1
        fi

        # If removing "Zen Status.app" fails.
        if ! rm -r "$SCRIPTS/Zen Status.app" || ! rm "$SCRIPTS/.status"
        then
            ERROR=1
        fi

        # If removing "Zen Stop.app" fails.
        if ! rm -r "$SCRIPTS/Zen Stop.app" || ! rm "$SCRIPTS/.stop"
        then
            ERROR=1
        fi

        # If removing "Zen Restart.app" fails.
        if ! rm -r "$SCRIPTS/Zen Restart.app" || ! rm "$SCRIPTS/.restart"
        then
            ERROR=1
        fi

        # If removing "messages" fails.
        if ! rm "$SCRIPTS/.messages"
        then
            ERROR=1
        fi

        # If removing ".DS_Store" fails.
        if ! rm -f "$SCRIPTS/.DS_Store"
        then
            ERROR=1
        fi

        # If removing "$SCRIPTS" fails.
        if ! rmdir "$SCRIPTS"
        then
            ERROR=1
        fi

        # If removing "Zen Phone Authorization.app" fails.
        if ! rm -r "$UTILITIES/Zen Phone Authorization.app"
        then
            ERROR=1
        fi

        # If removing "Zen Notification Viewer.app" fails.
        if ! rm -r "$UTILITIES/Zen Notification Viewer.app"
        then
            ERROR=1
        fi

        # If removing "Zen DDF Builder.app" fails.
        if ! rm -r "$UTILITIES/Zen DDF Builder.app"
        then
            ERROR=1
        fi

        # If removing ".DS_Store" fails.
        if ! rm -f "$UTILITIES/.DS_Store"
        then
            ERROR=1
            fi

        # If removing "$UTILITIES" fails.
        if ! rmdir "$UTILITIES"
        then
            ERROR=1
        fi

        # If removing "Zen Control Center.app" fails.
        if ! rm -r "$ACTIAN_ZEN_15/Zen Control Center.app"
        then
            ERROR=1
        fi

        # If removing "Zen Uninstall.app" fails.
        if ! rm -r "$ACTIAN_ZEN_15/Zen Uninstall.app" || ! rm "$ACTIAN_ZEN_15/.uninstall"
        then
            ERROR=1
        fi

        # If removing "messages" fails.
        if ! rm "$ACTIAN_ZEN_15/.messages"
        then
            ERROR=1
        fi

        # If removing ".DS_Store" fails.
        if ! rm -f "$ACTIAN_ZEN_15/.DS_Store"
        then
            ERROR=1
        fi

        # If removing "$ACTIAN_ZEN_15" fails.
        if ! rmdir "$ACTIAN_ZEN_15"
        then
            ERROR=1
        fi

        # If there were any errors.
        if [ "$ERROR" -eq 1 ]
        then
            echo "Error: Unable to correctly unpopulate the \"$ACTIAN_ZEN_15\" directory."
            exit 1
        fi

        echo
    fi
fi

echo "+++++ Uninstall has successfully completed."
echo
