/**
 * This system procedure is used to return the
 * the table rights for the given table(s).
 */
CREATE PROCEDURE psp_table_rights
(  
    in :database_qual   VARCHAR(20) = DATABASE(), -- Name of the database
    in :table_name      VARCHAR(255) = NULL, -- Name of the table
    in :user_name       VARCHAR(255) = USER() -- Name of the user
)
RETURNS
(
    TABLE_QUALIFIER     VARCHAR (20), -- Name of the database that contains the table
    TABLE_OWNER         VARCHAR (20),  -- owner of the table
    USER_NAME           CHAR(255), -- Name of the user
    TABLE_NAME          CHAR(255), -- Name of the table
    RIGHTS              VARCHAR(12)  -- Table rights 
);
BEGIN

	-- This variable stores the dynamic query
	DECLARE :query              LONGVARCHAR;
    
	-- This variable stores the table name concatenated with 
	-- the database qualifier in the form dbname.tablename
    DECLARE :file_table_name    VARCHAR(30);
    DECLARE :rights_table_name  VARCHAR(30);
    DECLARE :user_table_name    VARCHAR(30);

	-- This variable stores the metadata version
    DECLARE :version           INTEGER;

    -- If the database qualifier is null, then use the current database
	if (:database_qual is null) then
		set :database_qual = DATABASE();
	end if;
	
    -- Check if the database qualifier specified is a blank string
	if (rtrim(:database_qual) = '') then
		SIGNAL 'S1000', 'Please enter a valid database name. Database name cannot be a blank string'; 
	end if;
    
    -- Check if the column name is a blank string
	if (rtrim(:table_name) = '') then
		SIGNAL 'S1000', 'Table name cannot be blank string';
	end if;		
    
    -- Check if the user name is a blank string
	if (rtrim(:user_name) = '') then
		SIGNAL 'S1000', 'User name cannot be a blank string';
	end if;
	
	   
    SET :file_table_name = '"' + :database_qual + '".X$File';
    SET :rights_table_name = '"' + :database_qual + '".X$Rights';
    SET :user_table_name = '"' + :database_qual + '".X$User';
    
	/* If table name is not supplied or value is null
	   match all the tables*/
	   
    SET :table_name = IFNULL(:table_name,'%');
    SET :user_name = IFNULL(:user_name , USER());
    
    -- call procedure to find the metadata version and store it in a variable
    CALL psp_database_version(:database_qual, :version);

    if (:version = 1) then  
        -- Metadata version is V1

	/* Enumerate the table rights */
                 -- SELECT rights for Table
    SET :query = 'SELECT ''' + :database_qual + ''' , null, ' +
        		 'B.Xu$Name, A.Xf$Name, ''SELECT'' ' +
            	 'FROM ' + :file_table_name + ' A, ' + 
                 :user_table_name + ' B, ' + :rights_table_name +
                 ' C WHERE 	A.Xf$Name LIKE ''' + :table_name +
                 ''' AND B.Xu$Name LIKE ''' + :user_name +
                 ''' AND A.Xf$Id = C.Xr$Table AND B.Xu$Id = C.Xr$User ' +
                 'AND C.Xr$rights & 64 = 64 AND	C.Xr$Column = 0 ' +
                 -- REFERENCES rights for Table
                 'UNION	SELECT ''' + :database_qual +
                 ''' , null, B.Xu$Name, A.Xf$Name, ''REFERENCES'' ' +
            	 'FROM ' + :file_table_name + ' A, ' + :user_table_name +
                 ' B, ' + :rights_table_name + ' C WHERE A.Xf$Name LIKE ''' +
                 :table_name + ''' AND	B.Xu$Name LIKE ''' + :user_name +
                 ''' AND A.Xf$Id = C.Xr$Table AND B.Xu$Id = C.Xr$User AND ' +
        		 'C.Xr$rights & 144 = 144 AND ' +	
        		 'C.Xr$Column = 0 ' +
                 -- ALTER rights for Table
                 'UNION SELECT ''' + :database_qual + 
                 ''', null, B.Xu$Name, A.Xf$Name, ''ALTER'' FROM ' + 
                 :file_table_name + ' A, ' + :user_table_name + ' B, ' 
                 + :rights_table_name + ' C WHERE 	A.Xf$Name LIKE ''' + 
                 :table_name + ''' AND B.Xu$Name LIKE ''' + :user_name + 
                 ''' AND A.Xf$Id = C.Xr$Table ' +
                 'AND B.Xu$Id = C.Xr$User AND C.Xr$rights & 160 = 160 AND ' +	
        		 'C.Xr$Column = 0 ' + 
                 -- UPDATE rights for Table
                 'UNION	SELECT ''' + :database_qual + ''', null, B.Xu$Name, ' +
                 'A.Xf$Name, ''UPDATE'' FROM ' + :file_table_name +
                 ' A, ' + :user_table_name + ' B, ' + :rights_table_name + 
                 ' C WHERE	A.Xf$Name LIKE ''' + :table_name + 
                 ''' AND	B.Xu$Name LIKE ''' + :user_name + 
                 ''' AND A.Xf$Id = C.Xr$Table AND	B.Xu$Id = C.Xr$User AND ' +
        		 'C.Xr$rights & 130 = 130 AND ' +	
        		 'C.Xr$Column = 0 ' +
                 -- INSERT rights for Table
                 'UNION	SELECT ''' + :database_qual + ''' , ' +
                 'null, B.Xu$Name, A.Xf$Name, ''INSERT'' FROM ' + 
                 :file_table_name + ' A, ' +
                 :user_table_name + ' B, ' + :rights_table_name + ' C ' +
            	 'WHERE 	A.Xf$Name LIKE ''' + :table_name + 
                 ''' AND	B.Xu$Name ' +
                 'LIKE ''' + :user_name + ''' AND A.Xf$Id = C.Xr$Table AND ' +
                 'B.Xu$Id = C.Xr$User AND C.Xr$rights & 132 = 132 AND ' +	
        		 'C.Xr$Column = 0 ' + 
                  -- DELETE rights for Table
                 'UNION	SELECT ''' + :database_qual + ''', ' +
        		 'null, B.Xu$Name, 	A.Xf$Name, ''DELETE'' FROM ' + 
                 :file_table_name + ' A, ' + :user_table_name + ' B, ' + 
                 :rights_table_name + ' C WHERE	A.Xf$Name LIKE ''' + 
                 :table_name + ''' AND	B.Xu$Name ' +
                 'LIKE ''' + :user_name + ''' AND A.Xf$Id = C.Xr$Table AND ' +
            	 'B.Xu$Id = C.Xr$User AND C.Xr$rights & 136 = 136 AND ' +	
            	 'C.Xr$Column = 0'	;
    else 
        if (:version = 2) then  
            -- Metadata version is V2

            /* Enumerate the table rights */
                         -- SELECT rights for Table
            SET :query = 'SELECT ''' + :database_qual + ''' , null, ' +
                         'B.Xu$Name, A.Xf$Name, ''SELECT'' ' +
                         'FROM ' + :file_table_name + ' A, ' + 
                         :user_table_name + ' B, ' + :rights_table_name +
                         ' C WHERE 	A.Xf$Name LIKE ''' + :table_name +
                         ''' AND B.Xu$Name LIKE ''' + :user_name +
                         ''' AND A.Xf$Id = C.Xr$Object AND B.Xu$Id = C.Xr$User ' +
                         'AND C.Xr$rights & 64 = 64 AND	C.Xr$Column = 0 AND C.Xr$Type = 1 ' +
                         -- REFERENCES rights for Table
                         'UNION	SELECT ''' + :database_qual +
                         ''' , null, B.Xu$Name, A.Xf$Name, ''REFERENCES'' ' +
                         'FROM ' + :file_table_name + ' A, ' + :user_table_name +
                         ' B, ' + :rights_table_name + ' C WHERE A.Xf$Name LIKE ''' +
                         :table_name + ''' AND	B.Xu$Name LIKE ''' + :user_name +
                         ''' AND A.Xf$Id = C.Xr$Object AND B.Xu$Id = C.Xr$User AND ' +
                         'C.Xr$rights & 144 = 144 AND ' +	
                         'C.Xr$Column = 0 AND C.Xr$Type = 1 ' +
                         -- ALTER rights for Table
                         'UNION SELECT ''' + :database_qual + 
                         ''', null, B.Xu$Name, A.Xf$Name, ''ALTER'' FROM ' + 
                         :file_table_name + ' A, ' + :user_table_name + ' B, ' 
                         + :rights_table_name + ' C WHERE 	A.Xf$Name LIKE ''' + 
                         :table_name + ''' AND B.Xu$Name LIKE ''' + :user_name + 
                         ''' AND A.Xf$Id = C.Xr$Object ' +
                         'AND B.Xu$Id = C.Xr$User AND C.Xr$rights & 160 = 160 AND ' +	
                         'C.Xr$Column = 0 AND C.Xr$Type = 1 ' + 
                         -- UPDATE rights for Table
                         'UNION	SELECT ''' + :database_qual + ''', null, B.Xu$Name, ' +
                         'A.Xf$Name, ''UPDATE'' FROM ' + :file_table_name +
                         ' A, ' + :user_table_name + ' B, ' + :rights_table_name + 
                         ' C WHERE	A.Xf$Name LIKE ''' + :table_name + 
                         ''' AND	B.Xu$Name LIKE ''' + :user_name + 
                         ''' AND A.Xf$Id = C.Xr$Object AND	B.Xu$Id = C.Xr$User AND ' +
                         'C.Xr$rights & 130 = 130 AND ' +	
                         'C.Xr$Column = 0 AND C.Xr$Type = 1 ' +
                         -- INSERT rights for Table
                         'UNION	SELECT ''' + :database_qual + ''' , ' +
                         'null, B.Xu$Name, A.Xf$Name, ''INSERT'' FROM ' + 
                         :file_table_name + ' A, ' +
                         :user_table_name + ' B, ' + :rights_table_name + ' C ' +
                         'WHERE 	A.Xf$Name LIKE ''' + :table_name + 
                         ''' AND	B.Xu$Name ' +
                         'LIKE ''' + :user_name + ''' AND A.Xf$Id = C.Xr$Object AND ' +
                         'B.Xu$Id = C.Xr$User AND C.Xr$rights & 132 = 132 AND ' +	
                         'C.Xr$Column = 0 AND C.Xr$Type = 1 ' + 
                          -- DELETE rights for Table
                         'UNION	SELECT ''' + :database_qual + ''', ' +
                         'null, B.Xu$Name, 	A.Xf$Name, ''DELETE'' FROM ' + 
                         :file_table_name + ' A, ' + :user_table_name + ' B, ' + 
                         :rights_table_name + ' C WHERE	A.Xf$Name LIKE ''' + 
                         :table_name + ''' AND	B.Xu$Name ' +
                         'LIKE ''' + :user_name + ''' AND A.Xf$Id = C.Xr$Object AND ' +
                         'B.Xu$Id = C.Xr$User AND C.Xr$rights & 136 = 136 AND ' +	
                         'C.Xr$Column = 0 AND C.Xr$Type = 1 '	;
        end if;                     
    end if;
    
    exec(:query);

END; -- End of the stored procedure.


