/**
 * This system procedure is used to return the 
 * definition text of the view from the database specified.
 */
CREATE PROCEDURE psp_help_view
(
    in :database_qual   VARCHAR(20) = DATABASE(), -- Database name
    in :view_name       VARCHAR(254) -- Name of the view
)

RETURNS
(
    DATABASE_QUALIFIER  VARCHAR(20), -- Database name
    VIEW_TEXT LONGVARCHAR  -- Definition text of the view
);

BEGIN
	-- This variable stores the dynamic query
	DECLARE :query      LONGVARCHAR;
    
	-- This variable stores the table name concatenated with 
	-- the database qualifier in the form dbname.tablename
    DECLARE :table_name VARCHAR(30);

    -- This variable stores the metadata version
    DECLARE :version           INTEGER;

    -- If the database qualifier is null, use the current database
	if (:database_qual is null) then
		set :database_qual = DATABASE();
	end if;
	
    -- Check if the database qualifier is a blank string
	if (rtrim(:database_qual) = '') then
		SIGNAL 'S1000', 'Please enter a valid database name. Database name cannot be a blank string'; 
	end if;

    -- Check if view name is null
	if (:view_name is null) then
		SIGNAL 'S1000', 'View name cannot be null';
	end if;
    
    -- Check if the view name is a blank string
	if (rtrim(:view_name) = '') then
		SIGNAL 'S1000', 'View name cannot be blank string';
	end if;		
	
    set :table_name = '"' + :database_qual + '".X$View' 
	
    -- call procedure to find the metadata version and store it in a variable
    CALL psp_database_version(:database_qual, :version);
   
    if (:version = 1) then  
        -- Metadata version is V1
	
    set :query = 'SELECT ''' + :database_qual + ''', Xv$Misc FROM ' + 
                 :table_name + ' WHERE Xv$Name LIKE ''' + :view_name +
                 ''' ORDER BY Xv$Id ';
    else 
        if (:version = 2) then  
   	    -- Metadata version is V2
	    
	    set :query = 'SELECT ''' + :database_qual + ''', Xv$Misc FROM ' + 
                 :table_name + ' WHERE Xv$Name LIKE ''' + :view_name +
                 ''' ORDER BY Xv$Sequence ';
		end if;                     
    end if;
    
    exec (:query);		
		
END; -- End of the stored procedure.

