/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.guipaadm.pages;

import com.pervasive.ui.validaters.TextChangeListener;
import com.pervasive.ui.validaters.ValidationEvent;
import com.pervasive.ui.validaters.VetoEvent;
import com.pervasive.utilities.guipaadm.PSResultException;
import com.pervasive.utilities.guipaadm.PhoneActivationState;
import com.pervasive.utilities.guipaadm.PhoneActivationSupport;
import com.pervasive.utilities.guipaadm.SegmentedTextEntry;
import com.pervasive.utilities.util.GridHelper;
import com.pervasive.utilities.util.MessageCatalog;
import com.pervasive.utilities.wizard.WizardPageExt;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ProductKeyPage
extends WizardPageExt
implements TextChangeListener {
    private static final String BASE36_ALPHABET = "ABCDEFGHIJKLMPQRSTUVWXYZ123456789";
    private SegmentedTextEntry productKeyEntry;

    public ProductKeyPage() {
        super("ProductKeyPage", MessageCatalog.getMsg("ProductKeyPage.Title"), MessageCatalog.getMsg("ProductKeyPage.Desc"), null);
        this.setPageComplete(false);
    }

    @Override
    public void createContent(Composite composite) {
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.verticalSpacing = 20;
        Label label = new Label(composite, 64);
        GridHelper.layoutFillHorizontal((Control)label, 440, 0);
        label.setText(MessageCatalog.getMsg("ProductKeyPage.Text"));
        Composite composite2 = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 7;
        gridLayout.horizontalSpacing = 0;
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        Label label2 = new Label(composite2, 0);
        label2.setText(MessageCatalog.getMsg("ProductKeyPage.EntryLabel"));
        this.productKeyEntry = new SegmentedTextEntry(composite2, 6, 5, BASE36_ALPHABET);
        GridHelper gridHelper = new GridHelper((Control)this.productKeyEntry);
        gridHelper.setHorizontalIndent(20);
        this.productKeyEntry.addTextChangedListener(this);
    }

    @Override
    public void populate() {
        this.productKeyEntry.grabFocus();
    }

    @Override
    public void applyPage() {
        PageProcessor pageProcessor = new PageProcessor(this.productKeyEntry.getText());
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)pageProcessor);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void vetoEventOccurred(VetoEvent vetoEvent) {
        boolean bl = vetoEvent.wasVetoed();
        if (bl) {
            this.setErrorMessage(vetoEvent.getVetoReason());
        } else {
            this.setErrorMessage(null);
        }
    }

    @Override
    public void validationEventOccurred(ValidationEvent validationEvent) {
        boolean bl = validationEvent.getValidState();
        if (!bl) {
            this.setErrorMessage(validationEvent.getInvalidReason());
        } else {
            try {
                String string = this.productKeyEntry.getText();
                bl = PhoneActivationSupport.isValidProductKey(string);
            }
            catch (PSResultException pSResultException) {
                PhoneActivationState phoneActivationState = (PhoneActivationState)this.getModel();
                phoneActivationState.setErrorCode(pSResultException.getErrorCode());
            }
            if (!bl) {
                this.setErrorMessage(MessageCatalog.getMsg("ProductKeyPage.InvalidProductKeyMsg"));
            } else {
                this.setErrorMessage(null);
            }
        }
        this.setPageComplete(bl);
    }

    private int attemptOnlineActivation(String string) {
        int n = 0;
        try {
            PhoneActivationSupport.pvAddLicense(string);
        }
        catch (PSResultException pSResultException) {
            n = pSResultException.getErrorCode();
        }
        return n;
    }

    private short getRemainingUsageCounts(String string) {
        short s = -2;
        try {
            s = PhoneActivationSupport.getRemainingUsageCount(string);
        }
        catch (PSResultException pSResultException) {
            // empty catch block
        }
        return s;
    }

    class PageProcessor
    implements IRunnableWithProgress {
        private String productKey;

        PageProcessor(String string) {
            this.productKey = string;
        }

        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
            iProgressMonitor.beginTask(MessageCatalog.getMsg("ProductKeyPage.ProductKeyTaskLabel"), -1);
            PhoneActivationState phoneActivationState = (PhoneActivationState)ProductKeyPage.this.getModel();
            phoneActivationState.setErrorCode(0);
            phoneActivationState.setProductKey(this.productKey);
            int n = 0;
            try {
                n = PhoneActivationSupport.checkApplyProductKey(this.productKey);
            }
            catch (PSResultException pSResultException) {
                n = pSResultException.getErrorCode();
            }
            if (n != 0) {
                phoneActivationState.setErrorCode(n);
                iProgressMonitor.done();
                return;
            }
            if (Boolean.parseBoolean(MessageCatalog.getMsg("OnlineCheck"))) {
                iProgressMonitor.setTaskName(MessageCatalog.getMsg("ProductKeyPage.OnlineActivationTaskLabel"));
                n = ProductKeyPage.this.attemptOnlineActivation(this.productKey);
                if (n == 0) {
                    phoneActivationState.setActivatedOnline(true);
                    phoneActivationState.setRemainingUsageCount(ProductKeyPage.this.getRemainingUsageCounts(this.productKey));
                    iProgressMonitor.done();
                    return;
                }
                if (n != 7239) {
                    phoneActivationState.setErrorCode(n);
                    iProgressMonitor.done();
                    return;
                }
            }
            phoneActivationState.setActivatedOnline(false);
            try {
                String string = PhoneActivationSupport.computeAuthorizationCode(this.productKey);
                phoneActivationState.setAuthorizationCode(string);
            }
            catch (PSResultException pSResultException) {
                phoneActivationState.setErrorCode(pSResultException.getErrorCode());
            }
            iProgressMonitor.done();
        }
    }
}

