/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.guipaadm.pages;

import com.pervasive.ui.validaters.TextChangeListener;
import com.pervasive.ui.validaters.ValidationEvent;
import com.pervasive.ui.validaters.VetoEvent;
import com.pervasive.utilities.guipaadm.PSResultException;
import com.pervasive.utilities.guipaadm.PhoneActivationApp;
import com.pervasive.utilities.guipaadm.PhoneActivationState;
import com.pervasive.utilities.guipaadm.PhoneActivationSupport;
import com.pervasive.utilities.guipaadm.SegmentedTextEntry;
import com.pervasive.utilities.util.GridHelper;
import com.pervasive.utilities.util.MessageCatalog;
import com.pervasive.utilities.wizard.WizardPageExt;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AuthCodePage
extends WizardPageExt
implements TextChangeListener {
    private static final String BASE24_ALPHABET = "2346789BCDFGHJKMPQRTVWXY";
    private static final String BASE24_ALPHABET_JP = "2345678ACDFGHJKMPQRTUWXY";
    private Text productKeyTxt;
    private Text authCodeTxt;
    private SegmentedTextEntry activationKeyEntry;
    private String licenseKey;

    public AuthCodePage() {
        super("AuthCodePage", MessageCatalog.getMsg("AuthCodePage.Title"), MessageCatalog.getMsg("AuthCodePage.Desc"), null);
        this.setPageComplete(false);
    }

    @Override
    public String getNextButtonLabel() {
        return MessageCatalog.getMsg("AuthCodePage.NextLabel");
    }

    @Override
    public void createContent(Composite composite) {
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.verticalSpacing = 7;
        Label label = new Label(composite, 64);
        GridHelper.layoutFillHorizontal((Control)label, 440, 0);
        label.setText(MessageCatalog.getMsg("AuthCodePage.Text"));
        this.createProductKeyGroup(composite);
        this.createAuthCodeGroup(composite);
        this.createActivationKeyGroup(composite);
        Label label2 = new Label(composite, 64);
        GridHelper.layoutFillHorizontal((Control)label2, -1, 0);
        label2.setText(MessageCatalog.getMsg("AuthCodePage.ActivateText"));
    }

    @Override
    public void vetoEventOccurred(VetoEvent vetoEvent) {
        boolean bl = vetoEvent.wasVetoed();
        if (bl) {
            this.setErrorMessage(vetoEvent.getVetoReason());
        } else {
            this.setErrorMessage(null);
        }
    }

    @Override
    public void validationEventOccurred(ValidationEvent validationEvent) {
        boolean bl = validationEvent.getValidState();
        if (!bl) {
            this.setErrorMessage(validationEvent.getInvalidReason());
        } else {
            this.setErrorMessage(null);
        }
        this.licenseKey = null;
        if (bl) {
            try {
                String string = this.activationKeyEntry.getText();
                boolean bl2 = Locale.getDefault().getLanguage().equals(new Locale("ja", "", "").getLanguage());
                if (bl2) {
                    string = "JP" + string;
                }
                this.licenseKey = PhoneActivationSupport.decodeActivationData(string);
            }
            catch (PSResultException pSResultException) {
                bl = false;
                this.setErrorMessage(MessageCatalog.getMsg("AuthCodePage.InvalidActKey"));
            }
        }
        this.setPageComplete(bl);
    }

    @Override
    public void populate() {
        PhoneActivationState phoneActivationState = (PhoneActivationState)this.getModel();
        this.productKeyTxt.setText(this.hyphenate(phoneActivationState.getProductKey(), 5));
        String string = this.authCodeTxt.getText();
        if (!string.equals(phoneActivationState.getAuthorizationCode())) {
            this.activationKeyEntry.clear();
        }
        this.authCodeTxt.setText(phoneActivationState.getAuthorizationCode());
        this.activationKeyEntry.grabFocus();
    }

    @Override
    public void applyPage() {
        PageProcessor pageProcessor = new PageProcessor();
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)pageProcessor);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createProductKeyGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridHelper.layoutFillHorizontal((Control)composite2, -1, 0);
        Label label = new Label(composite2, 0);
        GridHelper.layoutFillHorizontal((Control)label, 440, 0);
        label.setText(MessageCatalog.getMsg("AuthCodePage.ProductKeyHeading"));
        this.productKeyTxt = new Text(composite2, 12);
        PhoneActivationApp.getFontRegistry().put("textfont", this.productKeyTxt.getFont().getFontData());
        this.productKeyTxt.setFont(PhoneActivationApp.getFontRegistry().getBold("textfont"));
        this.productKeyTxt.setBackground(label.getBackground());
        GridHelper.layoutFillHorizontal((Control)this.productKeyTxt, -1, 20);
    }

    private void createAuthCodeGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridHelper.layoutFillHorizontal((Control)composite2, -1, 0);
        Label label = new Label(composite2, 0);
        GridHelper.layoutFillHorizontal((Control)label, 440, 0);
        label.setText(MessageCatalog.getMsg("AuthCodePage.AuthCodeHeading"));
        this.authCodeTxt = new Text(composite2, 12);
        this.authCodeTxt.setFont(PhoneActivationApp.getFontRegistry().getBold("textfont"));
        this.authCodeTxt.setBackground(label.getBackground());
        GridHelper.layoutFillHorizontal((Control)this.authCodeTxt, -1, 20);
    }

    private void createActivationKeyGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing += 2;
        composite2.setLayout((Layout)gridLayout);
        GridHelper.layoutFillHorizontal((Control)composite2, -1, 0);
        Label label = new Label(composite2, 0);
        label.setText(MessageCatalog.getMsg("AuthCodePage.ActivationKeyHeading"));
        boolean bl = Locale.getDefault().getLanguage().equals(new Locale("ja", "", "").getLanguage());
        String string = bl ? BASE24_ALPHABET_JP : BASE24_ALPHABET;
        this.activationKeyEntry = new SegmentedTextEntry(composite2, 6, 5, string, bl ? "JP" : null);
        GridHelper gridHelper = new GridHelper((Control)this.activationKeyEntry);
        gridHelper.setHorizontalIndent(20);
        this.activationKeyEntry.addTextChangedListener(this);
    }

    private String hyphenate(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.append(string.charAt(i));
            int n2 = i + 1;
            if (n2 >= string.length() || n2 % n != 0) continue;
            stringBuilder.append('-');
        }
        return stringBuilder.toString();
    }

    class PageProcessor
    implements IRunnableWithProgress {
        PageProcessor() {
        }

        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
            iProgressMonitor.beginTask(MessageCatalog.getMsg("AuthCodePage.ActivatingProductTaskLabel"), -1);
            PhoneActivationState phoneActivationState = (PhoneActivationState)AuthCodePage.this.getModel();
            try {
                PhoneActivationSupport.pvAddLicenseEntry(phoneActivationState.getProductKey(), AuthCodePage.this.licenseKey);
            }
            catch (PSResultException pSResultException) {
                phoneActivationState.setErrorCode(pSResultException.getErrorCode());
            }
            iProgressMonitor.done();
        }
    }
}

