/*
 * Decompiled with CFR 0.152.
 */
package pervasive.database;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import pervasive.database.DBUtil;
import pervasive.database.Database;
import pervasive.database.IBTRV;
import pervasive.database.IOBuffer;
import pervasive.database.MessageCatalog;
import pervasive.database.OpResult;
import pervasive.database.PsqlIOException;
import pervasive.database.PsqlInvalidObjectException;
import pervasive.database.PsqlOperationException;
import pervasive.database.Session;
import pervasive.database.Timestamp;

public class SCursor {
    public static final int MAX_BUFFER = 64129;
    IOBuffer m_dBuffer;
    IOBuffer m_kBuffer;
    IOBuffer m_posBlock;
    short m_keyNumber = 0;
    int m_bytesRcvd;
    private static final int DATA_BUFFER_SIZE = 64129;
    private static final int DEFAULT_KEY_SIZE = 255;
    private static final int POSITION_BLOCK_SIZE = 128;
    private static final int UPDATE_CHUNK_RCD_SIZE = 20 + (DBUtil.is64BitVM() ? 4 : 0);
    private static final int GET_CHUNK_RCD_SIZE = 24 + (DBUtil.is64BitVM() ? 4 : 0);
    protected IBTRV m_btrvObj;
    private int m_dataBufSize;
    private short m_keyBufSize;
    private boolean m_fileOpened = false;
    private boolean m_objClosed = false;
    private OpResult m_opResults = new OpResult();
    private int m_sendLength;
    private int m_recvLength;
    private short m_keyLength;
    private byte[] m_clientID;
    private Database m_parent;
    protected String m_charsetName;
    static final byte[] DEFAULT_CLIENT_ID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 67, 0, 0};

    SCursor(Database database, IBTRV iBTRV, int n, String string) {
        this(database, iBTRV, n, 255, string);
    }

    SCursor(Database database, IBTRV iBTRV, int n, int n2, String string) {
        this.m_parent = database;
        this.setDataSize(n);
        this.setKeySize(n2);
        this.m_btrvObj = iBTRV;
        this.m_dBuffer = iBTRV.createIOBuffer(64129, string);
        this.m_kBuffer = iBTRV.createIOBuffer(255, string);
        this.m_posBlock = iBTRV.createIOBuffer(128, "US-ASCII");
        this.m_clientID = this.m_parent != null ? this.getSession().getClientID() : DEFAULT_CLIENT_ID;
    }

    SCursor(Session session, IBTRV iBTRV, int n, int n2, String string) {
        this.setDataSize(n);
        this.setKeySize(n2);
        this.m_btrvObj = iBTRV;
        this.m_dBuffer = iBTRV.createIOBuffer(64129, string);
        this.m_kBuffer = iBTRV.createIOBuffer(255, string);
        this.m_posBlock = iBTRV.createIOBuffer(128, "US-ASCII");
        this.m_clientID = session.getClientID();
    }

    public Database getDatabase() {
        return this.m_parent;
    }

    public Session getSession() {
        if (this.m_parent != null) {
            return this.getDatabase().getSession();
        }
        return null;
    }

    public void setDataSize(int n) {
        if (n > 64129 || n < 0) {
            throw new IllegalArgumentException(MessageCatalog.getIllegalArgumentMsg(this, "setDataSize", "dataBufSize", Integer.toString(n)));
        }
        this.m_dataBufSize = n;
    }

    public int getDataSize() {
        return this.m_dataBufSize;
    }

    public void setKeySize(int n) {
        if (n > 1024 || n < 0) {
            throw new IllegalArgumentException(MessageCatalog.getIllegalArgumentMsg(this, "setKeySize", "keyBufSize", Integer.toString(n)));
        }
        this.m_keyBufSize = (short)n;
    }

    public int getKeySize() {
        return this.m_keyBufSize;
    }

    public void setKeyNumber(int n) {
        if (n < 256) {
            this.m_keyNumber = (short)n;
        }
    }

    public int getKeyNumber() {
        return this.m_keyNumber;
    }

    public int getAddress() {
        return this.m_opResults.position;
    }

    public int getRecLength() {
        return this.m_bytesRcvd;
    }

    public int BTRV(int n) throws PsqlIOException {
        return this.BTRV(n, this.m_keyNumber);
    }

    public int BTRV(int n, int n2) throws PsqlIOException {
        if (this.m_objClosed) {
            throw new PsqlInvalidObjectException(MessageCatalog.getObjectClosedMsg(this));
        }
        if (this.setLengths(n, n2) != 0) {
            return -1;
        }
        int n3 = this.m_btrvObj.invoke((short)n, this.m_posBlock.getBufferData(), this.m_dBuffer, this.m_sendLength, this.m_kBuffer, (short)n2, this.m_recvLength, this.m_keyLength, this.m_clientID, this.m_opResults);
        this.m_bytesRcvd = this.m_opResults.recDataLength;
        if (n3 == 0) {
            int n4 = n % 100;
            if (n4 == 0) {
                this.m_fileOpened = true;
            } else if (n4 == 1) {
                this.m_fileOpened = false;
            }
        }
        return n3;
    }

    public void close() {
        if (this.m_fileOpened) {
            try {
                this.BTRV(1);
                this.m_fileOpened = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_parent.childClosed(this);
        this.m_objClosed = true;
    }

    public byte[] getDBytes(int n, int n2) {
        return this.m_dBuffer.readBytes(n, n2);
    }

    void getDBytes(byte[] byArray, int n, int n2) {
        this.m_dBuffer.readBytes(byArray, n, n2);
    }

    public byte[] getKBytes(int n, int n2) {
        return this.m_kBuffer.readBytes(n, n2);
    }

    public void setDBytes(int n, int n2, byte[] byArray) {
        this.m_dBuffer.writeBytes(byArray, n, n2);
    }

    public void setKBytes(int n, int n2, byte[] byArray) {
        this.m_kBuffer.writeBytes(byArray, n, n2);
    }

    public byte getDInt1(int n) {
        return this.m_dBuffer.readByte(n);
    }

    public byte getKInt1(int n) {
        return this.m_kBuffer.readByte(n);
    }

    public void setDInt1(int n, byte by) {
        this.m_dBuffer.writeByte(by, n);
    }

    public void setKInt1(int n, byte by) {
        this.m_kBuffer.writeByte(by, n);
    }

    public short getDInt2(int n) {
        return this.m_dBuffer.readShort(n);
    }

    public short getKInt2(int n) {
        return this.m_kBuffer.readShort(n);
    }

    public void setDInt2(int n, short s) {
        this.m_dBuffer.writeShort(s, n);
    }

    public void setKInt2(int n, short s) {
        this.m_kBuffer.writeShort(s, n);
    }

    public int getDInt4(int n) {
        return this.m_dBuffer.readInteger(n);
    }

    public int getKInt4(int n) {
        return this.m_kBuffer.readInteger(n);
    }

    public void setDInt4(int n, int n2) {
        this.m_dBuffer.writeInteger(n2, n);
    }

    public void setKInt4(int n, int n2) {
        this.m_kBuffer.writeInteger(n2, n);
    }

    public long getDInt8(int n) {
        return this.m_dBuffer.readLong(n);
    }

    public long getKInt8(int n) {
        return this.m_kBuffer.readLong(n);
    }

    public void setDInt8(int n, long l) {
        this.m_dBuffer.writeLong(l, n);
    }

    public void setKInt8(int n, long l) {
        this.m_kBuffer.writeLong(l, n);
    }

    public short getDUnsigned1(int n) {
        return this.m_dBuffer.readUnsignedByte(n);
    }

    public short getKUnsigned1(int n) {
        return this.m_kBuffer.readUnsignedByte(n);
    }

    public void setDUnsigned1(int n, short s) {
        this.m_dBuffer.writeUnsignedByte(s, n);
    }

    public void setKUnsigned1(int n, short s) {
        this.m_kBuffer.writeUnsignedByte(s, n);
    }

    public int getDUnsigned2(int n) {
        return this.m_dBuffer.readUnsignedShort(n);
    }

    public int getKUnsigned2(int n) {
        return this.m_kBuffer.readUnsignedShort(n);
    }

    public void setDUnsigned2(int n, int n2) {
        this.m_dBuffer.writeUnsignedShort(n2, n);
    }

    public void setKUnsigned2(int n, int n2) {
        this.m_kBuffer.writeUnsignedShort(n2, n);
    }

    public long getDUnsigned4(int n) {
        return this.m_dBuffer.readUnsignedInt(n);
    }

    public long getKUnsigned4(int n) {
        return this.m_kBuffer.readUnsignedInt(n);
    }

    public void setDUnsigned4(int n, long l) {
        this.m_dBuffer.writeUnsignedInt(l, n);
    }

    public void setKUnsigned4(int n, long l) {
        this.m_kBuffer.writeUnsignedInt(l, n);
    }

    public BigInteger getDUnsigned8(int n) {
        return this.m_dBuffer.readUnsignedLong(n);
    }

    public BigInteger getKUnsigned8(int n) {
        return this.m_kBuffer.readUnsignedLong(n);
    }

    public void setDUnsigned8(int n, BigInteger bigInteger) {
        this.m_dBuffer.writeUnsignedLong(bigInteger, n);
    }

    public void setKUnsigned8(int n, BigInteger bigInteger) {
        this.m_kBuffer.writeUnsignedLong(bigInteger, n);
    }

    public float getDFloat4(int n) {
        return this.m_dBuffer.readFloat(n);
    }

    public float getKFloat4(int n) {
        return this.m_kBuffer.readFloat(n);
    }

    public void setDFloat4(int n, float f) {
        this.m_dBuffer.writeFloat(f, n);
    }

    public void setKFloat4(int n, float f) {
        this.m_kBuffer.writeFloat(f, n);
    }

    public double getDFloat8(int n) {
        return this.m_dBuffer.readDouble(n);
    }

    public double getKFloat8(int n) {
        return this.m_kBuffer.readDouble(n);
    }

    public void setDFloat8(int n, double d) {
        this.m_dBuffer.writeDouble(d, n);
    }

    public void setKFloat8(int n, double d) {
        this.m_kBuffer.writeDouble(d, n);
    }

    public float getDBFloat4(int n) {
        return (float)this.m_dBuffer.readBfloat(n, 4);
    }

    public float getKBFloat4(int n) {
        return (float)this.m_kBuffer.readBfloat(n, 4);
    }

    public void setDBFloat4(int n, float f) {
        this.m_dBuffer.writeBfloat(f, n, 4);
    }

    public void setKBFloat4(int n, float f) {
        this.m_kBuffer.writeBfloat(f, n, 4);
    }

    public double getDBFloat8(int n) {
        return this.m_dBuffer.readBfloat(n, 8);
    }

    public double getKBFloat8(int n) {
        return this.m_kBuffer.readBfloat(n, 8);
    }

    public void setDBFloat8(int n, double d) {
        this.m_dBuffer.writeBfloat(d, n, 8);
    }

    public void setKBFloat8(int n, double d) {
        this.m_kBuffer.writeBfloat(d, n, 8);
    }

    public double getDCurrency(int n) {
        return this.m_dBuffer.readCurrency(n);
    }

    public double getKCurrency(int n) {
        return this.m_kBuffer.readCurrency(n);
    }

    public void setDCurrency(int n, double d) {
        this.m_dBuffer.writeCurrency(d, n);
    }

    public void setKCurrency(int n, double d) {
        this.m_kBuffer.writeCurrency(d, n);
    }

    public String getDString(int n, int n2) {
        return this.m_dBuffer.readString(n, n2);
    }

    public String getKString(int n, int n2) {
        return this.m_kBuffer.readString(n, n2);
    }

    public void setDString(int n, int n2, String string) {
        this.m_dBuffer.writeString(string, n, n2);
    }

    public void setKString(int n, int n2, String string) {
        this.m_kBuffer.writeString(string, n, n2);
    }

    public String getDLString(int n, int n2) {
        return this.m_dBuffer.readLString(n, n2);
    }

    public String getKLString(int n, int n2) {
        return this.m_kBuffer.readLString(n, n2);
    }

    public void setDLString(int n, int n2, String string) {
        this.m_dBuffer.writeLString(string, n, n2);
    }

    public void setKLString(int n, int n2, String string) {
        this.m_kBuffer.writeLString(string, n, n2);
    }

    public String getDZString(int n, int n2) {
        return this.m_dBuffer.readZString(n, n2);
    }

    public String getKZString(int n, int n2) {
        return this.m_kBuffer.readZString(n, n2);
    }

    public void setDZString(int n, int n2, String string) {
        this.m_dBuffer.writeZString(string, n, n2);
    }

    public void setKZString(int n, int n2, String string) {
        this.m_kBuffer.writeZString(string, n, n2);
    }

    public String getDWString(int n, int n2) {
        return this.m_dBuffer.readWString(n, n2);
    }

    public String getKWString(int n, int n2) {
        return this.m_kBuffer.readWString(n, n2);
    }

    public void setDWString(int n, int n2, String string) {
        this.m_dBuffer.writeWString(string, n, n2);
    }

    public void setKWString(int n, int n2, String string) {
        this.m_kBuffer.writeWString(string, n, n2);
    }

    public String getDWZString(int n, int n2) {
        return this.m_dBuffer.readWZString(n, n2);
    }

    public String getKWZString(int n, int n2) {
        return this.m_kBuffer.readWZString(n, n2);
    }

    public void setDWZString(int n, int n2, String string) {
        this.m_dBuffer.writeWZString(string, n, n2);
    }

    public void setKWZString(int n, int n2, String string) {
        this.m_kBuffer.writeWZString(string, n, n2);
    }

    public boolean getDLogical(int n, int n2, int n3) {
        return this.m_dBuffer.readLogical(n, n2, n3);
    }

    public boolean getKLogical(int n, int n2, int n3) {
        return this.m_kBuffer.readLogical(n, n2, n3);
    }

    public void setDLogical(int n, int n2, int n3, boolean bl) {
        this.m_dBuffer.writeLogical(bl, n, n2, n3);
    }

    public void setKLogical(int n, int n2, int n3, boolean bl) {
        this.m_kBuffer.writeLogical(bl, n, n2, n3);
    }

    public Date getDDate(int n) {
        return this.m_dBuffer.readDate(n);
    }

    public void getDDate(int n, Date date) {
        this.m_dBuffer.readDate(date, n);
    }

    public Date getKDate(int n) {
        return this.m_kBuffer.readDate(n);
    }

    public void getKDate(int n, Date date) {
        this.m_kBuffer.readDate(date, n);
    }

    public void setDDate(int n, Date date) {
        this.m_dBuffer.writeDate(date, n);
    }

    public void setKDate(int n, Date date) {
        this.m_kBuffer.writeDate(date, n);
    }

    public Date getDTime(int n) {
        return this.m_dBuffer.readTime(n);
    }

    public void getDTime(int n, Date date) {
        this.m_dBuffer.readTime(date, n);
    }

    public Date getKTime(int n) {
        return this.m_kBuffer.readTime(n);
    }

    public void getKTime(int n, Date date) {
        this.m_kBuffer.readTime(date, n);
    }

    public void setDTime(int n, Date date) {
        this.m_dBuffer.writeTime(date, n);
    }

    public void setKTime(int n, Date date) {
        this.m_kBuffer.writeTime(date, n);
    }

    public Timestamp getDTimestamp(int n) {
        return Timestamp.valueOf(this.m_dBuffer.readLong(n));
    }

    public Timestamp getKTimestamp(int n) {
        return Timestamp.valueOf(this.m_kBuffer.readLong(n));
    }

    public void setDTimestamp(int n, Timestamp timestamp) {
        this.m_dBuffer.writeLong(timestamp.septaValue(), n);
    }

    public void setKTimestamp(int n, Timestamp timestamp) {
        this.m_kBuffer.writeLong(timestamp.septaValue(), n);
    }

    public short getDYear(int n) {
        return this.m_dBuffer.readYear(n);
    }

    public short getKYear(int n) {
        return this.m_kBuffer.readYear(n);
    }

    public void setDYear(int n, short s) {
        this.m_dBuffer.writeYear(s, n);
    }

    public void setKYear(int n, short s) {
        this.m_kBuffer.writeYear(s, n);
    }

    public short getDMonth(int n) {
        return this.m_dBuffer.readMonth(n);
    }

    public short getKMonth(int n) {
        return this.m_kBuffer.readMonth(n);
    }

    public void setDMonth(int n, short s) {
        this.m_dBuffer.writeMonth(s, n);
    }

    public void setKMonth(int n, short s) {
        this.m_kBuffer.writeMonth(s, n);
    }

    public short getDDay(int n) {
        return this.m_dBuffer.readDay(n);
    }

    public short getKDay(int n) {
        return this.m_kBuffer.readDay(n);
    }

    public void setDDay(int n, short s) {
        this.m_dBuffer.writeDay(s, n);
    }

    public void setKDay(int n, short s) {
        this.m_kBuffer.writeDay(s, n);
    }

    public short getDHours(int n) {
        return this.m_dBuffer.readHour(n);
    }

    public short getKHours(int n) {
        return this.m_kBuffer.readHour(n);
    }

    public void setDHours(int n, short s) {
        this.m_dBuffer.writeHour(s, n);
    }

    public void setKHours(int n, short s) {
        this.m_kBuffer.writeHour(s, n);
    }

    public short getDMinutes(int n) {
        return this.m_dBuffer.readMinute(n);
    }

    public short getKMinutes(int n) {
        return this.m_kBuffer.readMinute(n);
    }

    public void setDMinutes(int n, short s) {
        this.m_dBuffer.writeMinute(s, n);
    }

    public void setKMinutes(int n, short s) {
        this.m_kBuffer.writeMinute(s, n);
    }

    public short getDSeconds(int n) {
        return this.m_dBuffer.readSec(n);
    }

    public short getKSeconds(int n) {
        return this.m_kBuffer.readSec(n);
    }

    public void setDSeconds(int n, short s) {
        this.m_dBuffer.writeSec(s, n);
    }

    public void setKSeconds(int n, short s) {
        this.m_kBuffer.writeSec(s, n);
    }

    public short getDCSeconds(int n) {
        return this.m_dBuffer.readMS(n);
    }

    public short getKCSeconds(int n) {
        return this.m_kBuffer.readMS(n);
    }

    public void setDCSeconds(int n, short s) {
        this.m_dBuffer.writeMS(s, n);
    }

    public void setKCSeconds(int n, short s) {
        this.m_kBuffer.writeMS(s, n);
    }

    public double getDDecimal(int n, int n2, int n3) {
        return this.m_dBuffer.readDecimalDouble(n, n2, n3);
    }

    public double getKDecimal(int n, int n2, int n3) {
        return this.m_kBuffer.readDecimalDouble(n, n2, n3);
    }

    public void setDDecimal(int n, int n2, int n3, double d) {
        this.m_dBuffer.writeDecimal(d, n, n2, n3);
    }

    public void setKDecimal(int n, int n2, int n3, double d) {
        this.m_kBuffer.writeDecimal(d, n, n2, n3);
    }

    public BigDecimal getDDecimalAsBigDecimal(int n, int n2, int n3) {
        return this.m_dBuffer.readDecimalBigDecimal(n, n2, n3);
    }

    public BigDecimal getKDecimalAsBigDecimal(int n, int n2, int n3) {
        return this.m_kBuffer.readDecimalBigDecimal(n, n2, n3);
    }

    public void setDDecimal(int n, int n2, int n3, BigDecimal bigDecimal) {
        this.m_dBuffer.writeDecimal(bigDecimal, n, n2, n3);
    }

    public void setKDecimal(int n, int n2, int n3, BigDecimal bigDecimal) {
        this.m_kBuffer.writeDecimal(bigDecimal, n, n2, n3);
    }

    public double getDMoney(int n, int n2) {
        return this.m_dBuffer.readMoneyDouble(n, n2);
    }

    public double getKMoney(int n, int n2) {
        return this.m_kBuffer.readMoneyDouble(n, n2);
    }

    public void setDMoney(int n, int n2, double d) {
        this.m_dBuffer.writeMoney(d, n, n2);
    }

    public void setKMoney(int n, int n2, double d) {
        this.m_kBuffer.writeMoney(d, n, n2);
    }

    public BigDecimal getDMoneyAsBigDecimal(int n, int n2) {
        return this.m_dBuffer.readMoneyBigDecimal(n, n2);
    }

    public BigDecimal getKMoneyAsBigDecimal(int n, int n2) {
        return this.m_kBuffer.readMoneyBigDecimal(n, n2);
    }

    public void setDMoney(int n, int n2, BigDecimal bigDecimal) {
        this.m_dBuffer.writeMoney(bigDecimal, n, n2);
    }

    public void setKMoney(int n, int n2, BigDecimal bigDecimal) {
        this.m_kBuffer.writeMoney(bigDecimal, n, n2);
    }

    public double getDNumeric(int n, int n2, int n3) {
        return this.m_dBuffer.readNumericDouble(n, n2, n3);
    }

    public double getKNumeric(int n, int n2, int n3) {
        return this.m_kBuffer.readNumericDouble(n, n2, n3);
    }

    public void setDNumeric(int n, int n2, int n3, double d) {
        this.m_dBuffer.writeNumeric(d, n, n2, n3);
    }

    public void setKNumeric(int n, int n2, int n3, double d) {
        this.m_kBuffer.writeNumeric(d, n, n2, n3);
    }

    public BigDecimal getDNumericAsBigDecimal(int n, int n2, int n3) {
        return this.m_dBuffer.readNumericBigDecimal(n, n2, n3);
    }

    public BigDecimal getKNumericAsBigDecimal(int n, int n2, int n3) {
        return this.m_kBuffer.readNumericBigDecimal(n, n2, n3);
    }

    public void setDNumeric(int n, int n2, int n3, BigDecimal bigDecimal) {
        this.m_dBuffer.writeNumeric(bigDecimal, n, n2, n3);
    }

    public void setKNumeric(int n, int n2, int n3, BigDecimal bigDecimal) {
        this.m_kBuffer.writeNumeric(bigDecimal, n, n2, n3);
    }

    public double getDNumericSA(int n, int n2, int n3) {
        return this.m_dBuffer.readSADouble(n, n2, n3);
    }

    public double getKNumericSA(int n, int n2, int n3) {
        return this.m_kBuffer.readSADouble(n, n2, n3);
    }

    public void setDNumericSA(int n, int n2, int n3, double d) {
        this.m_dBuffer.writeSA(d, n, n2, n3);
    }

    public void setKNumericSA(int n, int n2, int n3, double d) {
        this.m_kBuffer.writeSA(d, n, n2, n3);
    }

    public BigDecimal getDNumericSAAsBigDecimal(int n, int n2, int n3) {
        return this.m_dBuffer.readSABigDecimal(n, n2, n3);
    }

    public BigDecimal getKNumericSAAsBigDecimal(int n, int n2, int n3) {
        return this.m_kBuffer.readSABigDecimal(n, n2, n3);
    }

    public void setDNumericSA(int n, int n2, int n3, BigDecimal bigDecimal) {
        this.m_dBuffer.writeSA(bigDecimal, n, n2, n3);
    }

    public void setKNumericSA(int n, int n2, int n3, BigDecimal bigDecimal) {
        this.m_kBuffer.writeSA(bigDecimal, n, n2, n3);
    }

    public double getDNumericSTS(int n, int n2, int n3) {
        return this.m_dBuffer.readSTSDouble(n, n2, n3);
    }

    public double getKNumericSTS(int n, int n2, int n3) {
        return this.m_kBuffer.readSTSDouble(n, n2, n3);
    }

    public void setDNumericSTS(int n, int n2, int n3, double d) {
        this.m_dBuffer.writeSTS(d, n, n2, n3);
    }

    public void setKNumericSTS(int n, int n2, int n3, double d) {
        this.m_kBuffer.writeSTS(d, n, n2, n3);
    }

    public BigDecimal getDNumericSTSAsBigDecimal(int n, int n2, int n3) {
        return this.m_dBuffer.readSTSBigDecimal(n, n2, n3);
    }

    public BigDecimal getKNumericSTSAsBigDecimal(int n, int n2, int n3) {
        return this.m_kBuffer.readSTSBigDecimal(n, n2, n3);
    }

    public void setDNumericSTS(int n, int n2, int n3, BigDecimal bigDecimal) {
        this.m_dBuffer.writeSTS(bigDecimal, n, n2, n3);
    }

    public void setKNumericSTS(int n, int n2, int n3, BigDecimal bigDecimal) {
        this.m_kBuffer.writeSTS(bigDecimal, n, n2, n3);
    }

    int updateChunk(int n, int n2, byte[] byArray) throws PsqlIOException, PsqlOperationException {
        int n3 = -1;
        int n4 = this.getDataSize();
        byte[] byArray2 = this.getDBytes(0, n4);
        if (n2 > byArray.length) {
            n2 = byArray.length;
        }
        this.setDataSize(n2 + UPDATE_CHUNK_RCD_SIZE);
        this.setDInt4(0, Integer.MIN_VALUE);
        this.setDInt4(4, 1);
        this.setDInt4(8, n);
        this.setDInt4(12, n2);
        this.setDBytes(UPDATE_CHUNK_RCD_SIZE, n2, byArray);
        n3 = this.BTRV(53);
        this.setDataSize(n4);
        this.setDBytes(0, n4, byArray2);
        if (n3 != 0 && n3 != 22) {
            throw new PsqlOperationException(53, n3);
        }
        return n3;
    }

    int updateChunk(int n, int n2, byte[] byArray, int n3) throws PsqlIOException, PsqlOperationException {
        int n4 = -1;
        int n5 = this.getDataSize();
        byte[] byArray2 = this.getDBytes(0, n5);
        int n6 = this.getKeyNumber();
        if (n2 > byArray.length) {
            n2 = byArray.length;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        this.setKeyNumber(n3);
        this.setDataSize(n2 + UPDATE_CHUNK_RCD_SIZE);
        this.setDInt4(0, Integer.MIN_VALUE);
        this.setDInt4(4, 1);
        this.setDInt4(8, n);
        this.setDInt4(12, n2);
        this.setDBytes(UPDATE_CHUNK_RCD_SIZE, n2, byArray);
        n4 = this.BTRV(53);
        this.setDataSize(n5);
        this.setDBytes(0, n5, byArray2);
        this.setKeyNumber(n6);
        if (n4 != 0 && n4 != 22) {
            throw new PsqlOperationException(53, n4);
        }
        return n4;
    }

    byte[] getChunk(int n, int n2) throws PsqlIOException, PsqlOperationException {
        return this.getChunk(n, n2, 1024);
    }

    byte[] getChunk(int n, int n2, int n3) throws PsqlIOException, PsqlOperationException {
        int n4 = -1;
        byte[] byArray = new byte[n3];
        int n5 = this.getDataSize();
        byte[] byArray2 = this.getDBytes(0, n5);
        if (n3 < GET_CHUNK_RCD_SIZE) {
            this.setDataSize(GET_CHUNK_RCD_SIZE);
        } else {
            this.setDataSize(n3);
        }
        this.setDInt4(0, n);
        this.setDInt4(4, Integer.MIN_VALUE);
        this.setDInt4(8, 1);
        this.setDInt4(12, n2);
        this.setDInt4(16, n3);
        n4 = this.BTRV(23, -2);
        byArray = this.getDBytes(0, n3);
        this.setDataSize(n5);
        this.setDBytes(0, n5, byArray2);
        if (n4 != 0 && n4 != 22) {
            throw new PsqlOperationException(23, n4);
        }
        return byArray;
    }

    private final int setLengths(int n, int n2) {
        switch (n %= 100) {
            case 0: {
                this.m_recvLength = this.m_sendLength = 25;
                this.m_keyLength = (short)(this.m_kBuffer.findNullByte(0) + 1);
                break;
            }
            case 1: 
            case 4: 
            case 19: 
            case 20: 
            case 21: 
            case 30: 
            case 32: {
                this.m_sendLength = 0;
                this.m_recvLength = 1;
                this.m_keyLength = 0;
                break;
            }
            case 2: 
            case 3: 
            case 31: 
            case 42: {
                this.m_sendLength = this.m_dataBufSize;
                this.m_recvLength = this.m_dataBufSize;
                this.m_keyLength = this.m_keyBufSize;
                break;
            }
            case 14: {
                this.m_sendLength = this.m_dataBufSize;
                this.m_recvLength = this.m_dataBufSize;
                this.m_keyLength = (short)(this.m_kBuffer.findNullByte(0) + 1);
                break;
            }
            case 16: 
            case 17: {
                this.m_sendLength = 0;
                this.m_recvLength = 1;
                this.m_keyLength = (short)(this.m_kBuffer.findNullByte(0) + 1);
                break;
            }
            case 18: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 94: {
                this.m_sendLength = 0;
                this.m_recvLength = 1;
                this.m_keyLength = this.m_keyBufSize;
                break;
            }
            case 22: {
                this.m_sendLength = 0;
                this.m_recvLength = 4;
                this.m_keyLength = 0;
                break;
            }
            case 23: {
                this.m_sendLength = n2 == -2 ? this.m_dataBufSize : 4;
                this.m_recvLength = this.m_dataBufSize;
                this.m_keyLength = this.m_keyBufSize;
                break;
            }
            case 26: {
                this.m_sendLength = 0;
                this.m_recvLength = this.m_dataBufSize;
                this.m_keyLength = 0;
                break;
            }
            case 27: {
                this.m_sendLength = n2 == -1 ? 4 : 0;
                this.m_recvLength = this.m_sendLength;
                this.m_keyLength = 0;
                break;
            }
            case 28: {
                this.m_sendLength = 0;
                this.m_recvLength = 1;
                if (n2 == -1) {
                    this.m_keyLength = this.m_keyBufSize;
                    break;
                }
                this.m_keyLength = 0;
                break;
            }
            case 29: {
                this.m_recvLength = this.m_sendLength = this.m_dBuffer.findNullByte(0) + 1;
                this.m_keyLength = (short)this.m_sendLength;
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.m_sendLength = this.m_dBuffer.readShort(0);
                this.m_recvLength = this.m_dataBufSize;
                this.m_keyLength = this.m_keyBufSize;
                break;
            }
            case 44: {
                this.m_sendLength = 4;
                this.m_recvLength = this.m_dataBufSize;
                this.m_keyLength = this.m_keyBufSize;
                break;
            }
            case 45: {
                this.m_sendLength = 4;
                this.m_recvLength = 4;
                this.m_keyLength = this.m_keyBufSize;
                break;
            }
            case 53: {
                this.m_sendLength = this.m_dataBufSize;
                this.m_recvLength = 0;
                this.m_keyLength = this.m_keyBufSize;
                break;
            }
            case 65: {
                this.m_sendLength = this.m_dataBufSize;
                this.m_recvLength = this.m_dataBufSize;
                this.m_keyLength = 0;
                break;
            }
            case 66: {
                if (n2 == 0 || n2 == 2) {
                    this.m_sendLength = 0;
                    this.m_recvLength = 0;
                } else {
                    this.m_sendLength = this.m_dataBufSize;
                    this.m_recvLength = this.m_dataBufSize;
                }
                this.m_keyLength = (short)(this.m_kBuffer.findNullByte(0) + 1);
                break;
            }
            default: {
                this.m_sendLength = 0;
                this.m_recvLength = this.m_dataBufSize;
                this.m_keyLength = (short)86;
            }
        }
        return 0;
    }

    final short getUsageCount() {
        return this.m_posBlock.readShort(100);
    }

    boolean isClosed() {
        return this.m_objClosed;
    }
}

