/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.notificationviewer.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Point;

public class UserData
implements Externalizable {
    private long lastLogReadTimestamp;
    private List<Long> readUIDs = new ArrayList<Long>();
    private boolean showUnreadOnly;
    private Point initialSize = new Point(900, 600);
    private Point initialLocation = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
    private int[] sashWeights = new int[]{500, 500};

    public List<Long> getReadUIDs() {
        return this.readUIDs;
    }

    public long getLastLogReadTimestamp() {
        return this.lastLogReadTimestamp;
    }

    public void setLastLogReadTimestamp(long l) {
        this.lastLogReadTimestamp = l;
    }

    public Point getInitialSize() {
        return this.initialSize;
    }

    public boolean getShowUnreadOnly() {
        return this.showUnreadOnly;
    }

    public Point getInitialLocation() {
        return this.initialLocation;
    }

    public int[] getSashWeights() {
        return this.sashWeights;
    }

    public void setInitialSize(Point point) {
        this.initialSize = point;
    }

    public void setInitialLocation(Point point) {
        this.initialLocation = point;
    }

    public void setShowUnreadOnly(boolean bl) {
        this.showUnreadOnly = bl;
    }

    public void setSashWeights(int[] nArray) {
        this.sashWeights = nArray;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.lastLogReadTimestamp);
        int n = this.readUIDs.size();
        objectOutput.writeInt(n);
        Iterator<Long> iterator = this.readUIDs.iterator();
        while (iterator.hasNext()) {
            long l = iterator.next();
            objectOutput.writeLong(l);
        }
        objectOutput.writeBoolean(this.showUnreadOnly);
        objectOutput.writeInt(this.initialSize.x);
        objectOutput.writeInt(this.initialSize.y);
        objectOutput.writeInt(this.initialLocation.x);
        objectOutput.writeInt(this.initialLocation.y);
        objectOutput.writeInt(this.sashWeights.length);
        for (Object object : (Iterator<Long>)this.sashWeights) {
            objectOutput.writeInt((int)object);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        this.lastLogReadTimestamp = objectInput.readLong();
        int n2 = objectInput.readInt();
        this.readUIDs = new ArrayList<Long>(n2);
        for (n = 0; n < n2; ++n) {
            this.readUIDs.add(objectInput.readLong());
        }
        this.showUnreadOnly = objectInput.readBoolean();
        this.initialSize = new Point(objectInput.readInt(), objectInput.readInt());
        this.initialLocation = new Point(objectInput.readInt(), objectInput.readInt());
        n = objectInput.readInt();
        this.sashWeights = new int[n];
        for (int i = 0; i < n; ++i) {
            this.sashWeights[i] = objectInput.readInt();
        }
    }
}

