/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.notificationviewer.model;

import com.pervasive.utilities.notificationviewer.model.AcceptAllNotificationFilter;
import com.pervasive.utilities.notificationviewer.model.Notification;
import com.pervasive.utilities.notificationviewer.model.NotificationFilter;
import com.pervasive.utilities.notificationviewer.utils.MiscUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class NotificationViewerModel {
    private Set<Notification> notifications = new TreeSet<Notification>();
    private NotificationFilter filter = new AcceptAllNotificationFilter();
    private List<Notification> todayBucket = new ArrayList<Notification>();
    private List<Notification> lastWeekBucket = new ArrayList<Notification>();
    private List<Notification> olderBucket = new ArrayList<Notification>();

    public NotificationViewerModel() {
    }

    public NotificationViewerModel(List<Notification> list) {
        this.setNotifications(list);
    }

    public void setNotifications(List<Notification> list) {
        this.notifications = new TreeSet<Notification>(list);
    }

    public int getNotificationCount() {
        return this.todayBucket.size() + this.lastWeekBucket.size() + this.olderBucket.size();
    }

    public void setFilter(NotificationFilter notificationFilter) {
        this.filter = notificationFilter;
    }

    public int getUnreadNotificationsCount() {
        int n = 0;
        for (Notification notification : this.notifications) {
            if (notification.isRead()) continue;
            ++n;
        }
        return n;
    }

    public int getCriticalUnreadNotificationsCount() {
        int n = 0;
        for (Notification notification : this.notifications) {
            if (notification.isRead() || notification.getErrorLevel() <= 1) continue;
            ++n;
        }
        return n;
    }

    public boolean hasUnreadNotifications() {
        for (Notification notification : this.notifications) {
            if (notification.isRead()) continue;
            return true;
        }
        return false;
    }

    public List<Notification> addNotifications(List<Notification> list) {
        ArrayList<Notification> arrayList = new ArrayList<Notification>();
        for (Notification notification : list) {
            if (this.notifications.contains(notification)) continue;
            arrayList.add(notification);
        }
        if (arrayList.size() > 0) {
            this.notifications.addAll(arrayList);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                this.todayBucket.add(0, (Notification)arrayList.get(i));
            }
        }
        return arrayList;
    }

    public boolean addNotification(Notification notification) {
        boolean bl = this.notifications.add(notification);
        if (bl) {
            this.todayBucket.add(0, notification);
        }
        return bl;
    }

    public Iterator<Notification> iterator() {
        return this.notifications.iterator();
    }

    public List<Notification> getTodayNotifications() {
        return this.todayBucket;
    }

    public List<Notification> getLastWeekNotifications() {
        return this.lastWeekBucket;
    }

    public List<Notification> getOlderNotifications() {
        return this.olderBucket;
    }

    public List<Notification> markAllRead() {
        ArrayList<Notification> arrayList = new ArrayList<Notification>();
        for (Notification notification : this.notifications) {
            if (notification.isRead()) continue;
            arrayList.add(notification);
            notification.setRead(true);
        }
        return arrayList;
    }

    public void computeBuckets() {
        this.todayBucket.clear();
        this.lastWeekBucket.clear();
        this.olderBucket.clear();
        for (Notification notification : this.notifications) {
            if (!this.filter.accept(notification)) continue;
            int n = MiscUtils.daysAgo(notification.getTimestamp());
            if (n == 0) {
                this.todayBucket.add(notification);
                continue;
            }
            if (n <= 7) {
                this.lastWeekBucket.add(notification);
                continue;
            }
            this.olderBucket.add(notification);
        }
    }

    public void recomputeBuckets() {
        ArrayList<Notification> arrayList = new ArrayList<Notification>();
        arrayList.addAll(this.todayBucket);
        arrayList.addAll(this.lastWeekBucket);
        arrayList.addAll(this.olderBucket);
        this.todayBucket.clear();
        this.lastWeekBucket.clear();
        this.olderBucket.clear();
        for (Notification notification : arrayList) {
            int n = MiscUtils.daysAgo(notification.getTimestamp());
            if (n == 0) {
                this.todayBucket.add(notification);
                continue;
            }
            if (n <= 7) {
                this.lastWeekBucket.add(notification);
                continue;
            }
            this.olderBucket.add(notification);
        }
    }
}

