/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.notificationviewer.model;

import com.pervasive.utilities.notificationviewer.AppHelper;
import com.pervasive.utilities.notificationviewer.model.Notification;
import com.pervasive.utilities.notificationviewer.utils.MessageCatalog;
import java.util.Date;
import java.util.zip.CRC32;

public class NotificationFactory {
    public static NotificationFactory INSTANCE = new NotificationFactory();
    private static String MISSING_STR = MessageCatalog.getMsg("MissingLogEntryData");
    private static final int UNKNOWN_OEM_ID = -1;
    private static final int UNKNOWN_APP_ID = -1;

    private NotificationFactory() {
    }

    public Notification createNotification(String[] stringArray) {
        long l = this.computeUID(stringArray);
        Notification notification = null;
        try {
            notification = new Notification(new Date(Long.parseLong(stringArray[0]) * 1000L), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
        }
        catch (Throwable throwable) {
            return null;
        }
        String string = MessageCatalog.getMsg(stringArray[1] + ".Caption");
        if (string == null) {
            string = MessageCatalog.getMsg("UnknownID.Caption");
        }
        notification.setCaption(string);
        switch (notification.getId()) {
            case 100: {
                this.populateGracePeriodNotificationLocal(notification, stringArray);
                break;
            }
            case 101: {
                this.populateGracePeriodNotificationRemote(notification, stringArray);
                break;
            }
            case 102: {
                this.populateDisabledNotification(notification, stringArray);
                break;
            }
            case 103: {
                this.populateActiveNotification(notification, stringArray);
                break;
            }
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 111: {
                this.populateCapacityUseNotification(notification, stringArray);
                break;
            }
            case 109: 
            case 112: {
                this.populateCapacityChangedNotification(notification, stringArray);
                break;
            }
            default: {
                this.populateUnexpectedNotification(notification, stringArray);
            }
        }
        notification.setUID(l);
        return notification;
    }

    private void populateUnexpectedNotification(Notification notification, String[] stringArray) {
        notification.setDescription(MessageCatalog.getMsg("UnknownID.Description"));
        notification.setDetails(MessageCatalog.getMsg("UnknownID.Details", stringArray[1]));
        String string = AppHelper.getOEMInfo(-1, -1);
        notification.setOEMInfo(string);
    }

    private void populateGracePeriodNotificationLocal(Notification notification, String[] stringArray) {
        String string = this.getValue(stringArray, 3, MISSING_STR);
        int n = this.getIntValue(stringArray, 4, -1);
        int n2 = this.getIntValue(stringArray, 5, -1);
        String string2 = this.getValue(stringArray, 6, MISSING_STR);
        String string3 = this.getValue(stringArray, 7, MISSING_STR);
        notification.setDescription(MessageCatalog.getMsg(notification.getId() + ".Description", new Object[]{string, string2}));
        String string4 = AppHelper.getOEMInfo(n, n2);
        notification.setOEMInfo(string4);
        notification.setDetails(MessageCatalog.getMsg(notification.getId() + ".Details", new Object[]{string, string2, string3}));
    }

    private void populateGracePeriodNotificationRemote(Notification notification, String[] stringArray) {
        String string = this.getValue(stringArray, 3, MISSING_STR);
        int n = this.getIntValue(stringArray, 4, -1);
        int n2 = this.getIntValue(stringArray, 5, -1);
        String string2 = this.getValue(stringArray, 6, MISSING_STR);
        notification.setDescription(MessageCatalog.getMsg(notification.getId() + ".Description", new Object[]{string, string2}));
        String string3 = AppHelper.getOEMInfo(n, n2);
        notification.setOEMInfo(string3);
        notification.setDetails(MessageCatalog.getMsg(notification.getId() + ".Details", new Object[]{string, string2}));
    }

    private void populateDisabledNotification(Notification notification, String[] stringArray) {
        String string = this.getValue(stringArray, 3, MISSING_STR);
        int n = this.getIntValue(stringArray, 4, -1);
        int n2 = this.getIntValue(stringArray, 5, -1);
        notification.setDescription(MessageCatalog.getMsg(notification.getId() + ".Description", new Object[]{string}));
        String string2 = AppHelper.getOEMInfo(n, n2);
        notification.setOEMInfo(string2);
        notification.setDetails(MessageCatalog.getMsg(notification.getId() + ".Details", new Object[]{string}));
    }

    private void populateActiveNotification(Notification notification, String[] stringArray) {
        String string = this.getValue(stringArray, 3, MISSING_STR);
        int n = this.getIntValue(stringArray, 4, -1);
        int n2 = this.getIntValue(stringArray, 5, -1);
        notification.setDescription(MessageCatalog.getMsg(notification.getId() + ".Description", new Object[]{string}));
        String string2 = AppHelper.getOEMInfo(n, n2);
        notification.setOEMInfo(string2);
        notification.setDetails(MessageCatalog.getMsg(notification.getId() + ".Details", new Object[]{string}));
    }

    private void populateCapacityUseNotification(Notification notification, String[] stringArray) {
        notification.setDescription(MessageCatalog.getMsg(notification.getId() + ".Description"));
        notification.setDetails(MessageCatalog.getMsg(notification.getId() + ".Details", new Object[]{this.getValue(stringArray, 3, MISSING_STR), this.getValue(stringArray, 4, MISSING_STR), this.getValue(stringArray, 5, MISSING_STR)}));
    }

    private void populateCapacityChangedNotification(Notification notification, String[] stringArray) {
        notification.setDescription(MessageCatalog.getMsg(notification.getId() + ".Description"));
        notification.setDetails(MessageCatalog.getMsg(notification.getId() + ".Details", new Object[]{this.getValue(stringArray, 3, MISSING_STR), this.getValue(stringArray, 4, MISSING_STR)}));
    }

    private long computeUID(Object[] objectArray) {
        long l = 0L;
        try {
            CRC32 cRC32 = new CRC32();
            for (int i = 0; i < objectArray.length; ++i) {
                cRC32.update(objectArray[i].toString().getBytes());
            }
            l = cRC32.getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    private String getValue(String[] stringArray, int n, String string) {
        return stringArray.length > n ? stringArray[n] : string;
    }

    private int getIntValue(String[] stringArray, int n, int n2) {
        String string = this.getValue(stringArray, n, Integer.toString(n2));
        return this.getIntValue(string, n2);
    }

    private int getIntValue(String string, int n) {
        int n2 = n;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n2;
    }
}

