/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.notificationviewer;

import com.pervasive.utilities.notificationviewer.NotificationComp;
import com.pervasive.utilities.notificationviewer.NotificationSelectionListener;
import com.pervasive.utilities.notificationviewer.NotificationSelectionManager;
import com.pervasive.utilities.notificationviewer.NotificationViewerApp;
import com.pervasive.utilities.notificationviewer.model.Notification;
import com.pervasive.utilities.notificationviewer.utils.GradientPainter;
import com.pervasive.utilities.notificationviewer.utils.GridHelper;
import com.pervasive.utilities.notificationviewer.utils.MessageCatalog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class NotificationListComp
extends Composite
implements NotificationSelectionListener {
    private NotificationSelectionManager selectionManager;
    private Color labelStartColor;
    private Color labelEndColor;
    private Label expandButton;
    private boolean expanded;
    private String baseTitle;
    private Label titleLbl;
    private List<Notification> notifications = new ArrayList<Notification>();
    private List<NotificationComp> notificationsComps = new ArrayList<NotificationComp>();

    NotificationListComp(Composite composite, NotificationSelectionManager notificationSelectionManager, String string, boolean bl) {
        super(composite, 0);
        this.selectionManager = notificationSelectionManager;
        this.expanded = bl;
        this.baseTitle = string;
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        Composite composite2 = new Composite((Composite)this, 0);
        composite2.setBackgroundMode(2);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 10;
        composite2.setLayout((Layout)gridLayout);
        GridHelper.layoutFillHorizontal((Control)composite2);
        this.labelStartColor = NotificationViewerApp.getColorRegistry().get("LIST_HEADING_START");
        this.labelEndColor = NotificationViewerApp.getColorRegistry().get("LIST_HEADING_END");
        new GradientPainter(composite2, this.labelStartColor, this.labelEndColor);
        this.expandButton = new Label(composite2, 0);
        this.expandButton.setAlignment(131072);
        this.setButtonImage();
        GridHelper.layoutFillVertical((Control)this.expandButton);
        this.expandButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                NotificationListComp.this.expand(!NotificationListComp.this.expanded);
            }
        });
        this.titleLbl = new Label(composite2, 0);
        this.titleLbl.setAlignment(16384);
        this.titleLbl.setForeground(Display.getCurrent().getSystemColor(1));
        this.titleLbl.setFont(NotificationViewerApp.getFontRegistry().getBold("PANEL_HEADING_FONT"));
        GridHelper.layoutFillVertical((Control)this.titleLbl);
        notificationSelectionManager.addNotificationSelectionListener(this);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void expand(boolean bl) {
        NotificationComp notificationComp2;
        if (bl == this.expanded) {
            return;
        }
        for (NotificationComp notificationComp2 : this.notificationsComps) {
            GridData gridData = (GridData)notificationComp2.getLayoutData();
            gridData.exclude = !bl;
            notificationComp2.setVisible(bl);
        }
        this.expanded = bl;
        this.setButtonImage();
        ScrolledComposite scrolledComposite = this.getScrollComposite();
        notificationComp2 = scrolledComposite.getOrigin();
        scrolledComposite.pack();
        scrolledComposite.getParent().layout(true, true);
        scrolledComposite.setOrigin((Point)notificationComp2);
    }

    public NotificationComp findCompForNotification(Notification notification) {
        for (NotificationComp notificationComp : this.notificationsComps) {
            if (!notificationComp.getNotification().equals(notification)) continue;
            return notificationComp;
        }
        return null;
    }

    public void showNotifications(List<Notification> list) {
        this.notifications.clear();
        this.addNotifications(list);
    }

    public void addNotifications(List<Notification> list) {
        this.removeNotificationCompChildren();
        this.notifications.addAll(0, list);
        for (Notification notification : this.notifications) {
            this.addNotificationComp(notification);
        }
        this.setTitle();
    }

    private void addNotificationComp(Notification notification) {
        NotificationComp notificationComp = this.createNotificationComp(this, this.selectionManager, notification, !this.expanded);
        this.notificationsComps.add(notificationComp);
    }

    public void removeNotificationCompChildren() {
        for (NotificationComp notificationComp : this.notificationsComps) {
            notificationComp.dispose();
        }
        this.notificationsComps.clear();
    }

    @Override
    public void notificationSelected(Notification notification) {
        if (this.notifications.contains(notification)) {
            this.setTitle();
        }
    }

    private void setButtonImage() {
        if (this.expanded) {
            this.expandButton.setImage(NotificationViewerApp.getImageRegistry().get("collapse"));
        } else {
            this.expandButton.setImage(NotificationViewerApp.getImageRegistry().get("expand"));
        }
    }

    private void setTitle() {
        String string = this.baseTitle;
        int n = 0;
        for (Notification notification : this.notifications) {
            if (notification.isRead()) continue;
            ++n;
        }
        if (n > 0) {
            string = string + "  " + MessageCatalog.getMsg("NotificationList.UnreadCount", n);
        }
        this.titleLbl.setText(string);
    }

    private ScrolledComposite getScrollComposite() {
        Composite composite = this.getParent();
        while (!(composite instanceof ScrolledComposite)) {
            composite = composite.getParent();
        }
        return (ScrolledComposite)composite;
    }

    private NotificationComp createNotificationComp(Composite composite, NotificationSelectionManager notificationSelectionManager, Notification notification, boolean bl) {
        NotificationComp notificationComp = new NotificationComp(this, notificationSelectionManager, notification);
        GridHelper gridHelper = new GridHelper((Control)notificationComp);
        gridHelper.fillHorizontal(-1, 0);
        gridHelper.setExclude(bl);
        return notificationComp;
    }
}

