/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.notificationviewer;

import com.pervasive.utilities.notificationviewer.AppHelper;
import com.pervasive.utilities.notificationviewer.utils.FormHtmlBuilder;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;

public class DetailsView
extends Composite
implements IHyperlinkListener {
    private FormText txt;
    private ScrolledComposite scrolledComp;

    public DetailsView(Composite composite) {
        super(composite, 2048);
        this.setLayout((Layout)new FillLayout());
        this.scrolledComp = new ScrolledComposite((Composite)this, 512);
        this.txt = new FormText((Composite)this.scrolledComp, 0);
        this.txt.marginHeight = 5;
        this.txt.marginWidth = 5;
        this.txt.setBackground(Display.getCurrent().getSystemColor(1));
        this.txt.addHyperlinkListener((IHyperlinkListener)this);
        this.scrolledComp.setContent((Control)this.txt);
        this.scrolledComp.setExpandHorizontal(true);
        this.scrolledComp.setExpandVertical(true);
        this.scrolledComp.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Rectangle rectangle = DetailsView.this.scrolledComp.getClientArea();
                DetailsView.this.scrolledComp.setMinSize(DetailsView.this.txt.computeSize(rectangle.width, -1));
            }
        });
    }

    public void showDetails(String string, String string2) {
        if (string.length() > 0) {
            try {
                FormHtmlBuilder formHtmlBuilder = new FormHtmlBuilder();
                formHtmlBuilder.addText(string);
                if (string2 != null) {
                    formHtmlBuilder.addParagraph(string2);
                }
                formHtmlBuilder.end();
                this.txt.setText(formHtmlBuilder.toString(), true, true);
            }
            catch (Throwable throwable) {
                try {
                    FormHtmlBuilder formHtmlBuilder = new FormHtmlBuilder();
                    formHtmlBuilder.addText(string);
                    if (string2 != null) {
                        formHtmlBuilder.addParagraph(AppHelper.getOEMInfo(99999, -1));
                    }
                    formHtmlBuilder.end();
                    this.txt.setText(formHtmlBuilder.toString(), true, true);
                }
                catch (Throwable throwable2) {
                    this.txt.setText("", false, false);
                }
            }
        } else {
            this.txt.setText(string, false, false);
        }
        this.scrolledComp.pack();
        this.scrolledComp.getParent().layout(true, true);
    }

    public void linkActivated(HyperlinkEvent hyperlinkEvent) {
        Program.launch((String)hyperlinkEvent.getHref().toString());
    }

    public void linkEntered(HyperlinkEvent hyperlinkEvent) {
    }

    public void linkExited(HyperlinkEvent hyperlinkEvent) {
    }
}

