/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.notificationviewer;

import com.pervasive.utilities.notificationviewer.LogMonitor;
import com.pervasive.utilities.notificationviewer.NotificationView;
import com.pervasive.utilities.notificationviewer.NotificationViewerApp;
import com.pervasive.utilities.notificationviewer.model.AcceptAllNotificationFilter;
import com.pervasive.utilities.notificationviewer.model.Notification;
import com.pervasive.utilities.notificationviewer.model.NotificationFilter;
import com.pervasive.utilities.notificationviewer.model.NotificationLogReader;
import com.pervasive.utilities.notificationviewer.model.NotificationViewerModel;
import com.pervasive.utilities.notificationviewer.model.PersistStore;
import com.pervasive.utilities.notificationviewer.model.UnreadNotificationFilter;
import com.pervasive.utilities.notificationviewer.model.UserData;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class AppHelper {
    private static final String USER_DATA = "UserData";
    private NotificationViewerApp app;
    private NotificationView notificationView;
    private Display display;
    private NotificationViewerModel model;
    private UserData userData;
    private File notificationLogFile;
    private LogMonitor logMonitor;

    public static native String getNotificationLogFilePath();

    public static native String getOEMInfo(int var0, int var1);

    public static native int waitForShutdownSignal();

    public AppHelper(NotificationViewerApp notificationViewerApp) {
        this.app = notificationViewerApp;
        this.userData = this.loadUserData();
    }

    public void setViewer(NotificationView notificationView) {
        this.notificationView = notificationView;
        this.display = notificationView.getControl().getDisplay();
    }

    public void initViewer() {
        List<Notification> list = this.readNotifications();
        long l = this.userData.getLastLogReadTimestamp();
        if (list == null) {
            this.userData.setLastLogReadTimestamp(0L);
            list = new ArrayList<Notification>();
        } else {
            this.userData.setLastLogReadTimestamp(this.getNotificationLogFileTimestamp());
        }
        this.model = new NotificationViewerModel(list);
        this.model.setFilter(this.getInitialFilter());
        this.notificationView.setModel(this.model);
        List<Long> list2 = this.userData.getReadUIDs();
        this.removeStaleUIDs(list, list2);
        this.storeUserData();
        for (Notification object2 : list) {
            object2.setRead(list2.contains(object2.getUID()));
        }
        this.model.computeBuckets();
        this.notificationView.refresh();
        this.logMonitor = new LogMonitor(this);
        Thread thread = new Thread(this.logMonitor);
        thread.setDaemon(true);
        thread.start();
        List<Notification> list3 = this.findNewNotifications(list, l);
        if (list3.size() > 0) {
            this.app.showNotificationTooltip(list3);
        }
    }

    public List<Notification> findNewNotifications(List<Notification> list, long l) {
        ArrayList<Notification> arrayList = new ArrayList<Notification>();
        for (Notification notification : list) {
            if (notification.getTimestamp().getTime() <= l) continue;
            arrayList.add(notification);
        }
        return arrayList;
    }

    public NotificationViewerApp getApp() {
        return this.app;
    }

    public int getNotificationCount() {
        return this.model.getNotificationCount();
    }

    public int getUnreadNotificationsCount() {
        return this.model.getUnreadNotificationsCount();
    }

    public int getCriticalUnreadNotificationsCount() {
        return this.model.getCriticalUnreadNotificationsCount();
    }

    public boolean hasUnreadNotifications() {
        return this.model.hasUnreadNotifications();
    }

    public void saveWindowState() {
        this.userData.setInitialSize(this.app.getShell().getSize());
        this.userData.setInitialLocation(this.app.getShell().getLocation());
        this.userData.setSashWeights(this.app.getSash().getWeights());
    }

    public void closeApp() {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                AppHelper.this.app.close();
            }
        });
    }

    public void shutdown() {
        this.logMonitor.stop();
        this.storeUserData();
    }

    public void reloadViewer() {
        List<Notification> list = this.readNotifications();
        if (list == null) {
            this.userData.setLastLogReadTimestamp(0L);
            list = new ArrayList<Notification>();
        } else {
            this.userData.setLastLogReadTimestamp(this.getNotificationLogFileTimestamp());
        }
        List<Long> list2 = this.userData.getReadUIDs();
        for (Notification notification : list) {
            notification.setRead(list2.contains(notification.getUID()));
        }
        this.removeStaleUIDs(list, list2);
        this.storeUserData();
        this.model.setNotifications(list);
        this.model.computeBuckets();
        this.notificationView.refresh();
    }

    public void recomputeBuckets() {
        this.model.recomputeBuckets();
        this.notificationView.refresh();
    }

    public boolean logFileModified() {
        long l = this.getNotificationLogFile().lastModified();
        return l > this.getLastLogReadTimestamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Notification> readNotifications() {
        List<Notification> list = null;
        try (NotificationLogReader notificationLogReader = null;){
            notificationLogReader = new NotificationLogReader(this.getNotificationLogFile());
            list = notificationLogReader.readNotifications();
        }
        return list;
    }

    public Display getDisplay() {
        return this.display;
    }

    public Point getInitialSize() {
        return this.userData.getInitialSize();
    }

    public Point getInitialLocation() {
        return this.userData.getInitialLocation();
    }

    public long getLastLogReadTimestamp() {
        return this.userData.getLastLogReadTimestamp();
    }

    public int[] getSashWeights() {
        return this.userData.getSashWeights();
    }

    public boolean getShowUnreadOnly() {
        return this.userData.getShowUnreadOnly();
    }

    public void setShowUnreadOnly(boolean bl) {
        this.userData.setShowUnreadOnly(bl);
    }

    public File getNotificationLogFile() {
        if (this.notificationLogFile == null) {
            this.notificationLogFile = new File(AppHelper.getNotificationLogFilePath());
        }
        return this.notificationLogFile;
    }

    public long getNotificationLogFileTimestamp() {
        return this.getNotificationLogFile().lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readNewNotifcations() {
        List<Notification> list = null;
        try (NotificationLogReader notificationLogReader = null;){
            notificationLogReader = new NotificationLogReader(this.getNotificationLogFile());
            list = notificationLogReader.readNotificationsSinceTimestamp(this.userData.getLastLogReadTimestamp());
            this.userData.setLastLogReadTimestamp(this.getNotificationLogFileTimestamp());
            this.storeUserData();
            if (list.size() > 0) {
                Collections.sort(list);
                List<Notification> list2 = this.model.addNotifications(list);
                if (list2.size() > 0) {
                    this.notificationView.refreshToday();
                    this.app.showNotificationCount(this.model.getNotificationCount());
                    this.app.showNotificationTooltip(list2);
                    this.app.showUnread();
                }
            }
        }
    }

    public void addNewNotification(Notification notification) {
        boolean bl = this.model.addNotification(notification);
        if (bl) {
            this.notificationView.refreshToday();
            this.app.showNotificationCount(this.model.getNotificationCount());
        }
    }

    public void markNotificationRead(Notification notification) {
        List<Long> list = this.userData.getReadUIDs();
        if (!list.contains(notification.getUID())) {
            list.add(notification.getUID());
            this.storeUserData();
        }
    }

    public void showAll() {
        this.model.setFilter(new AcceptAllNotificationFilter());
        this.model.computeBuckets();
        this.notificationView.refresh();
        this.app.showNotificationCount(this.model.getNotificationCount());
    }

    public void showUnreadOnly() {
        this.model.setFilter(new UnreadNotificationFilter());
        this.model.computeBuckets();
        this.notificationView.refresh();
        this.app.showNotificationCount(this.model.getNotificationCount());
    }

    public void markAllRead() {
        List<Notification> list = this.model.markAllRead();
        if (list.size() == 0) {
            return;
        }
        List<Long> list2 = this.userData.getReadUIDs();
        for (Notification notification : list) {
            long l = notification.getUID();
            if (list2.contains(l)) continue;
            list2.add(l);
        }
        this.storeUserData();
        this.notificationView.refresh();
    }

    public UserData loadUserData() {
        UserData userData = null;
        try {
            userData = (UserData)PersistStore.INSTANCE.load(USER_DATA);
            if (userData == null) {
                userData = new UserData();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return userData;
    }

    public void storeUserData() {
        try {
            PersistStore.INSTANCE.store(this.userData, USER_DATA);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void removeStaleUIDs(List<Notification> list, List<Long> list2) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (Long l : list2) {
            if (this.containsUID(l, list)) continue;
            arrayList.add(l);
        }
        for (Long l : arrayList) {
            list2.remove(l);
        }
    }

    private boolean containsUID(long l, List<Notification> list) {
        for (Notification notification : list) {
            if (l != notification.getUID()) continue;
            return true;
        }
        return false;
    }

    private NotificationFilter getInitialFilter() {
        return this.getShowUnreadOnly() ? new UnreadNotificationFilter() : new AcceptAllNotificationFilter();
    }

    static {
        System.loadLibrary("notifysupt");
    }
}

