/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.lna.LNARequest;
import com.pervasive.jdbc.lna.LNAResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public final class VarData {
    public static Object readFrom(LNAResponse lNAResponse) throws IOException {
        short s = lNAResponse.readShort();
        return VarData.readFrom(lNAResponse, s);
    }

    public static Object readFrom(LNAResponse lNAResponse, short s) throws IOException {
        int n = lNAResponse.readInt();
        switch (s) {
            case 1: {
                if (n == -3) {
                    return lNAResponse.readNullTermString();
                }
                if (n > 0) {
                    String string = lNAResponse.readString();
                    return !string.endsWith("\u0000") ? string : string.substring(0, n);
                }
                return null;
            }
            case -8: {
                if (n == -3) {
                    return lNAResponse.readNullTermString("UTF-16LE");
                }
                if (n > 0) {
                    String string = lNAResponse.readString("UTF-16LE");
                    return !string.endsWith("\u0000") ? string : string.substring(0, n / 2);
                }
                return null;
            }
            case -16: 
            case 4: {
                return new Integer(lNAResponse.readInt());
            }
            case -18: {
                return new Long(lNAResponse.readUnsignedInt());
            }
            case -25: {
                return new Long(lNAResponse.readLong());
            }
            case -27: {
                return lNAResponse.readUnsignedLong();
            }
            case -15: 
            case 5: {
                return new Short(lNAResponse.readShort());
            }
            case -17: {
                return new Integer(lNAResponse.readUnsignedShort());
            }
            case 7: {
                return new Float(lNAResponse.readFloat());
            }
            case 8: {
                return new Double(lNAResponse.readDouble());
            }
            case 9: {
                return lNAResponse.readDate();
            }
            case 10: {
                return lNAResponse.readTime();
            }
            case 11: {
                return lNAResponse.readTimestamp();
            }
            case -2: {
                if (n == -3 || n > 0) {
                    return lNAResponse.readBytes();
                }
                return null;
            }
            case -7: {
                return new Boolean(lNAResponse.readBoolean());
            }
            case -26: 
            case -6: {
                return new Byte(lNAResponse.readByte());
            }
            case -28: {
                return new Short((short)lNAResponse.readUnsignedByte());
            }
            case -11: {
                return new String(lNAResponse.readGUID(n));
            }
        }
        throw new IOException(LocalStrings.ERR_LNA_INVALID_DATA_TYPE);
    }

    public static int readBytesFrom(LNAResponse lNAResponse, byte[] byArray) throws IOException {
        short s = lNAResponse.readShort();
        if (s != 1 && s != -8 && s != -2) {
            throw new IOException(LocalStrings.ERR_LNA_INVALID_DATA_TYPE);
        }
        int n = lNAResponse.readInt();
        if (n == -3 || n > 0) {
            int n2 = lNAResponse.readInt();
            if (n == -3) {
                n = n2 - 1;
            }
            lNAResponse.readBytes(byArray, n);
            lNAResponse.skipBytes(n2 - n);
            if (s == 1 && byArray[n - 1] == 0) {
                --n;
            } else if (s == -8 && byArray[n - 1] == 0 && byArray[n - 2] == 0) {
                n -= 2;
            }
        } else {
            n = n == -1 ? -1 : 0;
        }
        return n;
    }

    public static void writeTo(LNARequest lNARequest, Object object) throws IOException {
        int n;
        if (object == null || object instanceof String || object instanceof Reader) {
            n = 1;
        } else if (object instanceof BigInteger) {
            n = -27;
        } else if (object instanceof Long) {
            n = 4;
        } else if (object instanceof Integer) {
            n = 4;
        } else if (object instanceof Short) {
            n = 5;
        } else if (object instanceof Float) {
            n = 7;
        } else if (object instanceof Double) {
            n = 8;
        } else if (object instanceof Date) {
            n = 9;
        } else if (object instanceof Time) {
            n = 10;
        } else if (object instanceof Timestamp) {
            n = 11;
        } else if (object instanceof byte[] || object instanceof InputStream) {
            n = -2;
        } else if (object instanceof Boolean) {
            n = -7;
        } else if (object instanceof Byte) {
            n = -6;
        } else {
            throw new IOException(LocalStrings.ERR_LNA_INVALID_DATA_TYPE);
        }
        VarData.writeTo(lNARequest, (short)n, object);
    }

    public static void writeTo(LNARequest lNARequest, short s, Object object) throws IOException {
        if (object == null) {
            VarData.writeAsNull(lNARequest, s);
            return;
        }
        lNARequest.writeShort(s);
        VarData.writeSizeAndValue(lNARequest, s, object);
    }

    public static void writeSizeAndValue(LNARequest lNARequest, short s, Object object) throws IOException {
        switch (s) {
            case 1: {
                if (object instanceof Boolean) {
                    Object object2 = object = (Boolean)object == true ? "1" : "0";
                }
                if (object instanceof String) {
                    int n = ((String)object).getBytes(lNARequest.getEncoding()).length;
                    lNARequest.writeInt(n);
                    if (n <= 0) break;
                    lNARequest.writeString((String)object);
                    break;
                }
                lNARequest.writeInt(-2);
                break;
            }
            case -8: {
                if (object instanceof Boolean) {
                    Object object3 = object = (Boolean)object == true ? "1" : "0";
                }
                if (object instanceof String) {
                    int n = ((String)object).getBytes("UTF-16LE").length;
                    lNARequest.writeInt(n);
                    if (n <= 0) break;
                    lNARequest.writeString((String)object, "UTF-16LE");
                    break;
                }
                lNARequest.writeInt(-2);
                break;
            }
            case -18: 
            case -16: 
            case 4: {
                lNARequest.writeInt(4);
                if (object instanceof Boolean) {
                    lNARequest.writeInt((Boolean)object == true ? 1 : 0);
                    break;
                }
                lNARequest.writeInt(((Number)object).intValue());
                break;
            }
            case -27: 
            case -25: {
                lNARequest.writeInt(8);
                if (object instanceof Boolean) {
                    lNARequest.writeLong((Boolean)object == true ? 1L : 0L);
                    break;
                }
                lNARequest.writeLong(((Number)object).longValue());
                break;
            }
            case -17: 
            case -15: 
            case 5: {
                lNARequest.writeInt(2);
                if (object instanceof Boolean) {
                    lNARequest.writeShort((Boolean)object == true ? 1 : 0);
                    break;
                }
                lNARequest.writeShort(((Number)object).shortValue());
                break;
            }
            case 7: {
                lNARequest.writeInt(4);
                if (object instanceof Boolean) {
                    lNARequest.writeFloat((Boolean)object == true ? 1.0f : 0.0f);
                    break;
                }
                lNARequest.writeFloat(((Number)object).floatValue());
                break;
            }
            case 8: {
                lNARequest.writeInt(8);
                if (object instanceof Boolean) {
                    lNARequest.writeDouble((Boolean)object == true ? 1.0 : 0.0);
                    break;
                }
                lNARequest.writeDouble(((Number)object).doubleValue());
                break;
            }
            case 9: {
                lNARequest.writeInt(6);
                lNARequest.writeDate((Date)object);
                break;
            }
            case 10: {
                lNARequest.writeInt(6);
                lNARequest.writeTime((Time)object);
                break;
            }
            case 11: {
                lNARequest.writeInt(16);
                lNARequest.writeTimestamp((Timestamp)object);
                break;
            }
            case -2: {
                if (object instanceof byte[]) {
                    int n = ((byte[])object).length;
                    lNARequest.writeInt(n);
                    if (n <= 0) break;
                    lNARequest.writeBytes((byte[])object);
                    break;
                }
                lNARequest.writeInt(-2);
                break;
            }
            case -7: {
                lNARequest.writeInt(1);
                lNARequest.writeBoolean((Boolean)object);
                break;
            }
            case -28: 
            case -26: 
            case -6: {
                lNARequest.writeInt(1);
                lNARequest.writeByte(((Number)object).byteValue());
                break;
            }
            case -11: {
                lNARequest.writeInt(16);
                lNARequest.writeGUID(object.toString());
                break;
            }
            default: {
                throw new IOException(LocalStrings.ERR_LNA_INVALID_DATA_TYPE);
            }
        }
    }

    public static void writeAsNull(LNARequest lNARequest, short s) throws IOException {
        lNARequest.writeShort(s);
        lNARequest.writeInt(-1);
        switch (s) {
            case 1: {
                break;
            }
            case -8: {
                break;
            }
            case -27: 
            case -25: {
                lNARequest.writeLong(0L);
                break;
            }
            case -18: 
            case -16: 
            case 4: {
                lNARequest.writeInt(0);
                break;
            }
            case -17: 
            case -15: 
            case 5: {
                lNARequest.writeShort(0);
                break;
            }
            case 7: {
                lNARequest.writeFloat(0.0f);
                break;
            }
            case 8: {
                lNARequest.writeDouble(0.0);
                break;
            }
            case 9: {
                lNARequest.writeInt(0);
                lNARequest.writeShort(0);
                break;
            }
            case 10: {
                lNARequest.writeInt(0);
                lNARequest.writeShort(0);
                break;
            }
            case 11: {
                lNARequest.writeInt(0);
                lNARequest.writeInt(0);
                lNARequest.writeInt(0);
                lNARequest.writeInt(0);
                break;
            }
            case -2: {
                break;
            }
            case -7: {
                lNARequest.writeBoolean(false);
                break;
            }
            case -28: 
            case -26: 
            case -6: {
                lNARequest.writeByte(0);
                break;
            }
            case -11: {
                lNARequest.writeInt(0);
                lNARequest.writeInt(0);
                lNARequest.writeInt(0);
                lNARequest.writeInt(0);
                break;
            }
            default: {
                throw new IOException(LocalStrings.ERR_LNA_INVALID_DATA_TYPE);
            }
        }
    }

    public static void writeIntTo(LNARequest lNARequest, int n) throws IOException {
        lNARequest.writeShort(4);
        lNARequest.writeInt(4);
        lNARequest.writeInt(n);
    }

    public static void writeStringTo(LNARequest lNARequest, String string) throws IOException {
        lNARequest.writeShort(1);
        int n = string != null ? string.length() : -1;
        lNARequest.writeInt(n);
        if (n > 0) {
            lNARequest.writeString(string);
        }
    }

    public static void writeNullTermStringTo(LNARequest lNARequest, String string) throws IOException {
        lNARequest.writeShort(1);
        int n = string != null ? string.length() : -1;
        lNARequest.writeInt(n);
        if (n > 0) {
            lNARequest.writeNullTermString(string);
        }
    }

    public static void writeBytesTo(LNARequest lNARequest, short s, byte[] byArray, int n) throws IOException {
        lNARequest.writeShort(s);
        lNARequest.writeInt(n);
        if (n > 0) {
            lNARequest.writeBytes(byArray, n);
        }
    }
}

