/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.lna.ColumnInfo;
import com.pervasive.jdbc.lna.LNAResponse;
import java.io.DataInput;
import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public final class ArrayColumnBuffer {
    private static final short PACKLONG_BIAS = 5536;
    private static final int DOUBLE_SIZE = 8;
    private static final int TIMESTAMP_SIZE = 11;
    private static final int MAX_FIXED_SIZE = 11;
    private int[] d_codeVec;
    private Object[] d_dataVec;

    public void readFrom(LNAResponse lNAResponse, ColumnInfo columnInfo, int n) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        this.d_codeVec = null;
        this.d_dataVec = null;
        short s = lNAResponse.readShort();
        boolean bl = (s & 0x8000) != 0;
        int n9 = s >>> 5 & 0x3FF;
        int n10 = s >>> 1 & 0xF;
        boolean bl2 = (s & 1) != 0;
        int n11 = 0;
        if (n > 0 && s != 1) {
            n11 = lNAResponse.readShort();
        }
        int n12 = n9 > 0 ? n9 : n;
        int[] nArray = null;
        if (n10 > 0) {
            nArray = new int[n12];
            n8 = bl2 && n9 == 0 ? 1 : 0;
            n7 = ~(-1 << n10);
            n6 = 0;
            n5 = 0;
            for (n4 = 0; n4 < n12; ++n4) {
                while (n5 < n10) {
                    n6 |= (lNAResponse.readByte() & 0xFF) << n5;
                    n5 += 8;
                }
                n3 = (n6 & n7) - n8;
                if (n3 >= 0) {
                    n3 += n11;
                }
                nArray[n4] = n3;
                n6 >>>= n10;
                n5 -= n10;
            }
        }
        n8 = 0;
        if (n9 > 0) {
            this.d_codeVec = new int[n];
            n7 = bl2 ? 1 : 0;
            n8 = this.bitWidth((short)(n9 - 1 + n7));
            n6 = ~(-1 << n8);
            n5 = 0;
            n4 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                while (n4 < n8) {
                    n5 |= (lNAResponse.readByte() & 0xFF) << n4;
                    n4 += 8;
                }
                this.d_codeVec[n3] = n2 = (n5 & n6) - n7;
                n5 >>>= n8;
                n4 -= n8;
            }
        }
        if (bl) {
            n6 = lNAResponse.readShort();
            throw new IOException("Compressed ArrayFetch not supported");
        }
        DataInput dataInput = lNAResponse.getDataInput();
        this.d_dataVec = new Object[n12];
        n6 = columnInfo.getBindType();
        n5 = columnInfo.getBindSize();
        if (n5 < 11) {
            n5 = 11;
        }
        byte[] byArray = new byte[n5];
        for (n3 = 0; n3 < n12; ++n3) {
            int n13 = n2 = nArray != null ? nArray[n3] : n11;
            if (n2 <= 0) continue;
            dataInput.readFully(byArray, 0, n2);
            Object object = null;
            switch (n6) {
                case 1: {
                    object = new String(byArray, 0, n2, lNAResponse.getEncoding());
                    break;
                }
                case -18: 
                case -16: 
                case 4: {
                    int n14;
                    switch (n2) {
                        case 0: {
                            n14 = 0;
                            break;
                        }
                        case 1: {
                            n14 = (byArray[0] & 0xFF) + 1;
                            break;
                        }
                        case 2: {
                            n14 = ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF) - 5536;
                            break;
                        }
                        default: {
                            n14 = ((byArray[0] & 0xFF) << 24) + ((byArray[1] & 0xFF) << 16) + ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
                        }
                    }
                    if (n6 == -18) {
                        object = new Long((long)n14 & 0xFFFFFFFFL);
                        break;
                    }
                    object = new Integer(n14);
                    break;
                }
                case -17: 
                case -15: 
                case 5: {
                    short s2 = (short)(((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF));
                    if (n6 == -17) {
                        object = new Integer(s2 & 0xFFFF);
                        break;
                    }
                    object = new Short(s2);
                    break;
                }
                case 7: {
                    int n15 = ((byArray[0] & 0xFF) << 24) + ((byArray[1] & 0xFF) << 16) + ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
                    object = new Float(Float.intBitsToFloat(n15));
                    break;
                }
                case 8: {
                    long l = 0L;
                    if (n2 > 0) {
                        int n16 = 0;
                        for (int i = 0; i < 8; ++i) {
                            if (i < n2) {
                                n16 = byArray[i] & 0xFF;
                            }
                            l = (l << 8) + (long)n16;
                        }
                    }
                    object = new Double(Double.longBitsToDouble(l));
                    break;
                }
                case 9: {
                    Calendar calendar = Calendar.getInstance();
                    calendar.clear();
                    calendar.set(1, ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF));
                    calendar.set(2, byArray[2] - 1);
                    calendar.set(5, byArray[3]);
                    object = new Date(calendar.getTime().getTime());
                    break;
                }
                case 10: {
                    Calendar calendar = Calendar.getInstance();
                    calendar.clear();
                    if (n2 > 0) {
                        calendar.set(11, byArray[0]);
                    }
                    if (n2 > 1) {
                        calendar.set(12, byArray[1]);
                    }
                    if (n2 > 2) {
                        calendar.set(13, byArray[2]);
                    }
                    object = new Time(calendar.getTime().getTime());
                    break;
                }
                case 11: {
                    for (int i = n2; i < 11; ++i) {
                        byArray[i] = 0;
                    }
                    Calendar calendar = Calendar.getInstance();
                    calendar.clear();
                    calendar.set(1, ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF));
                    calendar.set(2, byArray[2] - 1);
                    calendar.set(5, byArray[3] & 0xFF);
                    calendar.set(11, byArray[4] & 0xFF);
                    calendar.set(12, byArray[5] & 0xFF);
                    calendar.set(13, byArray[6] & 0xFF);
                    int n17 = ((byArray[7] & 0xFF) << 24) + ((byArray[8] & 0xFF) << 16) + ((byArray[9] & 0xFF) << 8) + (byArray[10] & 0xFF);
                    calendar.set(14, n17 / 10000);
                    object = new Timestamp(calendar.getTime().getTime());
                    break;
                }
                case -2: {
                    object = new byte[n2];
                    System.arraycopy(byArray, 0, object, 0, n2);
                    break;
                }
                case -7: {
                    object = new Boolean(byArray[n2 - 1] != 0);
                    break;
                }
                case -26: 
                case -6: {
                    object = new Byte(byArray[n2 - 1]);
                    break;
                }
                case -28: {
                    object = new Short((short)(byArray[n2 - 1] & 0xFF));
                    break;
                }
                default: {
                    throw new IOException(LocalStrings.ERR_LNA_INVALID_DATA_TYPE);
                }
            }
            this.d_dataVec[n3] = object;
        }
    }

    public Object getObject(int n) {
        if (this.d_codeVec != null) {
            n = this.d_codeVec[n];
        }
        return n >= 0 ? this.d_dataVec[n] : null;
    }

    private int bitWidth(short s) {
        if (s == 0) {
            return 0;
        }
        int n = 0;
        if ((s & 0xFF00) != 0) {
            n += 8;
            s = (short)(s >>> 8);
        }
        if ((s & 0xF0) != 0) {
            n += 4;
            s = (short)(s >>> 4);
        }
        if ((s & 0xC) != 0) {
            n += 2;
            s = (short)(s >>> 2);
        }
        if ((s & 2) != 0) {
            ++n;
            s = (short)(s >>> 1);
        }
        return n + s;
    }
}

