/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.v2;

import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.lna.ArrayFetchResultCache;
import com.pervasive.jdbc.lna.ColumnInfoSet;
import com.pervasive.jdbc.lna.LNAConnection;
import com.pervasive.jdbc.lna.LNAStatement;
import com.pervasive.jdbc.lna.ParamDescSet;
import com.pervasive.jdbc.lna.ParamInfoSet;
import com.pervasive.jdbc.lna.StatementOptions;
import com.pervasive.jdbc.v2.Connection;
import com.pervasive.jdbc.v2.ResultSet;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.Vector;

public class Statement
implements java.sql.Statement {
    protected static final int MAX_FETCH_SIZE = 1000;
    protected static final int DEFAULT_FETCH_SIZE = 10;
    public static final int UPDATE_COUNT_NOT_UPDATE = -1;
    public static final int UPDATE_COUNT_UNKNOWN = -2;
    public static final int UPDATE_COUNT_FAILED = -3;
    protected Connection d_conn;
    protected LNAStatement d_lnaStmt;
    protected StatementOptions d_stmtOpts;
    protected int d_fetchDir = 1002;
    protected boolean d_escapeProc;
    protected boolean d_canScroll;
    protected ResultSet d_curResults;
    protected int d_updateCount;
    protected Vector<String> d_sqlBatch;
    private boolean d_closeOnCompletion;

    Statement(Connection connection, int n, int n2) throws SQLException {
        this.d_conn = connection;
        LNAConnection lNAConnection = this.d_conn.getLNAConnection();
        this.d_lnaStmt = lNAConnection.allocStmt();
        this.d_stmtOpts = this.d_lnaStmt.getStmtOpts();
        this.d_canScroll = lNAConnection.scrollCapable();
        if (!this.validType(n) || !this.validConcur(n2)) {
            throw new SQLException(LocalStrings.ERR_SQL_ENGINE_NO_SCROLL);
        }
        this.setResultSetConcurrency(n2);
        if (n == 1003 && n2 != 1007) {
            n = 1004;
        }
        this.setResultSetType(n);
        if (this.d_canScroll) {
            this.d_lnaStmt.generateCursorName();
            this.setFetchSize(10);
            if (n != 1003) {
                this.d_stmtOpts.setUseBookmarks(1);
            }
        }
        this.d_updateCount = -1;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    protected LNAStatement getLNAStatement() {
        return this.d_lnaStmt;
    }

    @Override
    public java.sql.ResultSet executeQuery(String string) throws SQLException {
        this.execute(string);
        if (this.d_curResults == null) {
            throw new SQLException(LocalStrings.ERR_SQL_NOT_QUERY, "24000", 0);
        }
        return this.d_curResults;
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        this.execute(string);
        if (this.d_updateCount == -1) {
            throw new SQLException(LocalStrings.ERR_SQL_NOT_UPDATE, "S1000", 0);
        }
        return this.d_updateCount;
    }

    @Override
    public void close() throws SQLException {
        if (this.d_curResults != null) {
            this.d_curResults.close();
        }
        this.d_lnaStmt.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.d_stmtOpts.getMaxLength();
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        this.d_stmtOpts.setMaxLength(n);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.d_stmtOpts.getMaxRows();
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        this.d_stmtOpts.setMaxRows(n);
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.d_escapeProc = bl;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.d_stmtOpts.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        this.d_stmtOpts.setQueryTimeout(n);
    }

    @Override
    public void cancel() throws SQLException {
        this.d_lnaStmt.cancelStmt();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return (SQLWarning)this.d_lnaStmt.getErrors(true);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.d_lnaStmt.clearErrors();
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.d_lnaStmt.setCursorName(string);
    }

    @Override
    public boolean execute(String string) throws SQLException {
        int n;
        this.clearResults();
        ParamInfoSet paramInfoSet = new ParamInfoSet();
        ColumnInfoSet columnInfoSet = new ColumnInfoSet();
        ParamDescSet paramDescSet = new ParamDescSet();
        ArrayFetchResultCache arrayFetchResultCache = null;
        int n2 = this.getResultSetConcurrency();
        int n3 = this.getResultSetType();
        if (!this.d_canScroll && n3 == 1003 && n2 == 1007) {
            arrayFetchResultCache = new ArrayFetchResultCache(this.d_lnaStmt);
            n = this.d_lnaStmt.execDirFetch(string, paramInfoSet, columnInfoSet, paramDescSet, arrayFetchResultCache);
        } else {
            n = this.d_lnaStmt.execDirect(string, paramInfoSet, columnInfoSet, paramDescSet);
        }
        if (this.d_curResults != null) {
            this.d_curResults.close();
            this.d_curResults = null;
        }
        if (columnInfoSet.getCount() > 0) {
            this.d_curResults = arrayFetchResultCache != null ? new ResultSet(this, columnInfoSet, arrayFetchResultCache) : new ResultSet(this, columnInfoSet, string);
        } else {
            this.d_updateCount = n;
        }
        return this.d_curResults != null;
    }

    @Override
    public java.sql.ResultSet getResultSet() throws SQLException {
        return this.d_curResults;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.d_updateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.clearResults();
        return false;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.d_fetchDir = n;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.d_fetchDir;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (n <= 0) {
            n = 10;
        } else if (n == 1) {
            n = 2;
        } else if (n > 1000) {
            n = 1000;
        }
        this.d_stmtOpts.setRowSetSize(n);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.d_stmtOpts.getRowSetSize();
    }

    protected final void setResultSetConcurrency(int n) throws SQLException {
        switch (n) {
            case 1007: {
                this.d_stmtOpts.setConcurrency(1);
                break;
            }
            case 1008: {
                this.d_stmtOpts.setConcurrency(3);
            }
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        int n = this.d_stmtOpts.getConcurrency();
        return n == 1 ? 1007 : 1008;
    }

    @Override
    public int getResultSetType() throws SQLException {
        int n = this.d_stmtOpts.getCursorType();
        switch (n) {
            case 0: {
                return 1003;
            }
            case 3: {
                return 1004;
            }
        }
        return 1005;
    }

    protected final void setResultSetType(int n) throws SQLException {
        switch (n) {
            case 1003: {
                this.d_fetchDir = 1000;
                this.d_stmtOpts.setCursorType(0);
                break;
            }
            case 1004: {
                this.d_fetchDir = 1002;
                this.d_stmtOpts.setCursorType(3);
                break;
            }
            case 1005: {
                this.d_fetchDir = 1002;
                this.d_stmtOpts.setCursorType(2);
            }
        }
    }

    @Override
    public void addBatch(String string) throws SQLException {
        if (this.d_sqlBatch == null) {
            this.d_sqlBatch = new Vector();
        }
        this.d_sqlBatch.addElement(string);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.d_sqlBatch != null) {
            this.d_sqlBatch.removeAllElements();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int n = this.d_sqlBatch != null ? this.d_sqlBatch.size() : 0;
        int[] nArray = new int[n];
        int n2 = 0;
        try {
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.executeUpdate(this.d_sqlBatch.elementAt(0));
                this.d_sqlBatch.removeElement(this.d_sqlBatch.elementAt(0));
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray2);
        }
        return nArray;
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        return this.d_conn;
    }

    public void clearResults() throws SQLException {
        if (this.d_curResults != null) {
            this.d_curResults.close();
            this.d_curResults = null;
        }
        this.d_updateCount = -1;
    }

    protected boolean validType(int n) {
        return this.d_canScroll || n == 1003;
    }

    protected boolean validConcur(int n) {
        return this.d_canScroll || n == 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.d_lnaStmt == null) {
            return true;
        }
        return this.d_lnaStmt.isClosed();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLException(LocalStrings.ERR_NO_OBJECT_WRAPPED);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(LocalStrings.ERR_STMT_CLOSED);
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(LocalStrings.ERR_STMT_CLOSED);
        }
        return false;
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    void resultSetClosed() throws SQLException {
        if (this.d_closeOnCompletion) {
            this.d_curResults = null;
            this.close();
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.d_closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.d_closeOnCompletion;
    }
}

