/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.lna.LNAResponse;
import com.pervasive.jdbc.lna.LNAStatement;
import java.io.IOException;
import java.sql.SQLException;

public final class StatementOptions {
    private LNAStatement d_lnaStmt;
    private int d_bindType;
    private int d_concurrency;
    private int d_cursorType;
    private int d_keySetSize;
    private int d_maxLength;
    private int d_maxRows;
    private int d_noScan;
    private int d_queryTimeout;
    private int d_retrieveData;
    private int d_rowSetSize;
    private int d_simulateCursor;
    private int d_useBookmarks;
    private int d_validOptions;

    public StatementOptions() {
    }

    public StatementOptions(LNAStatement lNAStatement, StatementOptions statementOptions) {
        this.d_lnaStmt = lNAStatement;
        this.d_bindType = statementOptions.d_bindType;
        this.d_concurrency = statementOptions.d_concurrency;
        this.d_cursorType = statementOptions.d_cursorType;
        this.d_keySetSize = statementOptions.d_keySetSize;
        this.d_maxLength = statementOptions.d_maxLength;
        this.d_maxRows = statementOptions.d_maxRows;
        this.d_noScan = statementOptions.d_noScan;
        this.d_queryTimeout = statementOptions.d_queryTimeout;
        this.d_retrieveData = statementOptions.d_retrieveData;
        this.d_rowSetSize = statementOptions.d_rowSetSize;
        this.d_simulateCursor = statementOptions.d_simulateCursor;
        this.d_useBookmarks = statementOptions.d_useBookmarks;
        this.d_validOptions = statementOptions.d_validOptions;
    }

    public void readFrom(LNAResponse lNAResponse) throws IOException {
        this.d_bindType = lNAResponse.readInt();
        this.d_concurrency = lNAResponse.readInt();
        this.d_cursorType = lNAResponse.readInt();
        this.d_keySetSize = lNAResponse.readInt();
        this.d_maxLength = lNAResponse.readInt();
        this.d_maxRows = lNAResponse.readInt();
        this.d_noScan = lNAResponse.readInt();
        this.d_queryTimeout = lNAResponse.readInt();
        this.d_retrieveData = lNAResponse.readInt();
        this.d_rowSetSize = lNAResponse.readInt();
        this.d_simulateCursor = lNAResponse.readInt();
        this.d_useBookmarks = lNAResponse.readInt();
        this.d_validOptions = lNAResponse.readInt();
    }

    public int getBindType() {
        return this.d_bindType;
    }

    public int getConcurrency() {
        return this.d_concurrency;
    }

    public void setConcurrency(int n) throws SQLException {
        this.d_lnaStmt.setStmtOpt((short)7, n);
        this.d_concurrency = n;
    }

    public int getCursorType() {
        return this.d_cursorType;
    }

    public void setCursorType(int n) throws SQLException {
        this.d_lnaStmt.setStmtOpt((short)6, n);
        this.d_cursorType = n;
    }

    public int getKeySetSize() {
        return this.d_keySetSize;
    }

    public void setKeySetSize(int n) throws SQLException {
        this.d_lnaStmt.setStmtOpt((short)8, n);
        this.d_keySetSize = n;
    }

    public int getMaxLength() {
        return this.d_maxLength;
    }

    public void setMaxLength(int n) throws SQLException {
        this.d_lnaStmt.setStmtOpt((short)3, n);
        this.d_maxLength = n;
    }

    public int getMaxRows() {
        return this.d_maxRows;
    }

    public void setMaxRows(int n) throws SQLException {
        this.d_lnaStmt.setStmtOpt((short)1, n);
        this.d_maxRows = n;
    }

    public int getNoScan() {
        return this.d_noScan;
    }

    public void setNoScan(int n) throws SQLException {
        this.d_lnaStmt.setStmtOpt((short)2, n);
        this.d_noScan = n;
    }

    public int getQueryTimeout() {
        return this.d_queryTimeout;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.d_lnaStmt.setStmtOpt((short)0, n);
        this.d_queryTimeout = n;
    }

    public int getRetrieveData() {
        return this.d_retrieveData;
    }

    public void setRetrieveData(int n) throws SQLException {
        this.d_lnaStmt.setStmtOpt((short)11, n);
        this.d_retrieveData = n;
    }

    public int getRowSetSize() {
        return this.d_rowSetSize;
    }

    public void setRowSetSize(int n) throws SQLException {
        this.d_lnaStmt.setStmtOpt((short)9, n);
        this.d_rowSetSize = n;
    }

    public int getSimulateCursor() {
        return this.d_simulateCursor;
    }

    public void setSimulateCursor(int n) throws SQLException {
        this.d_lnaStmt.setStmtOpt((short)10, n);
        this.d_simulateCursor = n;
    }

    public int getUseBookmarks() {
        return this.d_useBookmarks;
    }

    public void setUseBookmarks(int n) throws SQLException {
        this.d_lnaStmt.setStmtOpt((short)12, n);
        this.d_useBookmarks = n;
    }

    public int getRowNumber() throws SQLException {
        return this.d_lnaStmt.getStmtOpt((short)14);
    }

    public int getValidOptions() {
        return this.d_validOptions;
    }
}

