/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.common;

import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.UnsupportedEncodingException;

public class Encoding {
    private static String m_defaultEncoding = null;
    protected String m_encoding;

    public Encoding() {
        this.m_encoding = Encoding.getSystemEncoding();
    }

    public Encoding(String string) throws UnsupportedEncodingException {
        this.setNewEncoding(string);
    }

    public String toString() {
        return this.m_encoding;
    }

    public String getEncoding() {
        return this.toString();
    }

    private void setNewEncoding(String string) throws UnsupportedEncodingException {
        if (string == null) {
            this.m_encoding = Encoding.getSystemEncoding();
        } else {
            Encoding.checkEncoding(string);
            this.m_encoding = string;
        }
    }

    public void setEncoding(String string) {
        this.m_encoding = string == null ? Encoding.getSystemEncoding() : string;
    }

    public static void checkEncoding(String string) throws UnsupportedEncodingException {
        if (string != null) {
            byte[] byArray = new byte[]{65, 66, 67};
            String string2 = new String(byArray, string);
        }
    }

    public static String getSystemEncoding() {
        if (m_defaultEncoding != null) {
            return m_defaultEncoding;
        }
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(new PipedInputStream());
            m_defaultEncoding = inputStreamReader.getEncoding().toString();
            inputStreamReader = null;
            return m_defaultEncoding;
        }
        catch (Throwable throwable) {
            try {
                m_defaultEncoding = System.getProperty("file.encoding");
                return m_defaultEncoding;
            }
            catch (Throwable throwable2) {
                m_defaultEncoding = "US-ASCII";
                return m_defaultEncoding;
            }
        }
    }
}

