/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.psql.utilities.javadti;

import com.pervasive.psql.utilities.javadti.Connection;
import com.pervasive.psql.utilities.javadti.DTICONSTS;
import com.pervasive.psql.utilities.javadti.DTIException;
import com.pervasive.psql.utilities.javadti.PVCOMMSTATEX;
import com.pervasive.psql.utilities.javadti.PVMKDEUSAGEEX2;
import com.pervasive.psql.utilities.javadti.PVVERSION;
import com.pervasive.psql.utilities.javadti.javadti;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class MkdeMisc {
    private static Map<Connection, MkdeMisc> mkdeMiscMap = new HashMap<Connection, MkdeMisc>();
    private Connection m_conn;
    private Logger m_logger;

    private MkdeMisc(Connection connection, String string) {
        this.m_conn = connection;
        this.m_logger = Logger.getLogger(string);
    }

    public static MkdeMisc getObject(Connection connection, String string) {
        MkdeMisc mkdeMisc = mkdeMiscMap.get(connection);
        if (mkdeMisc != null) {
            return mkdeMisc;
        }
        mkdeMisc = new MkdeMisc(connection, string);
        mkdeMiscMap.put(connection, mkdeMisc);
        return mkdeMisc;
    }

    public void getMkdeCommStatEx(PVCOMMSTATEX pVCOMMSTATEX) throws DTIException {
        int n = javadti.JPvGetMkdeCommStatEx(this.m_conn.getHandle(), pVCOMMSTATEX);
        if (n != DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetMkdeCommStatEx failed");
            throw new DTIException(n);
        }
        this.m_logger.finer("JPvGetMkdeCommStatEx succeeded");
    }

    public void getMkdeUsageEx(PVMKDEUSAGEEX2 pVMKDEUSAGEEX2) throws DTIException {
        int n = javadti.JPvGetMkdeUsageEx(this.m_conn.getHandle(), pVMKDEUSAGEEX2);
        if (n != DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetMkdeUsageEx failed");
            throw new DTIException(n);
        }
        this.m_logger.finer("JPvGetMkdeUsageEx succeeded");
    }

    public void getMkdeVersion(PVVERSION pVVERSION) throws DTIException {
        int n = javadti.JPvGetMkdeVersion(this.m_conn.getHandle(), pVVERSION);
        if (n != DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetMkdeVersion failed");
            throw new DTIException(n);
        }
        this.m_logger.finer("JPvGetMkdeVersion succeeded");
    }
}

