/*
 * Decompiled with CFR 0.152.
 */
package pervasive.database;

import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import pervasive.database.Database;
import pervasive.database.FieldDef;
import pervasive.database.IBTRV;
import pervasive.database.IOBuffer;
import pervasive.database.MessageCatalog;
import pervasive.database.PsqlIOException;
import pervasive.database.PsqlInvalidObjectException;
import pervasive.database.SCursor;
import pervasive.database.Term;
import pervasive.database.Timestamp;

public class XCursor
extends SCursor {
    private static final int BT_GETNEXTEXT = 36;
    private static final int BT_GETPREVEXT = 37;
    private static final int BT_STEPNEXTEXT = 38;
    private static final int BT_STEPPREVEXT = 39;
    private static final int ADD_ARRAY = 5;
    private static final short IC_EG = 18245;
    private static final short IC_UC = 17237;
    private byte[] m_hdrData = new byte[8];
    private int m_currLen = 0;
    private int m_maxCacheSize = 63105;
    private int m_maxRejectCount = 0;
    private int m_prevRecSize = 0;
    private int m_currTerms = 0;
    private int m_newRecSize = 0;
    private int m_totalRecs = 0;
    private boolean m_includeCurrent = true;
    private boolean m_lastCallWasExops = false;
    int m_currFields = 0;
    FieldDef[] m_fields;
    Term[] m_terms;

    XCursor(Database database, IBTRV iBTRV, int n, String string) {
        super(database, iBTRV, n, string);
    }

    XCursor(Database database, IBTRV iBTRV, int n, int n2, String string) {
        super(database, iBTRV, n, n2, string);
    }

    public final void setCacheSize(int n) {
        if (n <= 63105) {
            this.m_maxCacheSize = n;
        }
    }

    public final int getCacheSize() {
        return this.m_maxCacheSize;
    }

    public final void addFirstTerm(FieldDef fieldDef, byte by, String string) {
        this.addFirstTerm(fieldDef, by, string, true);
    }

    public final void addFirstTerm(FieldDef fieldDef, byte by, FieldDef fieldDef2) {
        this.addFirstTerm(fieldDef, by, fieldDef2, false);
    }

    public final void addAndTerm(FieldDef fieldDef, byte by, String string) {
        this.addTerm(fieldDef, by, (byte)1, string, true);
    }

    public final void addAndTerm(FieldDef fieldDef, byte by, FieldDef fieldDef2) {
        this.addTerm(fieldDef, by, (byte)1, fieldDef2, false);
    }

    public final void addOrTerm(FieldDef fieldDef, byte by, String string) {
        this.addTerm(fieldDef, by, (byte)2, string, true);
    }

    public final void addOrTerm(FieldDef fieldDef, byte by, FieldDef fieldDef2) {
        this.addTerm(fieldDef, by, (byte)2, fieldDef2, false);
    }

    public final void dropAllTerms() {
        this.m_terms = null;
        this.m_currTerms = 0;
    }

    public void dropAllFields() {
        this.m_fields = null;
        this.m_currFields = 0;
    }

    void dropAll() {
        this.dropAllTerms();
        this.dropAllFields();
        this.m_currLen = 0;
        this.m_totalRecs = 0;
    }

    public final void addField(FieldDef fieldDef) {
        if (this.m_currFields == 0) {
            this.m_fields = new FieldDef[5];
        }
        if (this.m_fields.length <= this.m_currFields) {
            FieldDef[] fieldDefArray = this.m_fields;
            this.m_fields = new FieldDef[this.m_fields.length + 5];
            for (int i = 0; i < fieldDefArray.length; ++i) {
                this.m_fields[i] = fieldDefArray[i];
            }
        }
        this.m_fields[this.m_currFields] = fieldDef;
        ++this.m_currFields;
    }

    public final void setRejectCount(int n) {
        this.m_maxRejectCount = n;
    }

    public final void setIncludeCurrent(boolean bl) {
        this.m_includeCurrent = bl;
    }

    public final int getNextExtended() throws PsqlIOException {
        return this.getNextExtended(0);
    }

    public final int getNextExtended(int n) throws PsqlIOException {
        this.postToDataBuffer();
        int n2 = super.BTRV(36 + n);
        this.m_lastCallWasExops = true;
        this.setDataSize(this.m_prevRecSize);
        this.m_totalRecs = this.m_bytesRcvd == 0 ? 0 : (int)this.m_dBuffer.readShort(0);
        this.checkFatalStatus(n2);
        return n2;
    }

    public final int getPreviousExtended() throws PsqlIOException {
        return this.getPreviousExtended(0);
    }

    public final int getPreviousExtended(int n) throws PsqlIOException {
        this.postToDataBuffer();
        int n2 = super.BTRV(37 + n);
        this.m_lastCallWasExops = true;
        this.setDataSize(this.m_prevRecSize);
        this.m_totalRecs = this.m_bytesRcvd == 0 ? 0 : (int)this.m_dBuffer.readShort(0);
        this.checkFatalStatus(n2);
        return n2;
    }

    public final int stepNextExtended() throws PsqlIOException {
        return this.stepNextExtended(0);
    }

    public final int stepNextExtended(int n) throws PsqlIOException {
        this.postToDataBuffer();
        int n2 = super.BTRV(38 + n);
        this.m_lastCallWasExops = true;
        this.setDataSize(this.m_prevRecSize);
        this.m_totalRecs = this.m_dBuffer.readShort(0);
        this.checkFatalStatus(n2);
        return n2;
    }

    public final int stepPreviousExtended() throws PsqlIOException {
        return this.stepPreviousExtended(0);
    }

    public final int stepPreviousExtended(int n) throws PsqlIOException {
        this.postToDataBuffer();
        int n2 = super.BTRV(39 + n);
        this.m_lastCallWasExops = true;
        this.setDataSize(this.m_prevRecSize);
        this.m_totalRecs = this.m_dBuffer.readShort(0);
        this.checkFatalStatus(n2);
        return n2;
    }

    public final int getRecordCount() {
        if (this.m_lastCallWasExops) {
            return this.m_totalRecs;
        }
        return 1;
    }

    public final int convertOffset(int n, int n2) {
        int n3 = this.getRecordOffset(n2);
        if (n3 == 0) {
            return -1;
        }
        return n3 += 6 + n;
    }

    public int getAddress(int n) {
        if (n == -1) {
            return -1;
        }
        if (!this.m_lastCallWasExops) {
            return this.getAddress();
        }
        int n2 = this.getRecordOffset(n);
        if (n2 == 0) {
            return -1;
        }
        return this.m_dBuffer.readInteger(n2 + 2);
    }

    public int getRecLength(int n) {
        if (!this.m_lastCallWasExops) {
            return this.getRecLength();
        }
        int n2 = this.getRecordOffset(n);
        if (n2 == 0) {
            return -1;
        }
        return this.m_dBuffer.readShort(n2);
    }

    @Override
    public final int BTRV(int n) throws PsqlIOException {
        if (this.isClosed()) {
            throw new PsqlInvalidObjectException(MessageCatalog.getObjectClosedMsg(this));
        }
        int n2 = n % 100;
        int n3 = n - n2;
        switch (n2) {
            case 37: {
                return this.getPreviousExtended(n3);
            }
            case 36: {
                return this.getNextExtended(n3);
            }
            case 39: {
                return this.stepPreviousExtended(n3);
            }
            case 38: {
                return this.stepNextExtended(n3);
            }
        }
        this.m_lastCallWasExops = false;
        return super.BTRV(n);
    }

    final void getExOpRecord(byte[] byArray, int n) {
        short s = 0;
        int n2 = this.getRecordOffset(n);
        s = this.m_dBuffer.readShort(n2);
        this.m_dBuffer.readBytes(byArray, n2 + 6, s);
    }

    final void getRecordImage(byte[] byArray, int n) {
        if (this.m_lastCallWasExops) {
            this.getExOpRecord(byArray, n);
        } else {
            this.m_dBuffer.readBytes(byArray, 0, this.getRecLength());
        }
    }

    final int getExtRecordSize() {
        int n = 0;
        if (this.m_fields == null) {
            n = this.getDataSize();
        } else {
            for (int i = 0; i < this.m_currFields; ++i) {
                n += this.m_fields[i].m_length;
            }
        }
        return n;
    }

    final int getNumberOfFields() {
        return this.m_currFields;
    }

    private final void addFirstTerm(FieldDef fieldDef, byte by, Object object, boolean bl) {
        this.dropAllTerms();
        this.m_terms = new Term[5];
        this.m_terms[0] = new Term();
        if (bl) {
            this.m_terms[0].addTerm(fieldDef, by, (String)object);
        } else {
            this.m_terms[0].addTerm(fieldDef, by, (FieldDef)object);
        }
        this.m_terms[0].makeLast();
        this.m_currTerms = 1;
    }

    private final void addTerm(FieldDef fieldDef, byte by, byte by2, Object object, boolean bl) {
        if (this.m_terms.length <= this.m_currTerms) {
            Term[] termArray = this.m_terms;
            this.m_terms = new Term[this.m_terms.length + 5];
            for (int i = 0; i < termArray.length; ++i) {
                this.m_terms[i] = termArray[i];
            }
        }
        this.m_terms[this.m_currTerms] = new Term();
        if (bl) {
            this.m_terms[this.m_currTerms].addTerm(fieldDef, by, (String)object);
        } else {
            this.m_terms[this.m_currTerms].addTerm(fieldDef, by, (FieldDef)object);
        }
        if (by2 == 1 && this.m_currTerms > 0) {
            this.m_terms[this.m_currTerms - 1].makeAnd();
        }
        if (by2 == 2 && this.m_currTerms > 0) {
            this.m_terms[this.m_currTerms - 1].makeOr();
        }
        this.m_terms[this.m_currTerms].makeLast();
        ++this.m_currTerms;
    }

    private final void postToDataBuffer() {
        int n;
        int n2;
        IOBuffer iOBuffer = this.m_btrvObj.createIOBuffer(9, "US-ASCII");
        this.m_prevRecSize = this.getDataSize();
        this.m_currLen = 0;
        this.m_dBuffer.writeShort(this.m_includeCurrent ? (short)17237 : 18245, 2);
        this.m_dBuffer.writeUnsignedShort(this.m_maxRejectCount, 4);
        this.m_dBuffer.writeUnsignedShort(this.m_currTerms, 6);
        for (n2 = 0; n2 < this.m_currTerms; ++n2) {
            int n3 = this.m_terms[n2].getInfo(iOBuffer);
            this.m_dBuffer.writeBytes(iOBuffer.getBufferData(), 8 + this.m_currLen, n3);
            this.m_currLen += n3;
            if (n3 != 7) continue;
            String string = this.m_terms[n2].getConstant();
            n = this.m_terms[n2].getFieldLength();
            n3 = 0;
            byte[] byArray = new byte[1];
            switch (this.m_terms[n2].getFieldType()) {
                case 1: 
                case 14: 
                case 15: {
                    Object object;
                    switch (n) {
                        case 1: {
                            try {
                                object = string.getBytes("US-ASCII");
                                this.m_dBuffer.writeBytes((byte[])object, this.m_currLen + 8, 1);
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {}
                            break;
                        }
                        case 2: {
                            this.m_dBuffer.writeShort((short)Integer.parseInt(string), this.m_currLen + 8);
                            break;
                        }
                        case 4: {
                            this.m_dBuffer.writeInteger(Integer.parseInt(string), this.m_currLen + 8);
                            break;
                        }
                        case 8: {
                            this.m_dBuffer.writeLong(Long.parseLong(string), this.m_currLen + 8);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n) {
                        case 4: {
                            this.m_dBuffer.writeFloat(Float.valueOf(string).floatValue(), this.m_currLen + 8);
                            break;
                        }
                        case 8: {
                            this.m_dBuffer.writeDouble(Double.valueOf(string), this.m_currLen + 8);
                        }
                    }
                    break;
                }
                case 3: {
                    Object object;
                    try {
                        object = DateFormat.getDateInstance().parse(string);
                        this.m_dBuffer.writeDate((Date)object, this.m_currLen + 8);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    n = 4;
                    break;
                }
                case 4: {
                    Object object;
                    try {
                        object = DateFormat.getDateInstance().parse(string);
                        this.m_dBuffer.writeTime((Date)object, this.m_currLen + 8);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    n = 4;
                    break;
                }
                case 20: {
                    Object object = Timestamp.valueOf(string);
                    this.m_dBuffer.writeLong(((Timestamp)object).septaValue(), this.m_currLen + 8);
                    break;
                }
                case 7: {
                    byte[] byArray2 = new byte[]{0, 0};
                    if (string.equalsIgnoreCase(new String("TRUE"))) {
                        byArray2[0] = 1;
                    }
                    this.m_dBuffer.writeBytes(byArray2, this.m_currLen + 8, n);
                    break;
                }
                case 9: {
                    double d = Double.valueOf(string);
                    this.m_dBuffer.writeBfloat(d, this.m_currLen + 8, n);
                    break;
                }
                case 10: {
                    n = string.length();
                    this.m_dBuffer.writeLString(string, this.m_currLen + 8, n + 1);
                    break;
                }
                case 11: {
                    n = string.length();
                    this.m_dBuffer.writeZString(string, this.m_currLen + 8, n);
                    break;
                }
                case 255: {
                    byArray = string.getBytes();
                    this.m_dBuffer.writeByte(byArray[0], this.m_currLen + 8);
                    break;
                }
                default: {
                    n = string.length();
                    this.m_dBuffer.writeString(string, this.m_currLen + 8, n);
                }
            }
            this.m_dBuffer.writeShort((short)n, this.m_currLen + 2);
            this.m_currLen += n;
        }
        short s = (short)(this.m_currLen + 8);
        n = 0;
        this.m_currLen += 2;
        this.m_dBuffer.writeShort((short)this.m_currFields, this.m_currLen + 8);
        this.m_currLen += 2;
        for (n2 = 0; n2 < this.m_currFields; ++n2) {
            this.m_dBuffer.writeShort((short)this.m_fields[n2].m_length, this.m_currLen + 8);
            this.m_currLen += 2;
            this.m_dBuffer.writeShort((short)this.m_fields[n2].m_recordOffset, this.m_currLen + 8);
            this.m_currLen += 2;
            n += this.m_fields[n2].m_length;
        }
        short s2 = (short)((this.m_maxCacheSize - 2) / (n + 6));
        this.m_dBuffer.writeShort(s2, s);
        this.m_dBuffer.writeShort((short)(this.m_currLen + 8), 0);
        this.setDataSize(this.m_maxCacheSize);
        this.m_currLen = 0;
    }

    private final int getRecordOffset(int n) {
        if (n >= this.m_totalRecs) {
            return -1;
        }
        int n2 = 2;
        for (int i = 0; i < n; ++i) {
            if (n2 > 64129) {
                return 0;
            }
            n2 += 6 + this.m_dBuffer.readShort(n2);
        }
        return n2;
    }

    private final void checkFatalStatus(int n) {
        switch (n) {
            case 0: 
            case 9: 
            case 22: 
            case 60: 
            case 64: 
            case 84: {
                break;
            }
            default: {
                this.m_totalRecs = 0;
            }
        }
    }

    Term[] getTerms() {
        if (this.m_currTerms == 0) {
            return null;
        }
        Term[] termArray = new Term[this.m_currTerms];
        for (int i = 0; i < this.m_currTerms; ++i) {
            termArray[i] = this.m_terms[i];
        }
        return termArray;
    }

    void setTerms(Term[] termArray) {
        this.m_terms = termArray;
        this.m_currTerms = termArray == null ? 0 : termArray.length;
    }
}

