/*
 * This system procedure is used to return the list
 * of tables and the corresponding information from the
 * database specified
 */
 
CREATE PROCEDURE psp_tables
(   
	in :database_qual   VARCHAR(20) = DATABASE(), -- Name of the database
    in :table_name      VARCHAR(255)  = NULL,  -- Name of the table
    in :tab_type        VARCHAR(32) = NULL   -- Table flag
)
RETURNS
(
    TABLE_QUALIFIER     VARCHAR (20), -- Name of the database that contains the table
    TABLE_OWNER         VARCHAR (20),  -- owner of the table
    TABLE_NAME          VARCHAR(255),  -- Name of the Table
    TABLE_TYPE          VARCHAR(15),  -- Table Type
    REMARKS	            VARCHAR(255),  -- Remarks
    FILE_LOCATION       VARCHAR(255)  -- Location of the file (path name)
);

BEGIN
    -- Variable to hold the dynamic query
    DECLARE :stmt_psp_tables LONGVARCHAR;

    -- Variable to hold the information about the table type
    DECLARE :table_flag VARCHAR(3);
    
    -- Check if the database qualifier specified is a blank string
	if (rtrim(:database_qual) = '') then
		SIGNAL 'S1000', 'Please enter a valid database name. Database name cannot be a blank string'; 
	end if;

     -- Check if the table name specified is a blank string
	if (rtrim(:table_name) = '') then
		SIGNAL 'S1000', 'Table name cannot be a blank string'; 
	end if;
    
     -- Check if the tab_type specified is a blank string
	if (rtrim(:tab_type) = '') then
		SIGNAL 'S1000', 'Table type cannot be a blank string'; 
	end if;

    SET :database_qual = IFNULL(:database_qual,DATABASE());

	--	If table name is null or not supplied, 
	--  match all the tables

	SET :table_name = IFNULL(:table_name,'%');
	
	-- Check for the table flag
	
	IF :tab_type IS NULL THEN
	
	set :stmt_psp_tables  = ' SELECT ''' + 
									:database_qual +
									''', null, ' +
									' Xf$Name, ' + 
									' case (Xf$Flags & 16) ' +
										' when 16 then ' + '''SYSTEM TABLE''' +
										' else ' + '''USER TABLE''' +
										'end, ' + 
									'null, ' +
									' Xf$Loc ' +
    								' FROM "' + :database_qual + '".X$File ' +
    								' WHERE ' + 
									'Xf$Name LIKE ''' + :table_name + ''';'
    	
	ELSE
	
		IF (ucase(:tab_type) = 'USER TABLE') THEN
			SET :table_flag = '64';
		ELSE 
			IF (ucase(:tab_type) = 'SYSTEM TABLE') THEN
				SET :table_flag = '16';
			ELSE
			    SIGNAL 'S1000', 'Table type can be System table or User table
                or null';
			END IF
		END IF
    	-- Enumerate tables when table flag is not null
    	
    	set :stmt_psp_tables  = ' SELECT ''' +
								:database_qual + 
								''', null, ' +
								'Xf$Name, ''' +
								:tab_type + 
								''', null, ' +
								' Xf$Loc ' +
    							' FROM "' + :database_qual + '".X$File ' +
    							' WHERE ' + 'Xf$Name LIKE ''' + :table_name +
								''' AND ( Xf$Flags & ' + :table_flag + ') = ' +
                                :table_flag + ';'
    	
	END IF

    exec (:stmt_psp_tables);
	
END; -- End of the stored procedure.
