/**
 * This system procedure is used to return the
 * the procedure rights for the given procedure(s).
 */
CREATE PROCEDURE psp_procedure_rights
(  
    in :database_qual   VARCHAR(20) = DATABASE(), -- Name of the database
    in :procedure_name  VARCHAR(255) = NULL, -- Name of the procedure
    in :user_name       VARCHAR(255) = USER() -- Name of the user
)
RETURNS
(
    PROCEDURE_QUALIFIER     VARCHAR (20), -- Name of the database that contains the procedure
    PROCEDURE_OWNER         VARCHAR (20),  -- owner of the procedure
    USER_NAME           CHAR(255), -- Name of the user
    PROCEDURE_NAME      CHAR(255), -- Name of the procedure
    RIGHTS              VARCHAR(12)  -- Procedure rights 
);
BEGIN

	-- This variable stores the dynamic query
	DECLARE :query              LONGVARCHAR;
    
	-- This variable stores the procedure name concatenated with 
	-- the database qualifier in the form dbname.procedurename
    DECLARE :procedure_table_name    VARCHAR(30);
    DECLARE :rights_table_name  VARCHAR(30);
    DECLARE :user_table_name    VARCHAR(30);

    -- Variable to store the Metadata version
    DECLARE :version INTEGER;

    -- If the database qualifier is null, then use the current database
	if (:database_qual is null) then
		set :database_qual = DATABASE();
	end if;
	
    -- Check if the database qualifier specified is a blank string
	if (rtrim(:database_qual) = '') then
		SIGNAL 'S1000', 'Please enter a valid database name. Database name cannot be a blank string'; 
	end if;
    
    -- Check if the column name is a blank string
	if (rtrim(:procedure_name) = '') then
		SIGNAL 'S1000', 'Procedure name cannot be blank string';
	end if;		
    
    -- Check if the user name is a blank string
	if (rtrim(:user_name) = '') then
		SIGNAL 'S1000', 'User name cannot be a blank string';
	end if;
	
	   
    SET :procedure_table_name = '"' + :database_qual + '".X$Proc';
    SET :rights_table_name = '"' + :database_qual + '".X$Rights';
    SET :user_table_name = '"' + :database_qual + '".X$User';
    
	/* If procedure name is not supplied or value is null
	   match all the tables*/
	   
    SET :procedure_name = IFNULL(:procedure_name,'%');
    SET :user_name = IFNULL(:user_name , USER());

    -- Get the Metadata Version
    CALL psp_database_version(:database_qual, :version);

    IF (:version = 1) THEN
    
	SIGNAL 'S1000', 'View and Stored Procedure permissions are not supported for metadata version 1';

    ELSE
     SET :query = 'SELECT ''' + :database_qual + ''' , null, ' +
        		 'B.Xu$Name, A.Xp$Name, ''EXECUTE'' ' +
            	 'FROM ' + :procedure_table_name + ' A, ' + 
                 :user_table_name + ' B, ' + :rights_table_name +
                 ' C WHERE 	A.Xp$Name LIKE ''' + :procedure_name +
                 ''' AND B.Xu$Name LIKE ''' + :user_name +
                 ''' AND A.Xp$Id = C.Xr$Object AND B.Xu$Id = C.Xr$User ' +
                 'AND C.Xr$rights & 192 = 192 AND C.Xr$Column = 0 AND C.Xr$Type = 3 ' + 
                 'UNION SELECT ''' + :database_qual + ''' , null, ' +
        		 'B.Xu$Name, A.Xp$Name, ''ALTER'' ' +
            	 'FROM ' + :procedure_table_name + ' A, ' + 
                 :user_table_name + ' B, ' + :rights_table_name +
                 ' C WHERE 	A.Xp$Name LIKE ''' + :procedure_name +
                 ''' AND B.Xu$Name LIKE ''' + :user_name +
                 ''' AND A.Xp$Id = C.Xr$Object AND B.Xu$Id = C.Xr$User ' +
                 'AND C.Xr$rights & 160 = 160 AND C.Xr$Column = 0 AND C.Xr$Type = 3 ' ;
    END IF;
		 
    exec(:query);

END;
 -- End of the stored procedure.


