/*
 * This system procedure is used to return the list
 * of stored procedures available in the database specified.
 */
CREATE PROCEDURE psp_stored_procedures
(   
	in :database_qual    VARCHAR(20) = DATABASE(), -- Name of the database
    in :procedure_name   VARCHAR(255) = NULL, -- Name of the procedure
    in :procedure_type   VARCHAR(32) = NULL -- Type of the procedure
)

RETURNS
(
    PROCEDURE_QUALIFIER VARCHAR (20), 	-- Name of the database that contains the Stored Procedure
    PROCEDURE_OWNER     VARCHAR (20), 	-- Owner of the Stored Procedure
    PROCEDURE_NAME      VARCHAR(255), -- Name of the procedure
    PROCEDURE_TYPE      VARCHAR(30), -- Type of the procedure
	NUM_INPUT_PARAMS    INTEGER,  -- No. of input paramaters
	NUM_OUTPUT_PARAMS   INTEGER, -- no. of out parameters
	NUM_RESULT_SETS     INTEGER, -- no. of columns in result set.
    REMARKS             VARCHAR(255),	-- Remarks
    TRUSTEE             INTEGER
);

BEGIN
    -- Variable to hold the dynamic query
    DECLARE :stmt_psp_stored_procedures LONGVARCHAR;

    -- Variable to hold the information about the proc type
    DECLARE :proc_flag CHAR(1);

    -- Variable to hold the database version
    DECLARE :version	INTEGER;

    -- Check if the database qualifier specified is a blank string
	if (rtrim(:database_qual) = '') then
		SIGNAL 'S1000', 'Please enter a valid database name. Database name cannot be a blank string'; 
	end if;

     -- Check if the procedure_name specified is a blank string
	if (rtrim(:procedure_name) = '') then
		SIGNAL 'S1000', 'Procedure name cannot be a blank string'; 
	end if;
    
    -- Check if the table_name is null
--    if (:procedure_name is null) then
  --  	SIGNAL 'S1000', 'Procedure name cannot be null'; 
    --end if;
    
     -- Check if the procedure_type specified is a blank string
	if (rtrim(:procedure_type) = '') then
		SIGNAL 'S1000', 'Procedure type cannot be a blank string'; 
	end if;
    
	SET :database_qual = IFNULL(:database_qual,database());
    
    -- Check whether the Database is a V1 or a V2.
    CALL psp_database_version(:database_qual, :version);
	
	-- If procedure name is not supplied or value is null
	-- match all the procedure names
	SET :procedure_name = IFNULL(:procedure_name,'%');
	
    IF (:version = 1) THEN
	IF :procedure_type IS NULL THEN

	    SET :stmt_psp_stored_procedures = ' SELECT  ''' +
										:database_qual +
										''', null, ' +
										' Xp$Name, ' +
										' case Xp$Flags ' +
										   ' when 0 then ' + 
                                              '''STORED PROCEDURE''' +
											  ' when 2 then ' + 
                                                  '''ENCRYPTED STORED 
                                                  PROCEDURE''' +
												' when 4 then ' + 
                                                    '''SYSTEM STORED 
                                                    PROCEDURE''' +
										' end, ' +
										' null, ' +
										' null, ' +
										' null, ' +
                                            ' null, null '+
                                            ' FROM "' + :database_qual +
                                            '".X$Proc '+
	    								' WHERE Xp$Name LIKE ''' + 
                                        :procedure_name + 
                                        ''' AND Xp$Flags <> 1; '
	ELSE										
	    IF (ucase(:procedure_type) = 'SP') THEN
			SET :proc_flag = '0';
		ELSE 
			IF (ucase(:procedure_type) = 'SSP') THEN
				SET :proc_flag = '4'; -- Currently xp$flags for PSPs are set as 0.
			ELSE
				SIGNAL 'S1000', 'Procedure Type can be SP, SSP or null';
			END IF
		END IF

	    SET :stmt_psp_stored_procedures = ' SELECT  ''' +
											:database_qual +
											''', null, ' +
											' Xp$Name, ' +
										' case Xp$Flags ' +
											' when 0 then ' + 
                                               '''STORED PROCEDURE''' +
											' when 2 then ' + 
                                                   '''ENCRYPTED STORED 
                                                   PROCEDURE''' +
                                            ' when 4 then ' + 
                                                   '''SYSTEM STORED 
                                                   PROCEDURE''' +
											' end, ' +
											' null, ' +
											' null, ' +
											' null, ' +
                                                ' null, null '+
	    									' FROM "' + :database_qual +
                                            '".X$Proc ' +
	    									' WHERE Xp$Name LIKE ''' + 
                                            :procedure_name +
                                                ''' AND Xp$Flags = ' + 
                                                :proc_flag +
                                            '; '

	END IF
    ELSE
    --IF (:version = 2) THEN
        IF :procedure_type IS NULL THEN
            SET :stmt_psp_stored_procedures = ' SELECT  ''' +
                                            :database_qual +
                                            ''', null, ' +
                                            ' Xp$Name, ' +
                                            ' case Xp$Flags ' +
                                               ' when 0 then ' + 
                                                  '''STORED PROCEDURE''' +
                                                  ' when 2 then ' + 
                                                  '''ENCRYPTED STORED 
                                                  PROCEDURE''' +
                                                    ' when 4 then ' + 
                                                    '''SYSTEM STORED 
                                                    PROCEDURE''' +
                                            ' end, ' +
                                            ' null, ' +
                                            ' null, ' +
                                            ' null, ' +
                                            ' null, Xp$Trustee'+
                                            ' FROM "' + :database_qual +
                                            '".X$Proc '+
                                            ' WHERE Xp$Name LIKE ''' + 
                                            :procedure_name + 
                                            ''' AND Xp$Flags <> 1; '
        ELSE										
            IF (ucase(:procedure_type) = 'SP') THEN
                SET :proc_flag = '0';
            ELSE 
                IF (ucase(:procedure_type) = 'SSP') THEN
                    SET :proc_flag = '4'; -- Currently xp$flags for PSPs are set as 0.
                ELSE
                    SIGNAL 'S1000', 'Procedure Type can be SP, SSP or null';
                END IF
            END IF

            SET :stmt_psp_stored_procedures = ' SELECT  ''' +
                                                :database_qual +
                                                ''', null, ' +
                                                ' Xp$Name, ' +
                                            ' case Xp$Flags ' +
                                                ' when 0 then ' + 
                                                   '''STORED PROCEDURE''' +
                                                ' when 2 then ' + 
                                                   '''ENCRYPTED STORED 
                                                   PROCEDURE'''
                                               +
                                            ' when 4 then ' + 
                                                   '''SYSTEM STORED 
                                                   PROCEDURE''' +
											' end, ' +
											' null, ' +
											' null, ' +
											' null, ' +
                                                ' null, Xp$Trustee '+
	    									' FROM "' + :database_qual +
                                            '".X$Proc ' +
	    									' WHERE Xp$Name LIKE ''' + 
                                            :procedure_name +
                                                ''' AND Xp$Flags = ' + 
                                                :proc_flag +
                                            '; '

	END IF
    END IF
    exec (:stmt_psp_stored_procedures);
END; -- End of the stored procedure.
