/* DEFERRABILITY ommited */
/*
 * This system procedure returns the foreign key information
 * for a given table(s).
 */
CREATE PROCEDURE psp_fkeys
(   
	in :database_qual   VARCHAR(20) = DATABASE(), -- Name of the database
    in :pktable_name    VARCHAR(255), -- Name of the primary key table
    in :fktable_name    VARCHAR(255) = NULL  -- Name of the foreign key table
)

RETURNS
(
    PKTABLE_QUALIFIER   VARCHAR (20), -- Name of the database that contains the Primary key table
    PKTABLE_OWNER       VARCHAR (20),  -- owner of the primary key table
    PKTABLE_NAME        VARCHAR(255),  -- Name of the primary key table
    PKCOLUMN_NAME       VARCHAR(255),  -- Name of the primary key column
    KEY_SEQ             USMALLINT, -- Sequence of the keys
    FKTABLE_QUALIFIER   VARCHAR (20), -- Name of the database that contains the Foreign key table
    FKTABLE_OWNER       VARCHAR (20),  -- owner of the Foreign key  table
    FKTABLE_NAME        VARCHAR(255),  -- Name of the foriegn key table
    FKCOLUMN_NAME       VARCHAR(255),  -- Name of the foreign key column
    UPDATE_RULE         UTINYINT,  -- Update rule 
    DELETE_RULE         UTINYINT,  -- Delete rule
    PK_NAME             VARCHAR(255),  -- Name of the primary key
    FK_NAME             VARCHAR(255)   -- Name of the foreign key
);

BEGIN
    -- Variable to hold the dynamic query
    DECLARE :stmt_psp_fkeys LONGVARCHAR;

    -- Check if the database qualifier specified is a blank string
	if (rtrim(:database_qual) = '') then
		SIGNAL 'S1000', 'Please enter a valid database name. Database name cannot be a blank string'; 
	end if;
    
     -- Check if the table_name is null
    if (:pktable_name is null) then
    	SIGNAL 'S1000', 'Primary key table name cannot be null'; 
    end if;
    
     -- Check if the table_name specified is a blank string
	if (rtrim(:pktable_name) = '') then
		SIGNAL 'S1000', 'Primary key table name cannot be a blank string'; 
	end if;

     -- Check if the table_name specified is a blank string
	if (rtrim(:fktable_name) = '') then
		SIGNAL 'S1000', 'Foreign key table name cannot be a blank string'; 
	end if;

	SET :database_qual = IFNULL(:database_qual,DATABASE());

	/*	If foreign key table name is null or not supplied, 
	    match all the foreign key tables */
	SET :fktable_name = IFNULL(:fktable_name,'%');
	
	/* Enumerate all the foreign key information */
	
	SET :stmt_psp_fkeys = ' SELECT ''' +
							:database_qual +			/* PKTABLE_QUALIFIER */ 
							''', null, ' +				/* PKTABLE_OWNER */	
							' B.Xf$Name, ' +			/* PKTABLE_NAME */
							' F.Xe$Name, ' +			/* PKCOLUMN_NAME */
							' D.Xi$Part, ''' + 			/* KEY_SEQUENCE */
							:database_qual +			/* FKTABLE_QUALIFIER */ 
							''', null, ' +				/* FKTABLE_OWNER */	
							' C.Xf$Name, ' +			/* FKTABLE_NAME */
							' H.Xe$Name, ' +			/* FKCOLUMN_NAME */ 
		   					' A.Xr$UpdateRule, ' +		/* UPDATE_RULE */
							' A.Xr$DeleteRule,  ' +		/* DELETE_RULE */
							' E.Xe$Name, ' +			/* PK_NAME */
							' A.Xr$Name	' +				/* FK_NAME */
							' FROM "' + :database_qual + '".X$Relate A ,"' +
									   :database_qual + '".X$File B, "' + 
									   :database_qual + '".X$File C, "' + 
									   :database_qual + '".X$Index D, "' + 
									   :database_qual + '".X$Field E, "' +
									   :database_qual + '".X$Field F, "' +
									   :database_qual + '".X$Index G, "' +
									   :database_qual + '".X$Field H ' +
							' WHERE A.Xr$PId = B.Xf$Id AND ' +
    						' B.Xf$Name LIKE ''' + :pktable_name +
							''' AND A.Xr$FId = C.Xf$Id AND ' +
      						' C.Xf$Name LIKE ''' + :fktable_name +
							''' AND B.Xf$Id = D.Xi$File AND ' +
      						' A.Xr$Index = D.Xi$Number AND ' +
      						' D.Xi$File = E.Xe$File AND ' +
      						' D.Xi$Number = E.Xe$Offset AND ' +
      						' E.Xe$DataType = 227 AND ' +
      						' A.Xr$PId = F.Xe$File AND ' +
      						' D.Xi$Field = F.Xe$Id AND ' +
      						' A.Xr$Fid = G.Xi$File AND ' +
      						' A.Xr$FIndex = G.Xi$Number AND ' +
      						' D.Xi$Part = G.Xi$Part AND ' +
      						' G.Xi$File = H.Xe$File AND ' +
      						' G.Xi$Field = H.Xe$Id ' +
							' ORDER BY E.Xe$Name, A.Xr$Name; ' 
   
   exec (:stmt_psp_fkeys);
END; -- End of stored procedure.
