/*
 * Decompiled with CFR 0.152.
 */
package pervasive.database;

import pervasive.database.FieldDef;
import pervasive.database.IOBuffer;

class Term {
    public static final byte COMP_EQUAL = 1;
    public static final byte COMP_GREATER = 2;
    public static final byte COMP_LESS = 3;
    public static final byte COMP_NOTEQUAL = 4;
    public static final byte COMP_GREATEREQ = 5;
    public static final byte COMP_LESSEQ = 6;
    public static final byte COMP_ACS_BIAS = 32;
    public static final byte COMP_CASE_BIAS = -128;
    protected static final byte COMP_CONSTANT = 64;
    protected static final byte COMP_LOGIC_LAST = 0;
    protected static final byte COMP_LOGIC_AND = 1;
    protected static final byte COMP_LOGIC_OR = 2;
    private FieldDef m_field;
    private byte m_compCode;
    private byte m_logical;
    private short m_compOffset = (short)-1;
    private String m_compConstant;
    boolean m_logicalReady = false;
    boolean m_termReady = false;
    boolean m_isReady = false;

    Term() {
    }

    protected void deleteTerm() {
        this.m_termReady = false;
        this.m_logicalReady = false;
        this.m_isReady = false;
    }

    protected boolean isGoodTerm() {
        return this.m_isReady;
    }

    public void addTerm(FieldDef fieldDef, byte by, FieldDef fieldDef2) {
        this.m_field = fieldDef;
        this.m_compCode = by;
        this.m_compOffset = (short)fieldDef2.m_recordOffset;
        this.m_compConstant = null;
        this.setReadyFlags(true);
    }

    public void addTerm(FieldDef fieldDef, byte by, String string) {
        this.m_field = fieldDef;
        this.m_compCode = by;
        this.m_compOffset = (short)-1;
        this.m_compConstant = string;
        this.setReadyFlags(true);
    }

    public void makeAnd() {
        this.m_logical = 1;
        this.setReadyFlags(false);
    }

    public void makeOr() {
        this.m_logical = (byte)2;
        this.setReadyFlags(false);
    }

    public void makeLast() {
        this.m_logical = 0;
        this.setReadyFlags(false);
    }

    private void setReadyFlags(boolean bl) {
        if (bl) {
            this.m_termReady = true;
        } else {
            this.m_logicalReady = true;
        }
        if (this.m_termReady & this.m_logicalReady) {
            this.m_isReady = true;
        }
    }

    protected int getInfo(IOBuffer iOBuffer) {
        if (!this.m_isReady) {
            return -1;
        }
        int n = 7;
        if (iOBuffer.getSize() < n) {
            return -2;
        }
        iOBuffer.writeByte((byte)this.m_field.m_type, 0);
        iOBuffer.writeShort((short)this.m_field.m_length, 1);
        iOBuffer.writeShort((short)this.m_field.m_recordOffset, 3);
        iOBuffer.writeByte(this.m_compCode, 5);
        iOBuffer.writeByte(this.m_logical, 6);
        if (this.m_compOffset > -1) {
            n = 9;
            iOBuffer.writeShort(this.m_compOffset, 7);
            iOBuffer.writeByte((byte)(this.m_compCode + 64), 5);
        }
        return n;
    }

    protected String getConstant() {
        return this.m_compConstant;
    }

    public int getFieldType() {
        return this.m_field.m_type;
    }

    public int getFieldLength() {
        return this.m_field.m_length;
    }

    public FieldDef getFieldDef() {
        return this.m_field;
    }

    public int getFieldOffset() {
        return this.m_field.m_recordOffset;
    }
}

