/*
 * Decompiled with CFR 0.152.
 */
package pervasive.database;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import pervasive.database.BLOBInfo;
import pervasive.database.BLOBOutputStream;
import pervasive.database.Buffer;
import pervasive.database.BufferMetaData;
import pervasive.database.ColumnDef;
import pervasive.database.Consts;
import pervasive.database.DBURI;
import pervasive.database.DBUtil;
import pervasive.database.Database;
import pervasive.database.IBTRV;
import pervasive.database.IOBuffer;
import pervasive.database.Index;
import pervasive.database.IndexMetaData;
import pervasive.database.MessageCatalog;
import pervasive.database.PsqlEOFException;
import pervasive.database.PsqlException;
import pervasive.database.PsqlIOException;
import pervasive.database.PsqlInvalidObjectException;
import pervasive.database.PsqlOperationException;
import pervasive.database.Row;
import pervasive.database.RowSetMetaData;
import pervasive.database.Session;
import pervasive.database.Table;
import pervasive.database.XCursor;

public class RowSet
implements Consts {
    boolean m_exops = false;
    int m_curind = -1;
    int m_curaddr = -1;
    Table m_parent;
    private int m_current = 1;
    private int m_lockmode;
    private int m_lastStat;
    private int m_extdirection;
    private int m_nextExtBuffSize;
    private boolean m_objClosed = false;
    private String m_charsetName;
    private RowSetMetaData m_meta;
    private Index m_cindex;
    private Vector m_indbufs = new Vector();
    private XCursor m_cursor;
    private IBTRV m_btrv;

    RowSet(Table table, IBTRV iBTRV, String string, int n, int n2, boolean bl, String string2, BufferMetaData bufferMetaData) throws PsqlException {
        this.m_parent = table;
        this.m_btrv = iBTRV;
        this.m_lockmode = n2;
        this.m_charsetName = string2;
        this.m_cursor = table.getDatabase().createXCursor(1, 255);
        DBURI dBURI = DBURI.createTableURI(this.m_parent.m_parent.getDatabaseURI().getHost(), this.m_parent.m_parent.getDatabaseURI().getDBName(), this.m_parent.m_tname);
        DBUtil.openDBResource(this.m_cursor, dBURI, string, (byte)(n + n2));
        this.m_meta = new RowSetMetaData(this, bl, this.m_cursor);
        if (bufferMetaData != null) {
            IOBuffer iOBuffer = this.m_btrv.createIOBuffer(bufferMetaData.m_highoffs, this.m_charsetName);
            this.m_cindex = new Index(bufferMetaData, iOBuffer, this.m_charsetName);
            this.m_indbufs.addElement(this.m_cindex);
            this.m_cursor.setKeySize(bufferMetaData.m_highoffs);
        } else {
            this.m_cursor.setKeySize(1024);
            this.m_meta.setAccessPath(999);
        }
        this.m_cursor.setDataSize(this.m_meta.m_highoffs);
    }

    public Table getTable() {
        return this.m_parent;
    }

    public Database getDatabase() {
        return this.getTable().getDatabase();
    }

    public Session getSession() {
        return this.getDatabase().getSession();
    }

    public RowSetMetaData getRowSetMetaData() {
        if (this.m_objClosed) {
            throw new PsqlInvalidObjectException(MessageCatalog.getObjectClosedMsg(this));
        }
        return this.m_meta;
    }

    public int getAddress() {
        if (this.m_objClosed) {
            throw new PsqlInvalidObjectException(MessageCatalog.getObjectClosedMsg(this));
        }
        return this.m_curaddr;
    }

    public Row getByAddress(int n) throws PsqlException {
        return this.getByAddress(n, 0);
    }

    public Row getByAddress(int n, int n2) throws PsqlException {
        this.m_cursor.setDInt4(0, n);
        return this.fetchRows(23, 36, n2, -1, 1, 1, true);
    }

    public int getPercent() {
        return 0;
    }

    public Row getByPercent(int n) {
        return this.getByPercent(0);
    }

    public Row getByPercent(int n, int n2) {
        return null;
    }

    public Row getCurrent() throws PsqlException {
        return this.getCurrent(0);
    }

    public Row getCurrent(int n) throws PsqlException {
        return this.getByAddress(this.m_curaddr, n);
    }

    public Row getNext() throws PsqlException {
        return this.getNext(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Row getNext(int n) throws PsqlException {
        int n2;
        if (this.m_objClosed) {
            throw new PsqlInvalidObjectException(MessageCatalog.getObjectClosedMsg(this));
        }
        int n3 = 0;
        int n4 = 0;
        if (!this.m_exops) {
            this.m_exops = this.isExopsNeeded();
        }
        if (this.m_current == 1 || this.m_current == 2) {
            if (this.m_meta.m_access == 999) {
                if (this.m_current == 1 && this.m_meta.m_direction == 1) {
                    n3 = 33;
                    n4 = 38;
                    return this.fetchRows(n3, n4, n, -1, this.m_meta.getCountForRetrieval(), 0, true);
                } else if (this.m_current == 2 && this.m_meta.m_direction == -1) {
                    n3 = 34;
                    n4 = 39;
                    return this.fetchRows(n3, n4, n, -1, this.m_meta.getCountForRetrieval(), 0, true);
                } else {
                    this.throwEOF();
                }
                return this.fetchRows(n3, n4, n, -1, this.m_meta.getCountForRetrieval(), 0, true);
            } else if (this.m_current == 1 && this.m_meta.m_direction == 1) {
                n3 = 12;
                n4 = 36;
                return this.fetchRows(n3, n4, n, -1, this.m_meta.getCountForRetrieval(), 0, true);
            } else if (this.m_current == 2 && this.m_meta.m_direction == -1) {
                n3 = 13;
                n4 = 37;
                return this.fetchRows(n3, n4, n, -1, this.m_meta.getCountForRetrieval(), 0, true);
            } else {
                this.throwEOF();
            }
            return this.fetchRows(n3, n4, n, -1, this.m_meta.getCountForRetrieval(), 0, true);
        }
        if (this.m_meta.m_access == 999) {
            if (this.m_meta.m_direction == 1) {
                n3 = 24;
                n4 = 38;
            } else {
                n3 = 35;
                n4 = 39;
            }
        } else if (this.m_meta.m_direction == 1) {
            n3 = 6;
            n4 = 36;
        } else {
            n3 = 7;
            n4 = 37;
        }
        if (this.m_exops) {
            if (this.m_curind == -1) return this.fetchRows(-1, n4, n, -1, this.m_meta.getCountForRetrieval(), 0, false);
            n2 = this.m_curind + this.m_meta.m_direction * this.m_extdirection;
            if (n2 == -1 || n2 == this.m_cursor.getRecordCount()) {
                return this.fetchRows(-1, n4, n, this.m_curaddr, this.m_meta.getCountForRetrieval(), 0, false);
            }
            if (n != 0) {
                return this.fetchRows(23, n4, n, this.m_cursor.getAddress(n2), this.m_meta.getCountForRetrieval(), 0, true);
            }
            this.m_curind = n2;
        } else {
            n3 = n != 0 ? (n3 += n) : (n3 += this.m_meta.m_lockmode);
            this.m_cursor.setDataSize(this.m_meta.m_highoffs);
            if (this.makeBTRVCall(n3) == 9) {
                this.throwEOF();
            }
            if (this.m_lastStat > 0 && this.m_lastStat != 22) {
                throw new PsqlOperationException(n3, this.m_lastStat);
            }
            this.m_curind = 0;
        }
        this.m_current = 3;
        n2 = 0;
        if (!this.m_exops || this.m_exops && this.m_cursor.getRecordCount() == 1) {
            n2 = this.m_cursor.getUsageCount();
        }
        this.m_curaddr = this.m_cursor.getAddress(this.m_curind);
        IOBuffer iOBuffer = this.m_btrv.createIOBuffer(this.m_meta.m_highoffs, this.m_charsetName);
        this.m_cursor.getRecordImage(iOBuffer.getBufferData(), this.m_curind);
        return new Row(this, this.m_meta, iOBuffer, this.m_curaddr, this.m_meta.fullrow, (short)n2, this.m_charsetName);
    }

    void changeAccessPath(int n) throws PsqlIOException {
        if (n < this.m_parent.m_indexes.size() && this.m_parent.m_indexes.elementAt(n) != null) {
            this.m_cursor.setKeyNumber(n);
            this.m_cindex = this.createIndex(n);
            this.m_cursor.setKeySize(this.m_cindex.m_buf.getSize());
            if (this.m_current == 3) {
                this.m_cursor.setDInt4(0, this.m_cursor.getAddress(this.m_curind));
                this.m_cursor.setDataSize(this.m_meta.m_highoffs);
                this.makeBTRVCall(23);
                this.m_curind = -1;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public Index createIndex(String string) {
        return this.createIndex(this.m_parent.m_meta.findIndex(string));
    }

    public Index createIndex(int n) {
        if (this.m_objClosed) {
            throw new PsqlInvalidObjectException(MessageCatalog.getObjectClosedMsg(this));
        }
        for (int i = this.m_indbufs.size(); i <= n; ++i) {
            this.m_indbufs.addElement(null);
        }
        if (this.m_indbufs.elementAt(n) == null) {
            IndexMetaData indexMetaData = (IndexMetaData)this.m_parent.m_indexes.elementAt(n);
            IOBuffer iOBuffer = this.m_btrv.createIOBuffer(indexMetaData.m_highoffs, this.m_charsetName);
            Index index = new Index(indexMetaData, iOBuffer, this.m_charsetName);
            this.m_indbufs.setElementAt(index, n);
            return index;
        }
        Index index = (Index)this.m_indbufs.elementAt(n);
        IndexMetaData indexMetaData = this.m_parent.getTableMetaData().getIndexDef(n);
        this.setColumnsToNull(index, indexMetaData);
        return index;
    }

    public Row getByIndex(int n, Index index) throws PsqlException {
        return this.getByIndex(n, index, 0);
    }

    public Row getByIndex(int n, Index index, int n2) throws PsqlException {
        if (this.m_objClosed) {
            throw new PsqlInvalidObjectException(MessageCatalog.getObjectClosedMsg(this));
        }
        int n3 = 0;
        int n4 = 36;
        switch (n) {
            case 1: {
                n3 = 5;
                break;
            }
            case 2: {
                n3 = 8;
                break;
            }
            case 5: {
                n3 = 9;
                break;
            }
            case 3: {
                n3 = 10;
                n4 = 37;
                break;
            }
            case 6: {
                n3 = 11;
                n4 = 37;
                break;
            }
        }
        this.m_cursor.setKeySize(index.m_buf.getSize());
        this.m_cursor.setKBytes(0, index.m_buf.getSize(), index.m_buf.getBufferData());
        return this.fetchRows(n3, n4, n2, -1, 1, 0, true);
    }

    Row fetchRows(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) throws PsqlException {
        if (n4 != -1) {
            this.m_cursor.setDInt4(0, n4);
            this.m_cursor.setDataSize(4);
            this.makeBTRVCall(23);
            if (this.m_lastStat != 0 && this.m_lastStat != 22) {
                throw new PsqlOperationException(23, this.m_lastStat);
            }
        }
        if (n3 != 0) {
            n5 = 1;
        }
        boolean bl2 = n5 > 1 || this.m_cursor.m_terms != null && this.m_cursor.m_terms.length > 0 || !this.m_meta.fullrow;
        if (n != -1) {
            if (!bl2) {
                n = n3 == 0 ? (n += this.m_meta.m_lockmode) : (n += n3);
            }
            this.m_cursor.setDataSize(this.m_meta.m_highoffs);
            this.makeBTRVCall(n);
            this.m_curind = -1;
            this.m_current = 3;
            if (this.m_lastStat > 0 && this.m_lastStat != 22) {
                if (this.m_lastStat == 9) {
                    throw new PsqlEOFException();
                }
                throw new PsqlOperationException(n, this.m_lastStat);
            }
        }
        if (n2 != -1) {
            n2 = n3 == 0 ? (n2 += this.m_meta.m_lockmode) : (n2 += n3);
            this.m_cursor.setRejectCount(n6);
            this.m_cursor.setIncludeCurrent(bl);
            this.setNumberOfRows(n5);
            this.m_cursor.setCacheSize(this.m_nextExtBuffSize);
            do {
                this.m_lastStat = this.makeBTRVCall(n2);
                this.m_cursor.setIncludeCurrent(false);
            } while (this.m_cursor.getRecordCount() == 0 && this.m_lastStat == 60 && n6 == 0);
            if (this.m_cursor.getRecordCount() == 0) {
                this.m_curind = -1;
                if (this.m_lastStat == 9 || this.m_lastStat == 64) {
                    this.throwEOF();
                } else {
                    throw new PsqlOperationException(n2, this.m_lastStat);
                }
            }
            this.m_curind = 0;
            this.m_extdirection = this.m_meta.m_direction;
        }
        this.m_curaddr = this.m_cursor.getAddress(0);
        IOBuffer iOBuffer = this.m_btrv.createIOBuffer(this.m_meta.m_highoffs, this.m_charsetName);
        byte[] byArray = iOBuffer.getBufferData();
        this.m_cursor.getRecordImage(iOBuffer.getBufferData(), this.m_curind);
        return new Row(this, this.m_meta, iOBuffer, this.m_curaddr, this.m_meta.fullrow, this.m_cursor.getUsageCount(), this.m_charsetName);
    }

    public Row createRow() {
        if (this.m_objClosed) {
            throw new PsqlInvalidObjectException(MessageCatalog.getObjectClosedMsg(this));
        }
        IOBuffer iOBuffer = this.m_btrv.createIOBuffer(this.m_meta.m_highoffs, this.m_charsetName);
        Row row = new Row(this, this.m_meta, iOBuffer, 0, this.m_meta.fullrow, 0, this.m_charsetName);
        this.setColumnsToNull(row, this.m_meta);
        return row;
    }

    public void insertRow(Row row) throws PsqlException {
        this.insertRow(row, false);
    }

    public void insertRow(Row row, boolean bl) throws PsqlException {
        if (this.m_objClosed) {
            throw new PsqlInvalidObjectException(MessageCatalog.getObjectClosedMsg(this));
        }
        if (!row.m_fullRow) {
            throw new PsqlInvalidObjectException(MessageCatalog.getMissingFieldsMsg(row));
        }
        if (bl || this.m_meta.m_access == 999) {
            this.m_cursor.setKeyNumber(-1);
            this.m_cursor.setKeySize(0);
        } else {
            this.m_cursor.setKeyNumber(this.m_meta.m_access);
            this.m_cursor.setKeySize(this.m_cindex.m_buf.getSize());
        }
        int n = this.getActualDataSize(row);
        this.m_cursor.setDataSize(n);
        this.m_cursor.setDBytes(0, n, row.m_buf.getBufferData());
        this.makeBTRVCall(2);
        if (this.m_meta.getBLOBColumns() != null && (this.m_lastStat == 0 || this.m_lastStat == 22)) {
            this.writeBLOBs(row);
        }
        if (bl || this.m_meta.m_access == 999) {
            this.m_cursor.setKeyNumber(this.m_meta.m_access);
            if (this.m_cindex != null) {
                this.m_cursor.setKeySize(this.m_cindex.m_buf.getSize());
            }
        }
        if (this.m_lastStat != 0 && this.m_lastStat != 22) {
            row.m_position = 0;
            throw new PsqlOperationException(2, this.m_lastStat);
        }
        row.m_position = this.m_cursor.getAddress(0);
        if (!bl) {
            this.m_current = 3;
            this.m_curaddr = row.m_position;
        }
        this.m_curind = -1;
        this.m_cursor.getDBytes(row.m_buf.getBufferData(), 0, row.m_buf.getSize());
    }

    public void deleteRow(Row row) throws PsqlException {
        if (this.m_objClosed) {
            throw new PsqlInvalidObjectException(MessageCatalog.getObjectClosedMsg(this));
        }
        if (row.m_position == 0) {
            throw new PsqlInvalidObjectException(MessageCatalog.getInvalidPositionMsg(row, row.m_position));
        }
        if (this.m_exops || this.m_curaddr != row.m_position) {
            this.m_cursor.setDInt4(0, row.m_position);
            this.m_cursor.setDataSize(this.m_meta.m_highoffs);
            this.makeBTRVCall(23);
            if (this.m_lastStat != 0 && this.m_lastStat != 22) {
                throw new PsqlOperationException(23, this.m_lastStat);
            }
        }
        this.m_curind = -1;
        this.makeBTRVCall(4);
        if (this.m_lastStat != 0) {
            throw new PsqlOperationException(4, this.m_lastStat);
        }
        row.m_position = 0;
        this.m_curaddr = -1;
    }

    public void updateRow(Row row) throws PsqlException {
        this.updateRow(row, false);
    }

    public void updateRow(Row row, boolean bl) throws PsqlException {
        if (this.m_objClosed) {
            throw new PsqlInvalidObjectException(MessageCatalog.getObjectClosedMsg(this));
        }
        if (row.m_position == 0) {
            throw new PsqlInvalidObjectException(MessageCatalog.getInvalidPositionMsg(row, row.m_position));
        }
        if (!row.m_fullRow) {
            throw new PsqlInvalidObjectException(MessageCatalog.getMissingFieldsMsg(row));
        }
        if (this.m_exops || this.m_cursor.getAddress(0) != row.m_position) {
            this.m_cursor.setDInt4(0, row.m_position);
            this.m_cursor.setDataSize(this.m_meta.m_highoffs);
            this.makeBTRVCall(23);
            if (this.m_lastStat != 0 && this.m_lastStat != 22) {
                throw new PsqlOperationException(23, this.m_lastStat);
            }
            if (row.m_usage == 0 || this.m_cursor.getUsageCount() != row.m_usage) {
                throw new PsqlOperationException(3, 80);
            }
        }
        if (bl || this.m_meta.m_access == 999) {
            this.m_cursor.setKeySize(0);
            this.m_cursor.setKeyNumber(-1);
        } else {
            this.m_cursor.setKeyNumber(this.m_meta.m_access);
        }
        int n = this.getActualDataSize(row);
        this.m_cursor.setDataSize(n);
        this.m_cursor.setDBytes(0, n, row.m_buf.getBufferData());
        if (this.m_meta.getBLOBColumns() != null && (this.m_lastStat == 0 || this.m_lastStat == 22)) {
            this.m_lastStat = this.m_cursor.updateChunk(0, n, row.m_buf.getBufferData());
            if (this.m_lastStat == 0 || this.m_lastStat == 22) {
                this.writeBLOBs(row);
            }
        } else {
            this.makeBTRVCall(3);
        }
        if (bl || this.m_meta.m_access == 999) {
            this.m_cursor.setKeyNumber(this.m_meta.m_access);
            if (this.m_cindex != null) {
                this.m_cursor.setKeySize(this.m_cindex.m_buf.getSize());
            }
        }
        if (this.m_lastStat != 0) {
            throw new PsqlOperationException(3, this.m_lastStat);
        }
        if (!bl) {
            this.m_current = 3;
        }
        this.m_curind = -1;
        this.m_cursor.getDBytes(row.m_buf.getBufferData(), 0, row.m_buf.getSize());
    }

    void unlock(int n) throws PsqlException {
        int n2 = this.makeBTRVCall(27, n);
        if (this.m_curaddr != -1) {
            this.m_cursor.setDInt4(0, this.m_curaddr);
            this.m_cursor.setDataSize(4);
            this.makeBTRVCall(23);
        }
        this.m_curind = -1;
        if (n2 != 0) {
            throw new PsqlOperationException(27, n2);
        }
    }

    public void unlockRow(Row row) throws PsqlException {
        if (this.m_objClosed) {
            throw new PsqlInvalidObjectException(MessageCatalog.getObjectClosedMsg(this));
        }
        if (row.m_position == 0) {
            throw new PsqlInvalidObjectException(MessageCatalog.getInvalidPositionMsg(row, row.m_position));
        }
        this.m_cursor.setDInt4(0, row.m_position);
        this.m_cursor.setDataSize(4);
        this.unlock(-1);
    }

    public void unlockAll() throws PsqlException {
        if (this.m_objClosed) {
            throw new PsqlInvalidObjectException(MessageCatalog.getObjectClosedMsg(this));
        }
        this.unlock(-2);
    }

    public void close() {
        this.m_cursor.close();
        this.m_parent.childClosed(this);
        this.m_objClosed = true;
    }

    public void reset() {
        if (this.m_objClosed) {
            throw new PsqlInvalidObjectException(MessageCatalog.getObjectClosedMsg(this));
        }
        this.m_current = this.m_meta.m_direction == 1 ? 1 : 2;
        this.m_curind = -1;
        this.m_curaddr = -1;
    }

    public void reinit() {
        if (this.m_objClosed) {
            throw new PsqlInvalidObjectException(MessageCatalog.getObjectClosedMsg(this));
        }
        this.m_meta.m_direction = 1;
        this.reset();
        this.m_exops = false;
        this.m_cursor.dropAll();
        this.m_meta.addAllColumns();
        try {
            this.m_meta.setAccessPath(0);
        }
        catch (PsqlException psqlException) {
            // empty catch block
        }
        this.m_cursor.setDataSize(this.m_meta.m_highoffs);
    }

    private int makeBTRVCall(int n) throws PsqlIOException {
        this.m_lastStat = this.m_cursor.BTRV(n);
        return this.m_lastStat;
    }

    private int makeBTRVCall(int n, int n2) throws PsqlIOException {
        this.m_lastStat = this.m_cursor.BTRV(n, n2);
        return this.m_lastStat;
    }

    void throwEOF() throws PsqlException {
        throw new PsqlEOFException();
    }

    boolean isExopsNeeded() {
        if (this.m_meta.getCountForRetrieval() > 1) {
            return true;
        }
        if (this.m_cursor.m_terms != null && this.m_cursor.m_terms.length > 0) {
            return true;
        }
        return !this.m_meta.fullrow;
    }

    void setNumberOfRows(int n) {
        int n2 = this.calculateBufferSize(n);
        this.m_nextExtBuffSize = n2 >= 0 ? n2 : this.m_meta.m_highoffs;
    }

    private int calculateBufferSize(int n) {
        long l = 2 + (this.m_cursor.getExtRecordSize() + 6) * n;
        return l > 64129L ? -1 : (int)l;
    }

    XCursor getCursor() {
        return this.m_cursor;
    }

    private int getActualDataSize(Row row) {
        int n = row.m_buf.getSize();
        if ((this.m_parent.getTableMetaData().getDataFileFlag() & 1) == 0) {
            return n;
        }
        ColumnDef columnDef = this.m_meta.getColumnDef(this.m_meta.getColumnCount() - 1);
        if (columnDef.getType() == 13) {
            int n2 = row.m_buf.readUnsignedShort(columnDef.m_rowsetOffset);
            n = n2 == 0 ? columnDef.m_rowsetOffset : n2 + 4 + columnDef.m_rowsetOffset;
        } else if (columnDef.getType() == 12) {
            int n3 = row.m_buf.findNullByte(columnDef.m_rowsetOffset) - columnDef.m_rowsetOffset;
            n = n3 == 0 ? columnDef.m_rowsetOffset : n3 + 1 + columnDef.m_rowsetOffset;
        }
        return n;
    }

    private int writeBLOB(Row row, int n, int n2) throws PsqlException {
        Object object;
        int n3 = n2;
        int n4 = 0;
        Object object2 = row.getBLOBInfo(n).getData();
        if (row.getBLOBInfo(n).isSerializable()) {
            object = new BLOBOutputStream(n2, this.m_cursor);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)object, 1024);
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
                objectOutputStream.writeObject(object2);
                objectOutputStream.close();
            }
            catch (IOException iOException) {
                throw new PsqlIOException(iOException);
            }
            n4 = ((BLOBOutputStream)object).getBytesWritten();
        } else {
            object = (InputStream)object2;
            byte[] byArray = new byte[1024];
            int n5 = 0;
            int n6 = 0;
            try {
                int n7 = ((InputStream)object).available() / 1024;
                int n8 = ((InputStream)object).available() % 1024;
                for (int i = n7; i > 0; --i) {
                    n5 = ((InputStream)object).read(byArray);
                    n4 += n5;
                    n6 = this.m_cursor.updateChunk(n2, n5, byArray);
                    n2 += 1024;
                }
                if (n8 != 0) {
                    n5 = ((InputStream)object).read(byArray, 0, n8);
                    n4 += n5;
                    n6 = this.m_cursor.updateChunk(n2, n5, byArray);
                }
            }
            catch (IOException iOException) {
                throw new PsqlIOException(iOException);
            }
        }
        object = row.getBLOBInfo(n);
        ((BLOBInfo)object).setNewData(false);
        ((BLOBInfo)object).setOffset(n3);
        ((BLOBInfo)object).setLength(n4);
        return n3 + n4;
    }

    private int moveBLOB(Row row, BLOBInfo bLOBInfo, int n) throws PsqlException {
        int n2 = bLOBInfo.getLength();
        int n3 = n;
        int n4 = bLOBInfo.getOffset();
        byte[] byArray = new byte[1024];
        int n5 = 0;
        int n6 = n2 / 1024;
        int n7 = n2 % 1024;
        for (int i = n6; i > 0; --i) {
            byArray = this.m_cursor.getChunk(row.getRowPosition(), n4);
            this.m_cursor.updateChunk(n, byArray.length, byArray);
            n4 += byArray.length;
            n += byArray.length;
            n5 += byArray.length;
        }
        if (n7 > 0) {
            byArray = this.m_cursor.getChunk(row.getRowPosition(), n4, n7);
            this.m_cursor.updateChunk(n, n7, byArray);
            n5 += n7;
        }
        bLOBInfo.setOffset(n3);
        return n3 + n5;
    }

    private int[] getWriteOrder(Row row) {
        Hashtable hashtable = row.getBLOBTable();
        int n = 0;
        int[] nArray = this.m_meta.getBLOBColumns();
        for (int i = nArray.length - 1; i >= 0; --i) {
            for (int j = 0; j < i; ++j) {
                BLOBInfo bLOBInfo = (BLOBInfo)hashtable.get(new Integer(nArray[j]));
                BLOBInfo bLOBInfo2 = (BLOBInfo)hashtable.get(new Integer(nArray[j + 1]));
                if ((!bLOBInfo.isNewData() || bLOBInfo2.isNewData()) && (bLOBInfo.getOffset() <= bLOBInfo2.getOffset() || bLOBInfo2.isNewData())) continue;
                n = nArray[j];
                nArray[j] = nArray[j + 1];
                nArray[j + 1] = n;
            }
        }
        return nArray;
    }

    private void updateBLOBHeader(Row row, int n) throws PsqlException {
        ColumnDef columnDef = this.m_meta.getColumnDef(n);
        int n2 = columnDef.getOffset();
        BLOBInfo bLOBInfo = row.getBLOBInfo(n);
        int n3 = bLOBInfo.getOffset();
        int n4 = bLOBInfo.getLength();
        row.setBLOBOffsetAndLength(n, n3, n4);
        IOBuffer iOBuffer = this.m_btrv.createIOBuffer(8, "US-ASCII");
        iOBuffer.writeLong(row.getBLOBOffsetAndLength(n), 0);
        this.m_cursor.updateChunk(n2, 8, iOBuffer.getBufferData());
    }

    private void writeBLOBs(Row row) throws PsqlException {
        int[] nArray = this.getWriteOrder(row);
        BLOBInfo bLOBInfo = null;
        int n = this.m_parent.getTableMetaData().getBaseRowLength();
        boolean bl = false;
        int n2 = n;
        for (int i = 0; i < nArray.length; ++i) {
            bLOBInfo = row.getBLOBInfo(nArray[i]);
            if (row.isNull(nArray[i])) continue;
            if (bLOBInfo.isNewData()) {
                n2 = this.writeBLOB(row, nArray[i], n2);
                this.updateBLOBHeader(row, nArray[i]);
                continue;
            }
            if (bLOBInfo.getOffset() != n2) {
                n2 = this.moveBLOB(row, bLOBInfo, n2);
                this.updateBLOBHeader(row, nArray[i]);
                continue;
            }
            n2 = bLOBInfo.getOffset() + bLOBInfo.getLength();
        }
    }

    void setColumnsToNull(Buffer buffer, BufferMetaData bufferMetaData) {
        int n = bufferMetaData.getColumnCount();
        for (int i = 0; i < n; ++i) {
            ColumnDef columnDef = bufferMetaData.getColumnDef(i);
            if (!columnDef.isNullable()) continue;
            buffer.setNull(i);
        }
    }
}

