/*
 * Decompiled with CFR 0.152.
 */
package pervasive.database;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import pervasive.database.BLOBInfo;
import pervasive.database.BLOBInputStream;
import pervasive.database.Buffer;
import pervasive.database.BufferMetaData;
import pervasive.database.ColumnDef;
import pervasive.database.DBObjectInputStream;
import pervasive.database.DBObjectOutputStream;
import pervasive.database.IOBuffer;
import pervasive.database.MessageCatalog;
import pervasive.database.PsqlClassNotFoundException;
import pervasive.database.PsqlConversionNotSupportedException;
import pervasive.database.PsqlIOException;
import pervasive.database.RowSet;
import pervasive.database.SCursor;
import pervasive.database.XCursor;

public class Row
extends Buffer {
    int m_position = 0;
    boolean m_fullRow = true;
    short m_usage = 0;
    private RowSet m_rowset;
    private SCursor m_scursor;
    private Hashtable m_BLOBTable;
    private BufferMetaData m_bufferMD;
    private boolean m_BLOBData;

    Row(RowSet rowSet, BufferMetaData bufferMetaData, IOBuffer iOBuffer, int n, boolean bl, short s, String string) {
        super(bufferMetaData, iOBuffer, string);
        this.m_rowset = rowSet;
        this.m_position = n;
        this.m_fullRow = bl;
        this.m_usage = s;
        this.m_bufferMD = bufferMetaData;
        int n2 = -1;
        int n3 = -1;
        long l = -1L;
        int[] nArray = bufferMetaData.getBLOBColumns();
        if (nArray != null) {
            this.m_BLOBTable = new Hashtable(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                l = this.isNull(nArray[i]) ? 0L : this.getLong(nArray[i]);
                if (l == 0L) {
                    this.m_BLOBTable.put(new Integer(nArray[i]), new BLOBInfo());
                    continue;
                }
                n2 = (int)(l >>> 32);
                n3 = (int)(l << 32 >>> 32);
                this.m_BLOBTable.put(new Integer(nArray[i]), new BLOBInfo(n2, n3));
            }
        }
    }

    public void setObject(String string, Serializable serializable) throws PsqlIOException {
        this.setObject(this.m_bufferMD.findColumn(string), serializable);
    }

    public void setObject(int n, Serializable serializable) throws PsqlIOException {
        ColumnDef columnDef = this.m_bufferMD.getColumnDef(n);
        switch (columnDef.m_type) {
            case 13: {
                DBObjectOutputStream dBObjectOutputStream = new DBObjectOutputStream(this, n);
                try {
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(dBObjectOutputStream);
                    objectOutputStream.writeObject(serializable);
                    objectOutputStream.close();
                    break;
                }
                catch (IOException iOException) {
                    throw new PsqlIOException(iOException);
                }
            }
            case 21: {
                this.m_BLOBTable.put(new Integer(n), new BLOBInfo(serializable, true));
                long l = 0L;
                this.setBLOBOffsetAndLength(n, 0L, 0L);
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg2(this, "setObject", columnDef.m_type));
            }
        }
    }

    public Serializable getObject(String string) throws PsqlIOException, PsqlClassNotFoundException {
        return this.getObject(this.m_bufferMD.findColumn(string));
    }

    public Serializable getObject(int n) throws PsqlIOException, PsqlClassNotFoundException {
        ColumnDef columnDef = this.m_bufferMD.getColumnDef(n);
        Serializable serializable = null;
        switch (columnDef.m_type) {
            case 13: {
                DBObjectInputStream dBObjectInputStream = new DBObjectInputStream(this, n);
                try {
                    ObjectInputStream objectInputStream = new ObjectInputStream(dBObjectInputStream);
                    serializable = (Serializable)objectInputStream.readObject();
                    objectInputStream.close();
                    break;
                }
                catch (IOException iOException) {
                    throw new PsqlIOException(iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new PsqlClassNotFoundException(classNotFoundException.getLocalizedMessage());
                }
            }
            case 21: {
                XCursor xCursor = this.m_rowset.getCursor();
                int n2 = this.getBLOBOffsetFromHeader(n);
                int n3 = ((BLOBInfo)this.m_BLOBTable.get(new Integer(n))).getLength();
                BLOBInputStream bLOBInputStream = new BLOBInputStream(this.m_position, n2, xCursor, n3);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(bLOBInputStream, 1024);
                try {
                    ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);
                    serializable = (Serializable)objectInputStream.readObject();
                    objectInputStream.close();
                    break;
                }
                catch (IOException iOException) {
                    throw new PsqlIOException(iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new PsqlClassNotFoundException(classNotFoundException.getLocalizedMessage());
                }
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg2(this, "getObject", columnDef.m_type));
            }
        }
        return serializable;
    }

    public void setBinaryStream(String string, InputStream inputStream) {
        this.setBinaryStream(this.m_bufferMD.findColumn(string), inputStream);
    }

    public void setBinaryStream(int n, InputStream inputStream) {
        ColumnDef columnDef = this.m_bufferMD.getColumnDef(n);
        if (columnDef.m_type != 21) {
            throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg2(this, "setBinaryStream", columnDef.m_type));
        }
        this.m_BLOBTable.put(new Integer(n), new BLOBInfo(inputStream, false));
        this.setBLOBOffsetAndLength(n, 0L, 0L);
    }

    public InputStream getBinaryStream(String string) {
        return this.getBinaryStream(this.m_bufferMD.findColumn(string));
    }

    public InputStream getBinaryStream(int n) {
        ColumnDef columnDef = this.m_bufferMD.getColumnDef(n);
        if (columnDef.m_type != 21) {
            throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg2(this, "getBinaryStream", columnDef.m_type));
        }
        BLOBInfo bLOBInfo = (BLOBInfo)this.m_BLOBTable.get(new Integer(n));
        int n2 = bLOBInfo.getOffset();
        XCursor xCursor = this.m_rowset.getCursor();
        int n3 = ((BLOBInfo)this.m_BLOBTable.get(new Integer(n))).getLength();
        return new BLOBInputStream(this.m_position, n2, xCursor, n3);
    }

    public int getRowPosition() {
        return this.m_position;
    }

    BLOBInfo getBLOBInfo(int n) {
        return (BLOBInfo)this.m_BLOBTable.get(new Integer(n));
    }

    Hashtable getBLOBTable() {
        return this.m_BLOBTable;
    }

    long getBLOBOffsetAndLength(int n) {
        BLOBInfo bLOBInfo = (BLOBInfo)this.m_BLOBTable.get(new Integer(n));
        return (long)bLOBInfo.getOffset() << 32 | (long)bLOBInfo.getLength() & 0xFFFFFFFFL;
    }

    void setBLOBOffsetAndLength(int n, long l, long l2) {
        long l3 = l << 32;
        long l4 = l2 << 32 >>> 32;
        long l5 = l3 | l4;
        this.setLong(n, l5);
    }

    int getBLOBOffsetFromHeader(int n) {
        long l = this.getLong(n);
        return (int)(l >>> 32);
    }

    int getBLOBLengthFromHeader(int n) {
        long l = this.getLong(n);
        return (int)(l << 32 >>> 32);
    }
}

