/*
 * Decompiled with CFR 0.152.
 */
package pervasive.database;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.Date;
import pervasive.database.BufferMetaData;
import pervasive.database.CharsetUtils;
import pervasive.database.ColumnDef;
import pervasive.database.Consts;
import pervasive.database.IOBuffer;
import pervasive.database.MessageCatalog;
import pervasive.database.PsqlColumnNotNullableException;
import pervasive.database.PsqlConversionNotSupportedException;
import pervasive.database.PsqlNullValueException;
import pervasive.database.Timestamp;

public class Buffer
implements Consts {
    BufferMetaData m_parent = null;
    IOBuffer m_buf;
    String m_charsetName;
    private boolean m_setToNull = false;

    Buffer(BufferMetaData bufferMetaData, IOBuffer iOBuffer, String string) {
        this.m_parent = bufferMetaData;
        this.m_buf = iOBuffer;
        this.m_charsetName = string;
    }

    public String getString(int n) {
        return this.getString(this.m_parent.getColumnDef(n));
    }

    public String getString(String string) {
        return this.getString(this.m_parent.getColumnDef(string));
    }

    public void setString(int n, String string) {
        this.setString(string, this.m_parent.getColumnDef(n));
    }

    public void setString(String string, String string2) {
        this.setString(string2, this.m_parent.getColumnDef(string));
    }

    public byte getByte(int n) {
        return this.getByte(this.m_parent.getColumnDef(n));
    }

    public byte getByte(String string) {
        return this.getByte(this.m_parent.getColumnDef(string));
    }

    public void setByte(int n, byte by) {
        this.setByte(by, this.m_parent.getColumnDef(n));
    }

    public void setByte(String string, byte by) {
        this.setByte(by, this.m_parent.getColumnDef(string));
    }

    public short getShort(int n) {
        return this.getShort(this.m_parent.getColumnDef(n));
    }

    public short getShort(String string) {
        return this.getShort(this.m_parent.getColumnDef(string));
    }

    public void setShort(int n, short s) {
        this.setShort(s, this.m_parent.getColumnDef(n));
    }

    public void setShort(String string, short s) {
        this.setShort(s, this.m_parent.getColumnDef(string));
    }

    public int getInt(int n) {
        return this.getInt(this.m_parent.getColumnDef(n));
    }

    public int getInt(String string) {
        return this.getInt(this.m_parent.getColumnDef(string));
    }

    public void setInt(int n, int n2) {
        this.setInt(n2, this.m_parent.getColumnDef(n));
    }

    public void setInt(String string, int n) {
        this.setInt(n, this.m_parent.getColumnDef(string));
    }

    public long getLong(int n) {
        return this.getLong(this.m_parent.getColumnDef(n));
    }

    public long getLong(String string) {
        return this.getLong(this.m_parent.getColumnDef(string));
    }

    public void setLong(int n, long l) {
        this.setLong(l, this.m_parent.getColumnDef(n));
    }

    public void setLong(String string, long l) {
        this.setLong(l, this.m_parent.getColumnDef(string));
    }

    public BigInteger getBigInteger(int n) {
        return this.getBigInteger(this.m_parent.getColumnDef(n));
    }

    public BigInteger getBigInteger(String string) {
        return this.getBigInteger(this.m_parent.getColumnDef(string));
    }

    public void setBigInteger(int n, BigInteger bigInteger) {
        this.setBigInteger(bigInteger, this.m_parent.getColumnDef(n));
    }

    public void setBigInteger(String string, BigInteger bigInteger) {
        this.setBigInteger(bigInteger, this.m_parent.getColumnDef(string));
    }

    public float getFloat(int n) {
        return this.getFloat(this.m_parent.getColumnDef(n));
    }

    public float getFloat(String string) {
        return this.getFloat(this.m_parent.getColumnDef(string));
    }

    public void setFloat(int n, float f) {
        this.setFloat(f, this.m_parent.getColumnDef(n));
    }

    public void setFloat(String string, float f) {
        this.setFloat(f, this.m_parent.getColumnDef(string));
    }

    public double getDouble(int n) {
        return this.getDouble(this.m_parent.getColumnDef(n));
    }

    public double getDouble(String string) {
        return this.getDouble(this.m_parent.getColumnDef(string));
    }

    public void setDouble(int n, double d) {
        this.setDouble(d, this.m_parent.getColumnDef(n));
    }

    public void setDouble(String string, double d) {
        this.setDouble(d, this.m_parent.getColumnDef(string));
    }

    public BigDecimal getBigDecimal(int n) {
        return this.getBigDecimal(this.m_parent.getColumnDef(n));
    }

    public BigDecimal getBigDecimal(String string) {
        return this.getBigDecimal(this.m_parent.getColumnDef(string));
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) {
        this.setBigDecimal(bigDecimal, this.m_parent.getColumnDef(n));
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) {
        this.setBigDecimal(bigDecimal, this.m_parent.getColumnDef(string));
    }

    public boolean getBoolean(int n) {
        return this.getBoolean(this.m_parent.getColumnDef(n));
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(this.m_parent.getColumnDef(string));
    }

    public void setBoolean(int n, boolean bl) {
        this.setBoolean(bl, this.m_parent.getColumnDef(n));
    }

    public void setBoolean(String string, boolean bl) {
        this.setBoolean(bl, this.m_parent.getColumnDef(string));
    }

    public byte[] getBytes(int n) {
        return this.getBytes(this.m_parent.getColumnDef(n));
    }

    public byte[] getBytes(String string) {
        return this.getBytes(this.m_parent.getColumnDef(string));
    }

    public byte[] getBytes(int n, int n2) {
        return this.getBytes(this.m_parent.getColumnDef(n), n2);
    }

    public byte[] getBytes(String string, int n) {
        return this.getBytes(this.m_parent.getColumnDef(string), n);
    }

    public byte[] getBytes(int n, int n2, int n3) {
        return this.getBytes(this.m_parent.getColumnDef(n), n2, n3);
    }

    public byte[] getBytes(String string, int n, int n2) {
        return this.getBytes(this.m_parent.getColumnDef(string), n, n2);
    }

    public void setBytes(int n, byte[] byArray) {
        this.setBytes(byArray, this.m_parent.getColumnDef(n));
    }

    public void setBytes(String string, byte[] byArray) {
        this.setBytes(byArray, this.m_parent.getColumnDef(string));
    }

    public void setBytes(int n, int n2, byte[] byArray) {
        this.setBytes(byArray, n2, this.m_parent.getColumnDef(n));
    }

    public void setBytes(String string, int n, byte[] byArray) {
        this.setBytes(byArray, n, this.m_parent.getColumnDef(string));
    }

    public Date getDate(int n) {
        return this.getDate(this.m_parent.getColumnDef(n));
    }

    public Date getDate(String string) {
        return this.getDate(this.m_parent.getColumnDef(string));
    }

    public void setDate(int n, Date date) {
        this.setDate(date, this.m_parent.getColumnDef(n));
    }

    public void setDate(String string, Date date) {
        this.setDate(date, this.m_parent.getColumnDef(string));
    }

    public Timestamp getTimestamp(int n) {
        return this.getTimestamp(this.m_parent.getColumnDef(n));
    }

    public Timestamp getTimestamp(String string) {
        return this.getTimestamp(this.m_parent.getColumnDef(string));
    }

    public void setTimestamp(int n, Timestamp timestamp) {
        this.setTimestamp(timestamp, this.m_parent.getColumnDef(n));
    }

    public void setTimestamp(String string, Timestamp timestamp) {
        this.setTimestamp(timestamp, this.m_parent.getColumnDef(string));
    }

    int getSize() {
        return this.m_buf.getSize();
    }

    public void setNull(String string) {
        this.setNull(this.m_parent.getColumnDef(string));
    }

    public void setNull(int n) {
        this.setNull(this.m_parent.getColumnDef(n));
    }

    public boolean isNull(String string) {
        return this.isNull(this.m_parent.getColumnDef(string));
    }

    public boolean isNull(int n) {
        return this.isNull(this.m_parent.getColumnDef(n));
    }

    private Object getObject(ColumnDef columnDef) {
        Object object;
        if (columnDef.isNullable() && this.m_buf.readByte(columnDef.getOffset() - 1) != 0) {
            throw new PsqlNullValueException(MessageCatalog.getNullValueErrorMsg(columnDef.getColumnName()));
        }
        switch (columnDef.m_type) {
            case 21: {
                object = new Long(this.m_buf.readLong(columnDef.m_rowsetOffset));
                break;
            }
            case 20: {
                object = Timestamp.valueOf(this.m_buf.readLong(columnDef.m_rowsetOffset));
                break;
            }
            case 1: {
                if (columnDef.m_length == 1) {
                    object = new Long(this.m_buf.readByte(columnDef.m_rowsetOffset));
                    break;
                }
                if (columnDef.m_length == 2) {
                    object = new Long(this.m_buf.readShort(columnDef.m_rowsetOffset));
                    break;
                }
                if (columnDef.m_length == 4) {
                    object = new Long(this.m_buf.readInteger(columnDef.m_rowsetOffset));
                    break;
                }
                object = new Long(this.m_buf.readLong(columnDef.m_rowsetOffset));
                break;
            }
            case 15: {
                if (columnDef.m_length == 2) {
                    object = new Long(this.m_buf.readShort(columnDef.m_rowsetOffset));
                    break;
                }
                object = new Long(this.m_buf.readInteger(columnDef.m_rowsetOffset));
                break;
            }
            case 14: {
                if (columnDef.m_length == 1) {
                    object = new Long(this.m_buf.readUnsignedByte(columnDef.m_rowsetOffset));
                    break;
                }
                if (columnDef.m_length == 2) {
                    object = new Long(this.m_buf.readUnsignedShort(columnDef.m_rowsetOffset));
                    break;
                }
                if (columnDef.m_length == 4) {
                    object = new Long(this.m_buf.readUnsignedInt(columnDef.m_rowsetOffset));
                    break;
                }
                object = this.m_buf.readUnsignedLong(columnDef.m_rowsetOffset);
                break;
            }
            case 2: {
                if (columnDef.m_length == 4) {
                    object = new Double(this.m_buf.readFloat(columnDef.m_rowsetOffset));
                    break;
                }
                object = new Double(this.m_buf.readDouble(columnDef.m_rowsetOffset));
                break;
            }
            case 9: {
                if (columnDef.m_length == 4) {
                    object = new Double(this.m_buf.readBfloat(columnDef.m_rowsetOffset, 4));
                    break;
                }
                object = new Double(this.m_buf.readBfloat(columnDef.m_rowsetOffset, 8));
                break;
            }
            case 19: {
                object = new Double(this.m_buf.readCurrency(columnDef.m_rowsetOffset));
                break;
            }
            case 16: {
                if ((this.m_buf.readByte(columnDef.m_rowsetOffset) & columnDef.m_dec) > 0) {
                    object = new Boolean(true);
                    break;
                }
                object = new Boolean(false);
                break;
            }
            case 5: {
                object = this.m_buf.readDecimalBigDecimal(columnDef.m_rowsetOffset, columnDef.m_length, columnDef.m_dec);
                break;
            }
            case 6: {
                object = this.m_buf.readMoneyBigDecimal(columnDef.m_rowsetOffset, columnDef.m_length);
                break;
            }
            case 8: {
                object = this.m_buf.readNumericBigDecimal(columnDef.m_rowsetOffset, columnDef.m_length, columnDef.m_dec);
                break;
            }
            case 18: {
                object = this.m_buf.readSABigDecimal(columnDef.m_rowsetOffset, columnDef.m_length, columnDef.m_dec);
                break;
            }
            case 17: {
                object = this.m_buf.readSTSBigDecimal(columnDef.m_rowsetOffset, columnDef.m_length, columnDef.m_dec);
                break;
            }
            case 7: {
                object = new Boolean(this.m_buf.readLogical(columnDef.m_rowsetOffset, columnDef.m_length, 1));
                break;
            }
            case 0: {
                object = this.rTrim(this.m_buf.readString(columnDef.m_rowsetOffset, columnDef.m_length));
                break;
            }
            case 10: {
                object = this.m_buf.readLString(columnDef.m_rowsetOffset, this.m_buf.readUnsignedByte(columnDef.m_rowsetOffset));
                break;
            }
            case 11: {
                object = this.m_buf.readZString(columnDef.m_rowsetOffset, columnDef.m_length);
                break;
            }
            case 13: {
                if (this.m_buf.getSize() <= columnDef.m_rowsetOffset) {
                    object = new byte[0];
                    break;
                }
                object = this.m_buf.readBytes(columnDef.m_rowsetOffset + 2, this.m_buf.readUnsignedShort(columnDef.m_rowsetOffset));
                break;
            }
            case 12: {
                if (this.m_buf.getSize() <= columnDef.m_rowsetOffset) {
                    object = new byte[0];
                    break;
                }
                object = this.m_buf.readBytes(columnDef.m_rowsetOffset, this.m_buf.findNullByte(columnDef.m_rowsetOffset) - columnDef.m_rowsetOffset);
                break;
            }
            case 3: {
                object = this.m_buf.readDate(columnDef.m_rowsetOffset);
                break;
            }
            case 4: {
                object = this.m_buf.readTime(columnDef.m_rowsetOffset);
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "getObject", columnDef.m_type, ""));
            }
        }
        return object;
    }

    private void putObject(Object object, ColumnDef columnDef) {
        byte[] byArray;
        if (this.m_setToNull) {
            byArray = new byte[]{1};
            this.m_buf.writeBytes(byArray, columnDef.m_rowsetOffset - 1);
        } else if (columnDef.isNullable()) {
            byArray = new byte[]{0};
            this.m_buf.writeBytes(byArray, columnDef.m_rowsetOffset - 1);
        }
        switch (columnDef.m_type) {
            case 21: {
                this.m_buf.writeLong((Long)object, columnDef.m_rowsetOffset);
                break;
            }
            case 20: {
                this.m_buf.writeLong(((Timestamp)object).septaValue(columnDef.m_dec), columnDef.m_rowsetOffset);
                break;
            }
            case 1: {
                if (columnDef.m_length == 1) {
                    this.m_buf.writeByte(((Long)object).byteValue(), columnDef.m_rowsetOffset);
                    break;
                }
                if (columnDef.m_length == 2) {
                    this.m_buf.writeShort(((Long)object).shortValue(), columnDef.m_rowsetOffset);
                    break;
                }
                if (columnDef.m_length == 4) {
                    this.m_buf.writeInteger(((Long)object).intValue(), columnDef.m_rowsetOffset);
                    break;
                }
                this.m_buf.writeLong((Long)object, columnDef.m_rowsetOffset);
                break;
            }
            case 15: {
                if (columnDef.m_length == 2) {
                    this.m_buf.writeShort(((Long)object).shortValue(), columnDef.m_rowsetOffset);
                    break;
                }
                this.m_buf.writeInteger(((Long)object).intValue(), columnDef.m_rowsetOffset);
                break;
            }
            case 14: {
                if (columnDef.m_length == 1) {
                    this.m_buf.writeUnsignedByte(((Long)object).shortValue(), columnDef.m_rowsetOffset);
                    break;
                }
                if (columnDef.m_length == 2) {
                    this.m_buf.writeUnsignedShort(((Long)object).intValue(), columnDef.m_rowsetOffset);
                    break;
                }
                if (columnDef.m_length == 4) {
                    this.m_buf.writeUnsignedInt((Long)object, columnDef.m_rowsetOffset);
                    break;
                }
                this.m_buf.writeLong((Long)object, columnDef.m_rowsetOffset);
                break;
            }
            case 2: {
                if (columnDef.m_length == 4) {
                    this.m_buf.writeFloat(((Double)object).floatValue(), columnDef.m_rowsetOffset);
                    break;
                }
                this.m_buf.writeDouble((Double)object, columnDef.m_rowsetOffset);
                break;
            }
            case 9: {
                if (columnDef.m_length == 4) {
                    this.m_buf.writeBfloat(((Double)object).floatValue(), columnDef.m_rowsetOffset, 4);
                    break;
                }
                this.m_buf.writeBfloat((Double)object, columnDef.m_rowsetOffset, 8);
                break;
            }
            case 19: {
                this.m_buf.writeCurrency((Double)object, columnDef.m_rowsetOffset);
                break;
            }
            case 16: {
                byte[] byArray2 = new byte[1];
                boolean bl = (Boolean)object;
                this.m_buf.readBytes(byArray2, columnDef.m_rowsetOffset, Math.min(byArray2.length, columnDef.m_length));
                byte by = (byte)columnDef.m_dec;
                byArray2[0] = bl ? (byte)(byArray2[0] | by) : (byte)(byArray2[0] & ~by);
                this.m_buf.writeBytes(byArray2, columnDef.m_rowsetOffset, Math.min(byArray2.length, columnDef.m_length));
                break;
            }
            case 5: {
                this.m_buf.writeDecimal((String)object, columnDef.m_rowsetOffset, columnDef.m_length, columnDef.m_dec);
                break;
            }
            case 6: {
                this.m_buf.writeMoney((String)object, columnDef.m_rowsetOffset, columnDef.m_length);
                break;
            }
            case 8: {
                this.m_buf.writeNumeric((String)object, columnDef.m_rowsetOffset, columnDef.m_length, columnDef.m_dec);
                break;
            }
            case 18: {
                this.m_buf.writeSA((String)object, columnDef.m_rowsetOffset, columnDef.m_length, columnDef.m_dec);
                break;
            }
            case 17: {
                this.m_buf.writeSTS((String)object, columnDef.m_rowsetOffset, columnDef.m_length, columnDef.m_dec);
                break;
            }
            case 7: {
                this.m_buf.writeLogical((Boolean)object, columnDef.m_rowsetOffset, columnDef.m_length, 1);
                break;
            }
            case 0: {
                if (((String)object).length() > columnDef.m_length) {
                    throw new IllegalArgumentException(MessageCatalog.getArgumentToLongMsg(this, "putObject", new Integer(columnDef.m_length)));
                }
                this.m_buf.writeString((String)object, columnDef.m_rowsetOffset, columnDef.m_length);
                break;
            }
            case 10: {
                if (((String)object).length() > columnDef.m_length - 1) {
                    throw new IllegalArgumentException(MessageCatalog.getArgumentToLongMsg(this, "putObject", new Integer(columnDef.m_length - 1)));
                }
                this.m_buf.writeLString((String)object, columnDef.m_rowsetOffset, columnDef.m_length);
                break;
            }
            case 11: {
                if (((String)object).length() > columnDef.m_length - 1) {
                    throw new IllegalArgumentException(MessageCatalog.getArgumentToLongMsg(this, "putObject", new Integer(columnDef.m_length - 1)));
                }
                this.m_buf.writeZString((String)object, columnDef.m_rowsetOffset, columnDef.m_length);
                break;
            }
            case 13: {
                byte[] byArray3 = (byte[])object;
                if (byArray3.length > columnDef.m_length - 4) {
                    throw new IllegalArgumentException(MessageCatalog.getArgumentToLongMsg(this, "putObject", new Integer(columnDef.m_length - 4)));
                }
                this.m_buf.writeUnsignedShort(byArray3.length, columnDef.m_rowsetOffset);
                this.m_buf.writeBytes(byArray3, columnDef.m_rowsetOffset + 2, byArray3.length);
                this.m_buf.writeByte((byte)0, columnDef.m_rowsetOffset + 2 + byArray3.length);
                this.m_buf.writeByte((byte)0, columnDef.m_rowsetOffset + 2 + byArray3.length + 1);
                break;
            }
            case 12: {
                byte[] byArray4 = (byte[])object;
                if (byArray4.length > columnDef.m_length - 1) {
                    throw new IllegalArgumentException(MessageCatalog.getArgumentToLongMsg(this, "putObject", new Integer(columnDef.m_length - 1)));
                }
                this.m_buf.writeBytes(byArray4, columnDef.m_rowsetOffset, byArray4.length);
                this.m_buf.writeByte((byte)0, columnDef.m_rowsetOffset + byArray4.length);
                break;
            }
            case 3: {
                if (this.m_setToNull) {
                    this.m_buf.writeInteger(0, columnDef.m_rowsetOffset);
                    break;
                }
                this.m_buf.writeDate((Date)object, columnDef.m_rowsetOffset);
                break;
            }
            case 4: {
                this.m_buf.writeTime((Date)object, columnDef.m_rowsetOffset);
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "putObject", columnDef.m_type, ""));
            }
        }
    }

    private String getString(ColumnDef columnDef) {
        String string;
        switch (columnDef.m_type) {
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                Object object = this.getObject(columnDef);
                string = object == null ? null : object.toString();
                break;
            }
            case 3: {
                Object object = this.getObject(columnDef);
                string = object == null ? null : DateFormat.getDateInstance().format((Date)object);
                break;
            }
            case 4: {
                Object object = this.getObject(columnDef);
                string = object == null ? null : DateFormat.getTimeInstance().format((Date)object);
                break;
            }
            case 20: {
                Object object = this.getObject(columnDef);
                string = object == null ? null : ((Timestamp)object).toString();
                break;
            }
            case 12: {
                Object object = this.getObject(columnDef);
                string = object == null ? null : CharsetUtils.createStringFromBytes((byte[])object, this.m_charsetName);
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "getString", columnDef.m_type, "String"));
            }
        }
        return string;
    }

    private void setString(String string, ColumnDef columnDef) {
        switch (columnDef.m_type) {
            case 1: 
            case 14: 
            case 15: {
                Long l;
                try {
                    l = new Long(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(MessageCatalog.getConversionExMsg(this, numberFormatException, "setString", columnDef.m_type, "String"));
                }
                this.putObject(l, columnDef);
                break;
            }
            case 2: 
            case 9: 
            case 19: {
                Double d;
                try {
                    d = new Double(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(MessageCatalog.getConversionExMsg(this, numberFormatException, "setString", columnDef.m_type, "String"));
                }
                this.putObject(d, columnDef);
                break;
            }
            case 7: {
                Boolean bl = new Boolean(string);
                this.putObject(bl, columnDef);
                break;
            }
            case 0: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 17: 
            case 18: {
                this.putObject(string, columnDef);
                break;
            }
            case 12: {
                this.putObject(string.getBytes(), columnDef);
                break;
            }
            case 3: 
            case 4: {
                Date date = null;
                try {
                    date = DateFormat.getInstance().parse(string);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(MessageCatalog.getConversionExMsg(this, exception, "setString", columnDef.m_type, "String"));
                }
                this.putObject(date, columnDef);
                break;
            }
            case 20: {
                this.putObject(Timestamp.valueOf(string), columnDef);
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "setString", columnDef.m_type, "String"));
            }
        }
    }

    private byte getByte(ColumnDef columnDef) {
        byte by;
        Object object = this.getObject(columnDef);
        switch (columnDef.m_type) {
            case 1: 
            case 14: {
                by = ((Number)object).byteValue();
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "getByte", columnDef.m_type, "byte"));
            }
        }
        return by;
    }

    private void setByte(byte by, ColumnDef columnDef) {
        Long l = new Long(by);
        switch (columnDef.m_type) {
            case 1: 
            case 14: {
                this.putObject(l, columnDef);
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "setByte", columnDef.m_type, "byte"));
            }
        }
    }

    private short getShort(ColumnDef columnDef) {
        short s;
        Object object = this.getObject(columnDef);
        switch (columnDef.m_type) {
            case 1: 
            case 14: 
            case 15: {
                s = ((Number)object).shortValue();
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "getShort", columnDef.m_type, "short"));
            }
        }
        return s;
    }

    private void setShort(short s, ColumnDef columnDef) {
        Long l = new Long(s);
        switch (columnDef.m_type) {
            case 1: 
            case 14: 
            case 15: {
                this.putObject(l, columnDef);
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "setShort", columnDef.m_type, "short"));
            }
        }
    }

    private int getInt(ColumnDef columnDef) {
        int n;
        Object object = this.getObject(columnDef);
        switch (columnDef.m_type) {
            case 1: 
            case 14: 
            case 15: {
                n = ((Number)object).intValue();
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "getInt", columnDef.m_type, "int"));
            }
        }
        return n;
    }

    private void setInt(int n, ColumnDef columnDef) {
        Long l = new Long(n);
        switch (columnDef.m_type) {
            case 1: 
            case 14: 
            case 15: {
                this.putObject(l, columnDef);
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "setInt", columnDef.m_type, "int"));
            }
        }
    }

    private long getLong(ColumnDef columnDef) {
        long l;
        Object object = this.getObject(columnDef);
        switch (columnDef.m_type) {
            case 1: 
            case 14: 
            case 15: 
            case 21: {
                l = ((Number)object).longValue();
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "getLong", columnDef.m_type, "long"));
            }
        }
        return l;
    }

    private void setLong(long l, ColumnDef columnDef) {
        Long l2 = new Long(l);
        switch (columnDef.m_type) {
            case 1: 
            case 14: 
            case 21: {
                this.putObject(l2, columnDef);
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "setLong", columnDef.m_type, "long"));
            }
        }
    }

    private BigInteger getBigInteger(ColumnDef columnDef) {
        BigInteger bigInteger = null;
        Object object = this.getObject(columnDef);
        switch (columnDef.m_type) {
            case 1: 
            case 15: 
            case 21: {
                bigInteger = new BigInteger(object.toString());
                break;
            }
            case 14: {
                if (columnDef.m_length == 8) {
                    bigInteger = (BigInteger)object;
                    break;
                }
                bigInteger = new BigInteger(object.toString());
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "getBigInteger", columnDef.m_type, "BigInteger"));
            }
        }
        return bigInteger;
    }

    private void setBigInteger(BigInteger bigInteger, ColumnDef columnDef) {
        switch (columnDef.m_type) {
            case 1: 
            case 14: 
            case 21: {
                this.putObject(new Long(bigInteger.longValue()), columnDef);
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "setBigInteger", columnDef.m_type, "BigInteger"));
            }
        }
    }

    private float getFloat(ColumnDef columnDef) {
        float f;
        Number number = (Number)this.getObject(columnDef);
        switch (columnDef.m_type) {
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 17: 
            case 18: 
            case 19: {
                f = number.floatValue();
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "getFloat", columnDef.m_type, "float"));
            }
        }
        return f;
    }

    private void setFloat(float f, ColumnDef columnDef) {
        this.setDouble(f, columnDef);
    }

    private double getDouble(ColumnDef columnDef) {
        double d;
        Number number = (Number)this.getObject(columnDef);
        switch (columnDef.m_type) {
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 17: 
            case 18: 
            case 19: {
                d = number.doubleValue();
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "getDouble", columnDef.m_type, "double"));
            }
        }
        return d;
    }

    private void setDouble(double d, ColumnDef columnDef) {
        Double d2 = new Double(d);
        switch (columnDef.m_type) {
            case 2: 
            case 9: 
            case 19: {
                this.putObject(d2, columnDef);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 17: 
            case 18: {
                this.putObject(d2.toString(), columnDef);
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "setDouble", columnDef.m_type, "double"));
            }
        }
    }

    private BigDecimal getBigDecimal(ColumnDef columnDef) {
        BigDecimal bigDecimal;
        Number number = (Number)this.getObject(columnDef);
        switch (columnDef.m_type) {
            case 2: 
            case 9: 
            case 19: {
                bigDecimal = new BigDecimal(number.doubleValue());
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 17: 
            case 18: {
                bigDecimal = (BigDecimal)number;
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "getDouble", columnDef.m_type, "double"));
            }
        }
        return bigDecimal;
    }

    private void setBigDecimal(BigDecimal bigDecimal, ColumnDef columnDef) {
        switch (columnDef.m_type) {
            case 2: 
            case 9: 
            case 19: {
                this.putObject(new Double(bigDecimal.doubleValue()), columnDef);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 17: 
            case 18: {
                this.putObject(bigDecimal.toString(), columnDef);
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "setDouble", columnDef.m_type, "double"));
            }
        }
    }

    private boolean getBoolean(ColumnDef columnDef) {
        boolean bl;
        switch (columnDef.m_type) {
            case 16: {
                if ((this.m_buf.readByte(columnDef.m_rowsetOffset) & columnDef.m_dec) > 0) {
                    bl = new Boolean(true);
                    break;
                }
                bl = new Boolean(false);
                break;
            }
            case 7: {
                bl = (Boolean)this.getObject(columnDef);
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "getBoolean", columnDef.m_type, "boolean"));
            }
        }
        return bl;
    }

    private void setBoolean(boolean bl, ColumnDef columnDef) {
        switch (columnDef.m_type) {
            case 7: 
            case 16: {
                this.putObject(new Boolean(bl), columnDef);
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "setBoolean", columnDef.m_type, "boolean"));
            }
        }
    }

    private boolean isFixedLengthColumn(ColumnDef columnDef) {
        int n = columnDef.m_type;
        return n != 12 && n != 13 && n != 21 && n != 22;
    }

    private byte[] getBytes(ColumnDef columnDef) {
        return this.getBytes(columnDef, 0, Integer.MAX_VALUE);
    }

    private void setBytes(byte[] byArray, ColumnDef columnDef) {
        if (this.isFixedLengthColumn(columnDef) && byArray.length > columnDef.getLength()) {
            throw new IllegalArgumentException("length of value is greater than the length of column '" + columnDef.getColumnName() + "'");
        }
        this.setBytes(byArray, 0, columnDef);
    }

    private byte[] getBytes(ColumnDef columnDef, int n) {
        return this.getBytes(columnDef, n, columnDef.m_length);
    }

    private byte[] getBytes(ColumnDef columnDef, int n, int n2) {
        int n3;
        switch (columnDef.m_type) {
            case 12: {
                if (this.m_buf.getSize() <= columnDef.m_rowsetOffset) {
                    return new byte[0];
                }
                if (n >= columnDef.m_length - 1) {
                    throw new IllegalArgumentException(MessageCatalog.getIllegalArgumentMsg(this, "getBytes", "colOffset", Integer.toString(n)));
                }
                n3 = this.m_buf.findNullByte(columnDef.m_rowsetOffset) - columnDef.m_rowsetOffset - n;
                break;
            }
            case 13: {
                if (this.m_buf.getSize() <= columnDef.m_rowsetOffset) {
                    return new byte[0];
                }
                if (n >= columnDef.m_length - 4) {
                    throw new IllegalArgumentException(MessageCatalog.getIllegalArgumentMsg(this, "getBytes", "colOffset", Integer.toString(n)));
                }
                n3 = this.m_buf.readUnsignedShort(columnDef.m_rowsetOffset) - n;
                n += 2;
                break;
            }
            case 10: {
                n3 = this.m_buf.readUnsignedByte(columnDef.m_rowsetOffset);
                ++n;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: {
                n3 = columnDef.m_length;
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "getBytes", columnDef.m_type, "byte[]"));
            }
        }
        byte[] byArray = this.m_buf.readBytes(columnDef.m_rowsetOffset + n, n2 > n3 ? n3 : n2);
        return byArray;
    }

    private void setBytes(byte[] byArray, int n, ColumnDef columnDef) {
        byte[] byArray2;
        switch (columnDef.m_type) {
            case 12: {
                if (n + byArray.length > columnDef.m_length - 1) {
                    throw new IllegalArgumentException(MessageCatalog.getArgumentToLongMsg(this, "putObject", new Integer(columnDef.m_length - 1)));
                }
                this.m_buf.writeBytes(byArray, columnDef.m_rowsetOffset + n, byArray.length);
                this.m_buf.writeByte((byte)0, columnDef.m_rowsetOffset + n + byArray.length);
                break;
            }
            case 13: {
                if (n + byArray.length > columnDef.m_length - 4) {
                    throw new IllegalArgumentException(MessageCatalog.getArgumentToLongMsg(this, "putObject", new Integer(columnDef.m_length - 4)));
                }
                this.m_buf.writeBytes(byArray, columnDef.m_rowsetOffset + 2 + n, byArray.length);
                this.m_buf.writeByte((byte)0, columnDef.m_rowsetOffset + 2 + n + byArray.length);
                this.m_buf.writeByte((byte)0, columnDef.m_rowsetOffset + 2 + n + byArray.length + 1);
                this.m_buf.writeUnsignedShort(byArray.length + n, columnDef.m_rowsetOffset);
                break;
            }
            case 16: {
                byArray2 = new byte[1];
                this.m_buf.readBytes(byArray2, columnDef.m_rowsetOffset + n, 1);
                byte by = (byte)columnDef.m_dec;
                byArray2[0] = byArray[0] > 0 ? (byte)(byArray2[0] | by) : (byte)(byArray2[0] & ~by);
                this.m_buf.writeBytes(byArray2, columnDef.m_rowsetOffset + n, 1);
                break;
            }
            case 10: {
                this.m_buf.writeBytes(byArray, columnDef.m_rowsetOffset + 1, byArray.length);
                this.m_buf.writeByte((byte)byArray.length, columnDef.m_rowsetOffset);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: {
                this.m_buf.writeBytes(byArray, columnDef.m_rowsetOffset + n, byArray.length);
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "setBytes", columnDef.m_type, "byte[]"));
            }
        }
        if (columnDef.isNullable()) {
            byArray2 = new byte[]{0};
            this.m_buf.writeBytes(byArray2, columnDef.m_rowsetOffset - 1);
        }
    }

    private Date getDate(ColumnDef columnDef) {
        Date date;
        Object object = this.getObject(columnDef);
        switch (columnDef.m_type) {
            case 3: 
            case 4: {
                date = (Date)object;
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "getDate", columnDef.m_type, "Date"));
            }
        }
        return date;
    }

    private void setDate(Date date, ColumnDef columnDef) {
        switch (columnDef.m_type) {
            case 3: 
            case 4: {
                this.putObject(date, columnDef);
                break;
            }
            default: {
                throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "setDate", columnDef.m_type, "Date"));
            }
        }
    }

    private Timestamp getTimestamp(ColumnDef columnDef) {
        if (columnDef.m_type != 20) {
            throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "getTimestamp", columnDef.m_type, "Timestamp"));
        }
        return (Timestamp)this.getObject(columnDef);
    }

    private void setTimestamp(Timestamp timestamp, ColumnDef columnDef) {
        if (columnDef.m_type != 20) {
            throw new PsqlConversionNotSupportedException(MessageCatalog.getUnsupportedConversionMsg(this, "setTimestamp", columnDef.m_type, "Timestamp"));
        }
        this.putObject(timestamp, columnDef);
    }

    private void setNull(ColumnDef columnDef) {
        if (!columnDef.isNullable()) {
            throw new PsqlColumnNotNullableException(MessageCatalog.getNonNullableColumnMsg(columnDef.getColumnName()));
        }
        Object object = null;
        switch (columnDef.getType()) {
            case 1: 
            case 14: 
            case 21: {
                object = new Long(0L);
                break;
            }
            case 2: 
            case 9: 
            case 19: {
                object = new Double(0.0);
                break;
            }
            case 16: {
                object = new byte[columnDef.getDefLength()];
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 17: 
            case 18: {
                object = new String("0");
                break;
            }
            case 0: 
            case 10: 
            case 11: {
                object = new String(new char[columnDef.getDefLength() - 1]);
                break;
            }
            case 7: {
                object = new Boolean(false);
                break;
            }
            case 13: {
                object = new byte[columnDef.getDefLength() - 4];
                break;
            }
            case 12: {
                object = new byte[columnDef.getDefLength() - 1];
                break;
            }
            case 3: 
            case 4: {
                object = new Date(0L);
                break;
            }
            case 20: {
                object = new Timestamp(0L);
                break;
            }
            default: {
                throw new PsqlColumnNotNullableException(MessageCatalog.getNonNullableColumnMsg(columnDef.getColumnName()));
            }
        }
        this.m_setToNull = true;
        this.putObject(object, columnDef);
        this.m_setToNull = false;
    }

    private boolean isNull(ColumnDef columnDef) {
        if (columnDef.isNullable()) {
            return this.m_buf.readBytes(columnDef.getOffset() - 1, 1)[0] != 0;
        }
        return false;
    }

    String rTrim(String string) {
        if (string != null && string.endsWith(" ")) {
            int n;
            for (n = string.length() - 1; n > 0 && string.charAt(n) == ' '; --n) {
            }
            if (n > 0) {
                string = string.substring(0, n + 1);
            }
        }
        return string;
    }
}

