/*
 * Decompiled with CFR 0.152.
 */
package pervasive.database;

import pervasive.database.DBURI;
import pervasive.database.IBTRV;
import pervasive.database.IOBuffer;
import pervasive.database.IntelIOBuffer;
import pervasive.database.MessageCatalog;
import pervasive.database.OpResult;
import pervasive.database.PsqlConnectionException;
import pervasive.database.PsqlDDFOperationException;
import pervasive.database.PsqlDatabaseOpenException;
import pervasive.database.PsqlException;
import pervasive.database.PsqlIOException;
import pervasive.database.TableDDFInfo;

class JNIBTRV
implements IBTRV {
    private static final short BTRV_KEY_LENGTH = 255;
    private static final String dllName = "jnibtrv";
    private static final String dllName64 = "w64jnibtrv";
    private static boolean m_loaded = false;
    private static boolean m_pvStarted = false;
    private static int m_connectionCnt = 0;
    private DBURI m_uri;
    private long m_connectionHandle = -1L;
    private int m_dbHandle = -1;

    JNIBTRV() throws PsqlConnectionException {
        this(null);
    }

    JNIBTRV(DBURI dBURI) throws PsqlConnectionException {
        JNIBTRV.loadDLL();
        this.m_uri = dBURI;
        if (this.m_uri != null) {
            this.m_connectionHandle = this.connectServer(this.m_uri.getHost());
        }
    }

    @Override
    public void open() {
    }

    @Override
    public synchronized void close() {
        if (this.m_dbHandle != -1) {
            this._closeDatabase(this.m_dbHandle);
            this.m_dbHandle = -1;
        }
        this.disconnectServer(this.m_connectionHandle);
    }

    @Override
    public synchronized int invoke(short s, byte[] byArray, IOBuffer iOBuffer, int n, IOBuffer iOBuffer2, short s2, int n2, short s3, byte[] byArray2, OpResult opResult) throws PsqlIOException {
        return this._invoke(s, byArray, iOBuffer.getBufferData(), n, iOBuffer2.getBufferData(), s2, n2, s3, byArray2, opResult);
    }

    @Override
    public IOBuffer createIOBuffer(int n, String string) {
        return new IntelIOBuffer(n, string);
    }

    @Override
    public String getDataPath(String string) throws PsqlDDFOperationException {
        String string2 = this._getDataPath(this.m_connectionHandle, string);
        return string2;
    }

    @Override
    public String[] getDatabaseNames(String string) throws PsqlConnectionException {
        long l = this.connectServer(string);
        String[] stringArray = this._getDBNamesList(l);
        this.disconnectServer(l);
        return stringArray;
    }

    @Override
    public String[] getTableNames() throws PsqlException {
        if (this.m_dbHandle == -1) {
            try {
                this.m_dbHandle = this._openDatabase(this.m_connectionHandle, this.m_uri.getDBName(), this.m_uri.getUser(), this.m_uri.getPassword());
            }
            catch (PsqlDDFOperationException psqlDDFOperationException) {
                throw new PsqlDatabaseOpenException(this.m_uri, psqlDDFOperationException.getOperation(), psqlDDFOperationException.getErrorCode());
            }
        }
        return this._getTableNames(this.m_dbHandle);
    }

    @Override
    public TableDDFInfo getTableDDFInfo(String string) throws PsqlException {
        TableDDFInfo tableDDFInfo = this._getTableDDFInfo(this.m_dbHandle, string);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < tableDDFInfo.columnInfo.length; ++i) {
            if (tableDDFInfo.columnInfo[i].type == 16) {
                if (n3 == 16 && n2 >= 8) {
                    n2 = 0;
                }
                ++n2;
                tableDDFInfo.columnInfo[i].offset = ++n;
            } else {
                if (n3 == 16) {
                    ++n;
                }
                if ((tableDDFInfo.columnInfo[i].flags & 4) != 0) {
                    // empty if block
                }
                tableDDFInfo.columnInfo[i].offset = ++n;
                n += tableDDFInfo.columnInfo[i].size;
            }
            n3 = tableDDFInfo.columnInfo[i].type;
        }
        return tableDDFInfo;
    }

    private synchronized long connectServer(String string) throws PsqlConnectionException {
        if (!m_pvStarted) {
            this._startPv();
            m_pvStarted = true;
        }
        long l = 0L;
        try {
            if (string != null) {
                string = string.equalsIgnoreCase("localhost") ? null : string;
            }
            l = this._connectServer((String)(string != null && string.equalsIgnoreCase("localhost") ? null : string));
            ++m_connectionCnt;
        }
        catch (PsqlDDFOperationException psqlDDFOperationException) {
            this._stopPv();
            m_pvStarted = false;
            throw new PsqlConnectionException(psqlDDFOperationException, MessageCatalog.getServerConnectionMsg(string));
        }
        return l;
    }

    private synchronized void disconnectServer(long l) {
        this._disconnectServer(l);
        if (--m_connectionCnt == 0 && m_pvStarted) {
            this._stopPv();
            m_pvStarted = false;
        }
    }

    private static synchronized void loadDLL() throws PsqlConnectionException {
        if (m_loaded) {
            return;
        }
        try {
            System.loadLibrary(dllName64);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                System.loadLibrary(dllName);
            }
            catch (Throwable throwable) {
                throw new PsqlConnectionException(throwable);
            }
        }
        catch (Throwable throwable) {
            throw new PsqlConnectionException(throwable);
        }
        m_loaded = true;
    }

    private native int _invoke(short var1, byte[] var2, byte[] var3, int var4, byte[] var5, short var6, int var7, short var8, byte[] var9, OpResult var10);

    private native void _startPv();

    private native void _stopPv();

    private native long _connectServer(String var1) throws PsqlDDFOperationException;

    private native void _disconnectServer(long var1);

    private native int _openDatabase(long var1, String var3, String var4, String var5) throws PsqlDDFOperationException;

    private native void _closeDatabase(int var1);

    private native String _getDataPath(long var1, String var3) throws PsqlDDFOperationException;

    private native String[] _getTableNames(int var1) throws PsqlDDFOperationException;

    private native TableDDFInfo _getTableDDFInfo(int var1, String var2) throws PsqlDDFOperationException;

    private native String[] _getDBNamesList(long var1);
}

