/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.common.DebugInputStream;
import com.pervasive.jdbc.common.DebugOutputStream;
import com.pervasive.jdbc.common.JDBCURL;
import com.pervasive.jdbc.lna.LNASocketSessionST;
import com.pervasive.jdbc.lna.PervasiveConnectionListener;
import com.pervasive.jdbc.lna.SharedMemorySocket;
import java.io.IOException;

public class SharedMemorySession
extends LNASocketSessionST {
    private SharedMemorySocket d_shmemSocket;

    public SharedMemorySession(JDBCURL jDBCURL, PervasiveConnectionListener pervasiveConnectionListener, boolean bl) {
        super(jDBCURL, pervasiveConnectionListener, bl);
    }

    @Override
    public synchronized void open() throws IOException {
        if (!this.d_open) {
            this.d_shmemSocket = new SharedMemorySocket(2530);
            int n = this.d_url.getTimeout();
            if (this.d_log) {
                this.d_in = new DebugInputStream(this.d_shmemSocket.getInputStream());
                this.d_out = new DebugOutputStream(this.d_shmemSocket.getOutputStream());
            } else {
                this.d_in = this.d_shmemSocket.getInputStream();
                this.d_out = this.d_shmemSocket.getOutputStream();
            }
            this.d_curReqNum = 0;
            this.d_open = true;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.d_open) {
            this.d_open = false;
            this.d_in.close();
            this.d_out.close();
            this.d_shmemSocket.close();
        }
    }

    @Override
    protected Object getSyncObject() {
        return this.d_shmemSocket;
    }
}

