/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.psql.utilities.javadti;

import com.pervasive.psql.utilities.javadti.Connection;
import com.pervasive.psql.utilities.javadti.DBFileTable;
import com.pervasive.psql.utilities.javadti.DTICONSTS;
import com.pervasive.psql.utilities.javadti.DTIException;
import com.pervasive.psql.utilities.javadti.DTIUtils;
import com.pervasive.psql.utilities.javadti.FileElement;
import com.pervasive.psql.utilities.javadti.PVFILEHDLINFOEX;
import com.pervasive.psql.utilities.javadti.PVFILEINFO2;
import com.pervasive.psql.utilities.javadti.TableNotFoundException;
import com.pervasive.psql.utilities.javadti.javadti;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;

public class FileData {
    private static Map<Connection, FileData> fileDataMap = new HashMap<Connection, FileData>();
    private int m_hConnection = -99;
    private Logger m_logger;
    private long m_fh_Total = -1L;
    private long m_fo_Total = -1L;
    private boolean m_bInit = false;
    private Connection m_conn = null;
    private FileElement[] fileElements = null;

    private FileData(Connection connection, String string) throws DTIException {
        this.m_conn = connection;
        this.m_logger = Logger.getLogger(string);
        this.initialize(connection.getHandle());
    }

    public static FileData getObj(Connection connection, String string) throws DTIException {
        FileData fileData = fileDataMap.get(connection);
        if (fileData != null) {
            return fileData;
        }
        fileData = new FileData(connection, string);
        fileDataMap.put(connection, fileData);
        return fileData;
    }

    private void initialize(int n) throws DTIException {
        this.m_hConnection = n;
        this.m_bInit = true;
    }

    public void dispose() {
        if (this.m_bInit) {
            this.freeData();
            this.m_bInit = false;
        }
        if (this.fileElements != null) {
            int n = 0;
            while (n < this.fileElements.length) {
                this.fileElements[n].dispose();
                ++n;
            }
        }
        Iterator<Connection> iterator = fileDataMap.keySet().iterator();
        Connection connection = null;
        while (iterator.hasNext()) {
            Connection connection2 = iterator.next();
            if (!connection2.equals(this.m_conn)) continue;
            connection = connection2;
            break;
        }
        if (connection != null) {
            fileDataMap.remove(connection);
        }
    }

    public long getCount() throws DTIException {
        long[] lArray = new long[1];
        int n = javadti.JPvGetOpenFilesData(this.m_hConnection, lArray);
        if (n != DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetOpenFilesData Error: " + DTICONSTS.getErrorDesc(n));
            this.m_fo_Total = -1L;
            throw new DTIException(n);
        }
        this.m_fo_Total = lArray[0];
        return this.m_fo_Total;
    }

    public String getName(long l) throws DTIException {
        assert (l < this.m_fo_Total) : l;
        long[] lArray = new long[]{255L};
        byte[] byArray = new byte[255];
        String string = "";
        int n = javadti.JPvGetOpenFileName(this.m_hConnection, l, lArray, byArray);
        if (n != DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetOpenFileName Error: " + DTICONSTS.getErrorDesc(n));
            string = "";
            throw new DTIException(n);
        }
        string = DTIUtils.getLocaleString(byArray);
        this.m_logger.finer("JPvGetOpenFileName Success, FileName: " + string);
        return string;
    }

    public long getHandleCount(String string) throws DTIException {
        assert (string.length() > 0);
        long[] lArray = new long[1];
        int n = javadti.JPvGetFileHandlesData(this.m_hConnection, string, lArray);
        if (n != DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetFileHandlesData Error: " + DTICONSTS.getErrorDesc(n));
            this.m_fh_Total = -1L;
            throw new DTIException(n);
        }
        this.m_fh_Total = lArray[0];
        this.m_logger.finer("JPvGetFileHandlesData Success, FileHandle Total: " + this.m_fh_Total);
        return this.m_fh_Total;
    }

    public void getHandleInfo(String string, long l, PVFILEHDLINFOEX pVFILEHDLINFOEX) throws DTIException {
        assert (l < this.m_fh_Total) : l;
        assert (string.length() > 0);
        int n = javadti.JPvGetFileHandleInfoEx(this.m_hConnection, string, l, pVFILEHDLINFOEX);
        if (n != DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetFileHandleInfoEx Error: " + DTICONSTS.getErrorDesc(n));
            throw new DTIException(n);
        }
        this.m_logger.finer("JPvGetFileHandleInfoEx Success");
    }

    public void getFileInfo(String string, PVFILEINFO2 pVFILEINFO2) throws DTIException {
        assert (string.length() > 0);
        int n = javadti.JPvGetFileInfo(this.m_hConnection, string, pVFILEINFO2);
        if (n != DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetFileInfo Error: " + DTICONSTS.getErrorDesc(n));
            throw new DTIException(n);
        }
        this.m_logger.finer("JPvGetFileInfo Success");
    }

    public FileElement[] getData() throws DTIException {
        long l = this.getCount();
        this.fileElements = new FileElement[(int)l];
        DBFileTable dBFileTable = new DBFileTable(this.m_conn);
        String string = "";
        int n = 0;
        while ((long)n < l) {
            this.fileElements[n] = new FileElement();
            String string2 = this.getName(n);
            PVFILEINFO2 pVFILEINFO2 = new PVFILEINFO2();
            this.getFileInfo(string2, pVFILEINFO2);
            this.fileElements[n].setFileName(string2);
            this.fileElements[n].setFileinfo(pVFILEINFO2);
            try {
                string = dBFileTable.getTableName(string2);
            }
            catch (DataFormatException dataFormatException) {
                string = "";
            }
            catch (TableNotFoundException tableNotFoundException) {
                string = "";
            }
            this.fileElements[n].setTableName(string);
            long l2 = this.getHandleCount(string2);
            this.fileElements[n].setHdlcount(l2);
            this.fileElements[n].initHdlInfoList((int)l2);
            int n2 = 0;
            while ((long)n2 < l2) {
                PVFILEHDLINFOEX pVFILEHDLINFOEX = new PVFILEHDLINFOEX();
                this.getHandleInfo(string2, n2, pVFILEHDLINFOEX);
                this.fileElements[n].setHdlinfo(n2, pVFILEHDLINFOEX);
                ++n2;
            }
            ++n;
        }
        dBFileTable.free();
        return this.fileElements;
    }

    private void freeData() {
        int n = javadti.JPvFreeOpenFilesData(this.m_hConnection);
        if (n == DTICONSTS.P_OK) {
            this.m_logger.finer("JPvFreeOpenFilesData Success");
        } else {
            this.m_logger.finer("JPvOpenFilesData Error: " + DTICONSTS.getErrorDesc(n));
        }
    }
}

