/**
 * This system procedure is used to return the
 * the view rights for the given view(s).
 */
CREATE PROCEDURE psp_view_rights
(  
    in :database_qual   VARCHAR(20) = DATABASE(), -- Name of the database
    in :view_name       VARCHAR(255) = NULL, -- Name of the view
    in :user_name       VARCHAR(255) = USER() -- Name of the user
)
RETURNS
(
    VIEW_QUALIFIER      VARCHAR (20), -- Name of the database that contains the view
    VIEW_OWNER          VARCHAR (20),  -- owner of the view
    USER_NAME           CHAR(255), -- Name of the user
    VIEW_NAME           CHAR(255), -- Name of the view
    RIGHTS              VARCHAR(12)  -- View rights 
);
BEGIN

	-- This variable stores the dynamic query
	DECLARE :query              LONGVARCHAR;
    
	-- This variable stores the view name concatenated with 
	-- the database qualifier in the form dbname.viewname
    DECLARE :view_table_name    VARCHAR(30);
    DECLARE :rights_table_name  VARCHAR(30);
    DECLARE :user_table_name    VARCHAR(30);

	-- This variable stores the metadata version
    DECLARE :version           INTEGER;

    -- If the database qualifier is null, then use the current database
	if (:database_qual is null) then
		set :database_qual = DATABASE();
	end if;
	
    -- Check if the database qualifier specified is a blank string
	if (rtrim(:database_qual) = '') then
		SIGNAL 'S1000', 'Please enter a valid database name. Database name cannot be a blank string'; 
	end if;
    
    -- Check if the column name is a blank string
	if (rtrim(:view_name) = '') then
		SIGNAL 'S1000', 'View name cannot be blank string';
	end if;		
    
    -- Check if the user name is a blank string
	if (rtrim(:user_name) = '') then
		SIGNAL 'S1000', 'User name cannot be a blank string';
	end if;
	
	   
    SET :view_table_name = '"' + :database_qual + '".X$View';
    SET :rights_table_name = '"' + :database_qual + '".X$Rights';
    SET :user_table_name = '"' + :database_qual + '".X$User';

	/* If view name is not supplied or value is null
	   match all the views*/
	   
    SET :view_name = IFNULL(:view_name,'%');
    SET :user_name = IFNULL(:user_name , USER());
  
    -- call procedure to find the metadata version and store it in a variable
    CALL psp_database_version(:database_qual, :version);

    if (:version = 1) then  
        -- Metadata version is V1
        SIGNAL 'S1000', 'View and Stored Procedure permissions are not supported on metadata version 1';   
    else 
        if (:version = 2) then  
            -- Metadata version is V2

            /* Enumerate the view rights */
                         -- SELECT rights for View
            SET :query = 'SELECT ''' + :database_qual + ''' , null, ' +
                         'B.Xu$Name, A.Xv$Name, ''SELECT'' ' +
                         'FROM ' + :view_table_name + ' A, ' + 
                         :user_table_name + ' B, ' + :rights_table_name +
                         ' C WHERE 	A.Xv$Name LIKE ''' + :view_name +
                         ''' AND B.Xu$Name LIKE ''' + :user_name +
                         ''' AND A.Xv$Id = C.Xr$Object AND B.Xu$Id = C.Xr$User ' +
                         'AND C.Xr$rights & 64 = 64 AND	C.Xr$Column = 0 AND C.Xr$Type = 4 ' +
                         -- UPDATE rights for View
                         'UNION	SELECT ''' + :database_qual + ''', null, B.Xu$Name, ' +
                         'A.Xv$Name, ''UPDATE'' FROM ' + :view_table_name +
                         ' A, ' + :user_table_name + ' B, ' + :rights_table_name + 
                         ' C WHERE	A.Xv$Name LIKE ''' + :view_name + 
                         ''' AND	B.Xu$Name LIKE ''' + :user_name + 
                         ''' AND A.Xv$Id = C.Xr$Object AND	B.Xu$Id = C.Xr$User AND ' +
                         'C.Xr$rights & 130 = 130 AND ' +	
                         'C.Xr$Column = 0 AND C.Xr$Type = 4 ' +
                         -- INSERT rights for View
                         'UNION	SELECT ''' + :database_qual + ''' , ' +
                         'null, B.Xu$Name, A.Xv$Name, ''INSERT'' FROM ' + 
                         :view_table_name + ' A, ' +
                         :user_table_name + ' B, ' + :rights_table_name + ' C ' +
                         'WHERE 	A.Xv$Name LIKE ''' + :view_name + 
                         ''' AND	B.Xu$Name ' +
                         'LIKE ''' + :user_name + ''' AND A.Xv$Id = C.Xr$Object AND ' +
                         'B.Xu$Id = C.Xr$User AND C.Xr$rights & 132 = 132 AND ' +	
                         'C.Xr$Column = 0 AND C.Xr$Type = 4 ' + 
                          -- DELETE rights for View
                         'UNION	SELECT ''' + :database_qual + ''', ' +
                         'null, B.Xu$Name, 	A.Xv$Name, ''DELETE'' FROM ' + 
                         :view_table_name + ' A, ' + :user_table_name + ' B, ' + 
                         :rights_table_name + ' C WHERE	A.Xv$Name LIKE ''' + 
                         :view_name + ''' AND	B.Xu$Name ' +
                         'LIKE ''' + :user_name + ''' AND A.Xv$Id = C.Xr$Object AND ' +
                         'B.Xu$Id = C.Xr$User AND C.Xr$rights & 136 = 136 AND ' +	
                         'C.Xr$Column = 0 AND C.Xr$Type = 4 ' +

                          -- ALTER rights for View
                         'UNION	SELECT ''' + :database_qual + ''', ' +
                         'null, B.Xu$Name, 	A.Xv$Name, ''ALTER'' FROM ' + 
                         :view_table_name + ' A, ' + :user_table_name + ' B, ' + 
                         :rights_table_name + ' C WHERE	A.Xv$Name LIKE ''' + 
                         :view_name + ''' AND	B.Xu$Name ' +
                         'LIKE ''' + :user_name + ''' AND A.Xv$Id = C.Xr$Object AND ' +
                         'B.Xu$Id = C.Xr$User AND C.Xr$rights & 160 = 160 AND ' +	
                         'C.Xr$Column = 0 AND C.Xr$Type = 4 '	;
        end if;                     
    end if;
    
    exec(:query);

END; -- End of the stored procedure.

