/**
 * This system procedure is used to return the
 * definition text of the given trigger from the 
 * database specified.
 */
CREATE PROCEDURE psp_help_trigger
(
    in :database_qual   VARCHAR(20) = DATABASE(), -- Name of the database
    in :trigger_name    VARCHAR(254) -- Name of the trigger
)

RETURNS
(
    DATABASE_QUALIFIER  VARCHAR(20), -- Name of the database
    TRIGGER_TEXT        LONGVARCHAR -- Definiton text of the trigger
);

BEGIN

	-- This variable stores the dynamic query
	DECLARE :query      LONGVARCHAR;

	-- This variable stores the table name concatenated with 
	-- the database qualifier in the form dbname.tablename
    DECLARE :table_name VARCHAR(30);

    -- If the database qualifier is null, then use current database
	if (:database_qual is null) then
		set :database_qual = DATABASE();
	end if;
	
    -- Check if the database qualifier is a blank string
	if (rtrim(:database_qual) = '') then
		SIGNAL 'S1000', 'Please enter a valid database name. Database name cannot be a blank string'; 
	end if;
	
    -- Check if the trigger name is null
	if (:trigger_name is null) then
		SIGNAL 'S1000', 'Trigger name cannot be null';
	end if;

    -- Check if the trigger name is a blank string
	if (rtrim(:trigger_name) = '') then
		SIGNAL 'S1000', 'Trigger name cannot be blank string';
	end if;		
	
    set :table_name = '"' + :database_qual + '".X$Trigger' 

    set :query = 'SELECT ''' + :database_qual + ''', Xt$Misc FROM ' + 
                 :table_name + ' WHERE Xt$Name LIKE ''' + :trigger_name +
                 ''' ORDER BY Xt$Sequence ';

    exec (:query);		
		
END;

