drop table billing#
drop table class#
drop table course#
drop table dept#
drop TABLE Enrolls#
drop TABLE Faculty#
drop TABLE Person#
drop TABLE Room#
drop TABLE Student#
drop TABLE Tuition#
drop TABLE Bookstore#

CREATE TABLE Billing
(Student_ID             UBIGINT NOT NULL,
 Transaction_Number     USMALLINT,
 Log                    TIMESTAMP,
 Amount_Owed            DECIMAL(6,2),
 Amount_Paid            DECIMAL(6,2),
 Registrar_ID           UBIGINT NOT NULL,
 Comments               CHAR(100))

#
CREATE TABLE Class
 ( ID                   IDENTITY,
   Name                 CHAR(7) NOT NULL CASE,
   Section              CHAR(3) NOT NULL CASE,
   Max_Size             USMALLINT,
   Start_Date           DATE NOT NULL,
   Start_Time           TIME NOT NULL,
   Finish_Time          TIME NOT NULL,
   Building_Name        CHAR(25) NOT NULL CASE,
   Room_Number          UINTEGER NOT NULL,
   Faculty_ID           UBIGINT NOT NULL)
#
CREATE TABLE Course
 ( Name                 CHAR(7) NOT NULL CASE,
   Description          CHAR(50) CASE,
   Credit_Hours         USMALLINT,
   Dept_Name            CHAR(20) NOT NULL CASE)
#
CREATE TABLE Dept
 ( Name                 CHAR(20) NOT NULL CASE,
   Phone_Number         DECIMAL(10,0),
   Building_Name        CHAR(25) NOT NULL CASE,
   Room_Number          UINTEGER NOT NULL,
   Head_Of_Dept         UBIGINT NOT NULL)
#
CREATE TABLE Enrolls
 ( Student_ID           UBIGINT NOT NULL,
   Class_ID             INTEGER NOT NULL,
   Grade                REAL)
#
CREATE TABLE Faculty
  (ID                   UBIGINT NOT NULL,
   Dept_Name            CHAR(20) CASE,
   Designation          CHAR(10) CASE,
   Salary               CURRENCY,
   Building_Name        CHAR(25) NOT NULL CASE,
   Room_Number          UINTEGER NOT NULL,
   Rsch_Grant_Amount    DOUBLE)
#
CREATE TABLE Person
 ( ID                   UBIGINT NOT NULL,
   First_Name           VARCHAR(15) CASE,
   Last_Name            VARCHAR(25) CASE,
   Perm_Street          VARCHAR(30) CASE,
   Perm_City            VARCHAR(30) CASE,
   Perm_State           VARCHAR(2)  CASE,
   Perm_Zip             VARCHAR(10) CASE,
   Perm_Country         VARCHAR(20) CASE,
   Street               VARCHAR(30) CASE,
   City                 VARCHAR(30) CASE,
   State                VARCHAR(2) CASE,
   Zip                  VARCHAR(10),
   Phone                DECIMAL(10,0),
   Emergency_Phone      CHAR(20) CASE,
   Unlisted             BIT,
   Date_Of_Birth        DATE,
   Email_Address        VARCHAR(30),
   Sex                  BIT,
   Citizenship          VARCHAR(20) CASE,
   Survey               BIT,
   Smoker               BIT,
   Married              BIT,
   Children             BIT,
   Disability           BIT,
   Scholarship          BIT,
	Comments               CHAR(100))
#
CREATE TABLE Room
(Building_Name          CHAR(25) CASE,
 Number                 UINTEGER,
 Capacity               USMALLINT,
 "Type"                 CHAR(20) NOT NULL CASE)
#
CREATE TABLE Student
 ( ID                   UBIGINT NOT NULL,
   Cumulative_GPA       DECIMAL(4,3),
   Tuition_ID           INTEGER NOT NULL,
   Transfer_Credits     DECIMAL(4,0),
   Major                CHAR(20) CASE,
   Minor                CHAR(20) CASE,
   Scholarship_Amount   DECIMAL(19,2),
   Cumulative_Hours     SMALLINT)
#
CREATE TABLE Tuition
 ( ID                   IDENTITY,
   Degree               VARCHAR(4) NOT NULL CASE,
   Residency            BIT,
   Cost_Per_Credit      REAL,
	Comments             CHAR(100))
#
CREATE TABLE BookStore SYSDATA_KEY_2
(Start_Time	TIMESTAMP NOT NULL,
 Lane_ID	INTEGER NOT NULL,
 Cashier_ID 	UBIGINT NOT NULL,
 Num_Items_Sold	INTEGER NOT NULL,
 Total_Cost	DECIMAL(6,2),
 Duration	INTEGER)
#
CREATE UNIQUE INDEX Student_Trans on BILLING 
        (Student_ID, 
	 Transaction_Number,
         Log,
         Registrar_ID)
#       
CREATE UNIQUE INDEX Class_Name on Class (Name,
            Section)
#
CREATE UNIQUE INDEX Class_seg_Faculty on Class (Faculty_ID, 
            Start_Date,
            Start_Time)
#            
CREATE INDEX Building_Room on Class (Building_Name, 
            Room_Number,
            Start_Date, 
            Start_Time)
#
CREATE UNIQUE INDEX Course_Name on Course (Name)
#
CREATE INDEX DeptName on Course (Dept_Name)
#
CREATE UNIQUE INDEX Dept_Name on Dept (Name)
#            
CREATE INDEX Building_Room ON Dept (Building_Name, 
            Room_Number)
#            
CREATE UNIQUE INDEX Dept_Head on Dept (Head_Of_Dept)
#
CREATE UNIQUE INDEX Student_Class on Enrolls (Student_ID, Class_ID)
#            
CREATE INDEX ClassID on Enrolls (Class_ID)
#            
CREATE INDEX StudentID on Enrolls (Student_ID)
#
CREATE UNIQUE INDEX FacultyID on Faculty (ID)
#
CREATE INDEX Dept on Faculty (Dept_Name)
#
CREATE INDEX Building_Room on Faculty (Building_Name, Room_Number)
#
CREATE UNIQUE INDEX PersonID on Person (ID)
#
CREATE INDEX Names on Person (Last_Name, First_Name)
#
CREATE INDEX State_City on Person (Perm_State, Perm_City)
#
CREATE UNIQUE INDEX Building_Number on Room (Building_Name, Number)
#
CREATE INDEX RoomType on Room ("Type")
#
CREATE UNIQUE INDEX StudentID on Student (ID)
#
CREATE INDEX TuitionID on Student (Tuition_ID)
#
CREATE INDEX Degrees on Tuition (Degree)
#
CREATE UNIQUE INDEX Start_Cashier on BookStore (Start_Time, Cashier_ID, Lane_Id)
