/*******************************************************************************
 * Copyright (c) 2000, 2004, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Ecplise Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Pervasive Software, Inc. - Added Dynamic properties
 *******************************************************************************/
package com.pervasive.open.eclipse.dynamicproperties.internal;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.internal.dialogs.EmptyPropertyPage;

import com.pervasive.open.eclipse.dynamicproperties.IDynamicPropertyPageContributor;

/**
 * Property page node allows us to achive presence in the property page dialog
 * without loading the page itself, thus loading the contributing plugin. Only
 * when the user selects the page will it be loaded.
 */
public class DynamicPropertyPageNode extends PreferenceNode implements
        IPluginContribution
{
    private IDynamicPropertyPageContributor contributor;

    private IWorkbenchPropertyPage page;

    private Image icon;
    
    private String pageName;

    private String pageId;
    
    private IAdaptable element;

    /**
     * PropertyPageNode constructor.
     */
    public DynamicPropertyPageNode(IDynamicPropertyPageContributor contributor,
            IAdaptable element, String pageId, String pageName, Image icon)
    {
        super(pageId);
        this.contributor = contributor;
        this.element = element;
        this.pageId = pageId;
        this.pageName = pageName;
        this.icon = icon;
    }

    /**
     * Creates the preference page this node stands for. If the page is null, it
     * will be created by loading the class. If loading fails, empty filler page
     * will be created instead.
     */
    public void createPage()
    {
//        try {
            //page = contributor.createPage(element, pageId);
            page = contributor.createPage(pageId);
//        }
//        catch (CoreException e) {
            // Just inform the user about the error. The details are
            // written to the log by now.
//            ErrorDialog.openError((Shell) null, WorkbenchMessages
//                    .getString("PropertyPageNode.errorTitle"), //$NON-NLS-1$
//                    WorkbenchMessages
//                            .getString("PropertyPageNode.errorMessage"), //$NON-NLS-1$
//                    e.getStatus());
            if (page == null) {
                page = new EmptyPropertyPage();
            }
//        }
        setPage(page);
    }

    /**
     * (non-Javadoc) Method declared on IPreferenceNode.
     */
    public void disposeResources()
    {

        if (page != null) {
            page.dispose();
            page = null;
        }
        if (icon != null) {
            icon.dispose();
            icon = null;
        }
    }

    /**
     * Returns page icon, if defined.
     */
    public Image getLabelImage()
    {
        return icon;
    }

    /**
     * Returns page label as defined in the registry.
     */
    public String getLabelText()
    {
        return pageName;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.activities.support.IPluginContribution#fromPlugin()
     */
    public boolean fromPlugin()
    {
        return true;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.activities.support.IPluginContribution#getLocalId()
     */
    public String getLocalId()
    {
        return getId();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.activities.support.IPluginContribution#getPluginId()
     */
    public String getPluginId()
    {
        //return contributor.getPluginId();
        return "";
    }
}
