/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.wizard;

import com.pervasive.utilities.util.GridHelper;
import com.pervasive.utilities.wizard.WizardExt;
import com.pervasive.utilities.wizard.WizardPageExt;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class WizardDialogExt
extends WizardDialog {
    private Image bookendImage;
    private Image bookendImageTile;
    private Image[] windowIcons;
    private Composite bookendLabelComp;
    private String nextButtonLabel;
    private String cancelButtonLabel;

    public WizardDialogExt(Shell shell, WizardExt wizardExt, Image[] imageArray, Image image, Image image2) {
        super(shell, (IWizard)wizardExt);
        this.setShellStyle(0x10820 | WizardDialogExt.getDefaultOrientation());
        this.windowIcons = imageArray;
        this.bookendImage = image;
        this.bookendImageTile = image2;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setImages(this.windowIcons);
    }

    protected Point getInitialSize() {
        return this.getShell().computeSize(-1, -1);
    }

    protected Control createContents(Composite composite) {
        Control control;
        Composite composite2 = null;
        if (this.bookendImage == null) {
            composite2 = composite;
        } else {
            composite2 = new Composite(composite, 0);
            control = new GridLayout();
            control.numColumns = 2;
            control.verticalSpacing = 0;
            control.horizontalSpacing = 0;
            control.marginHeight = 0;
            control.marginWidth = 0;
            composite2.setLayout((Layout)control);
            GridHelper.layoutFillBoth((Control)composite2, -1, -1, 0, 0);
            this.bookendLabelComp = new Composite(composite2, 0);
            if (this.bookendImageTile != null) {
                this.bookendLabelComp.setBackgroundImage(this.bookendImageTile);
                this.bookendLabelComp.setBackgroundMode(2);
            }
            GridLayout gridLayout = new GridLayout();
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            this.bookendLabelComp.setLayout((Layout)gridLayout);
            GridHelper.layoutFillVertical((Control)this.bookendLabelComp, 0, 0);
            Label label = new Label(this.bookendLabelComp, 0);
            label.setImage(this.bookendImage);
        }
        control = super.createContents(composite2);
        this.nextButtonLabel = this.getButton(15).getText();
        this.cancelButtonLabel = this.getButton(1).getText();
        return control;
    }

    protected Control createButtonBar(Composite composite) {
        Composite composite2 = null;
        if (this.bookendImage != null) {
            composite2 = (Composite)super.createButtonBar(composite.getParent().getParent());
            GridData gridData = (GridData)composite2.getLayoutData();
            gridData.horizontalSpan = 2;
        } else {
            composite2 = (Composite)super.createButtonBar(composite);
        }
        return composite2;
    }

    public void showPage(IWizardPage iWizardPage) {
        super.showPage(iWizardPage);
        WizardPageExt wizardPageExt = (WizardPageExt)iWizardPage;
        if (this.bookendImage != null) {
            if (wizardPageExt.isStartPage() || wizardPageExt.isFinishPage()) {
                this.showImage();
            } else {
                this.hideImage();
            }
        }
        WizardPageExt wizardPageExt2 = (WizardPageExt)iWizardPage;
        wizardPageExt2.populate();
        this.setCancelEnabled(wizardPageExt2.canCancel());
        if (!wizardPageExt.isFinishPage()) {
            this.setFinishEnabled(false);
        } else {
            this.setFinishEnabled(!wizardPageExt.canCancel());
        }
        String string = wizardPageExt2.getNextButtonLabel();
        this.getButton(15).setText(string != null ? string : this.nextButtonLabel);
        string = wizardPageExt2.getCancelButtonLabel();
        this.getButton(1).setText(string != null ? string : this.cancelButtonLabel);
    }

    private void showImage() {
        GridData gridData = (GridData)this.bookendLabelComp.getLayoutData();
        this.bookendLabelComp.setVisible(true);
        gridData.exclude = false;
        this.bookendLabelComp.getParent().layout(true, true);
    }

    private void hideImage() {
        GridData gridData = (GridData)this.bookendLabelComp.getLayoutData();
        this.bookendLabelComp.setVisible(false);
        gridData.exclude = true;
        this.bookendLabelComp.getParent().layout(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nextPressed() {
        WizardExt wizardExt = (WizardExt)this.getWizard();
        WizardPageExt wizardPageExt = (WizardPageExt)wizardExt.getCurrentPage();
        Cursor cursor = new Cursor(null, 1);
        Display.getCurrent().getActiveShell().setCursor(cursor);
        try {
            wizardPageExt.applyPage();
            super.nextPressed();
        }
        finally {
            Shell[] shellArray = Display.getCurrent().getShells();
            for (int i = 0; i < shellArray.length; ++i) {
                if (shellArray[i] == null) continue;
                shellArray[i].setCursor(null);
            }
            cursor.dispose();
        }
    }

    private void setCancelEnabled(boolean bl) {
        this.getButton(1).setEnabled(bl);
    }

    private void setFinishEnabled(boolean bl) {
        this.getButton(16).setEnabled(bl);
    }
}

