/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.psql.utilities.javadti;

import com.pervasive.psql.utilities.javadti.Connection;
import com.pervasive.psql.utilities.javadti.DTICONSTS;
import com.pervasive.psql.utilities.javadti.DTIException;
import com.pervasive.psql.utilities.javadti.PVFILEUSAGESTATS;
import com.pervasive.psql.utilities.javadti.javadti;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class FileUsageStats {
    private static Map<Connection, FileUsageStats> fileUsageStatsMap = new HashMap<Connection, FileUsageStats>();
    private Logger logger;
    private Connection connection;

    public static FileUsageStats getObj(Connection connection, String string) throws DTIException {
        FileUsageStats fileUsageStats = fileUsageStatsMap.get(connection);
        if (fileUsageStats == null) {
            fileUsageStats = new FileUsageStats(connection, string);
            fileUsageStatsMap.put(connection, fileUsageStats);
        }
        return fileUsageStats;
    }

    private FileUsageStats(Connection connection, String string) throws DTIException {
        this.connection = connection;
        this.logger = Logger.getLogger(string);
    }

    public List<PVFILEUSAGESTATS> getUsageStats() throws DTIException {
        long l = this.getCount();
        ArrayList<PVFILEUSAGESTATS> arrayList = new ArrayList<PVFILEUSAGESTATS>((int)l);
        try {
            long l2 = 0L;
            while (l2 < l) {
                PVFILEUSAGESTATS pVFILEUSAGESTATS = new PVFILEUSAGESTATS();
                this.getUsageStats(l2, pVFILEUSAGESTATS);
                arrayList.add(pVFILEUSAGESTATS);
                ++l2;
            }
        }
        finally {
            this.freeData();
        }
        return arrayList;
    }

    private long getCount() throws DTIException {
        long[] lArray = new long[1];
        int n = javadti.JPvCacheFileUsageStats(this.connection.getHandle(), lArray);
        if (n != DTICONSTS.P_OK) {
            this.logger.finer("JPvCacheFileUsageStats Error: " + DTICONSTS.getErrorDesc(n));
            throw new DTIException(n);
        }
        return lArray[0];
    }

    private void getUsageStats(long l, PVFILEUSAGESTATS pVFILEUSAGESTATS) throws DTIException {
        int n = javadti.JPvGetFileUsageStats(this.connection.getHandle(), l, pVFILEUSAGESTATS);
        if (n != DTICONSTS.P_OK) {
            this.logger.finer("JPvGetFileUsageStats Error: " + DTICONSTS.getErrorDesc(n));
            throw new DTIException(n);
        }
        this.logger.finer("JPvGetFileUsageStats Success");
    }

    private void freeData() {
        int n = javadti.JPvFreeFileUsageStats(this.connection.getHandle());
        if (n == DTICONSTS.P_OK) {
            this.logger.finer("JPvFreeFileUsageStats Success");
        } else {
            this.logger.finer("JPvFreeFileUsageStats Error: " + DTICONSTS.getErrorDesc(n));
        }
    }
}

