/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.psql.utilities.javadti;

import com.pervasive.psql.utilities.javadti.Connection;
import com.pervasive.psql.utilities.javadti.DBCatalogInfo;
import com.pervasive.psql.utilities.javadti.DBDictionary;
import com.pervasive.psql.utilities.javadti.DTIException;
import com.pervasive.psql.utilities.javadti.DTIInfo;
import com.pervasive.psql.utilities.javadti.Messages;
import com.pervasive.psql.utilities.javadti.TableNotFoundException;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;

public class DBFileTable {
    private static Connection conObj = null;
    private static Logger logger;
    private String savedPath = "";
    private String parsedfilename = "";
    private String dictPath = "";
    private DBCatalogInfo dbCatalog = null;
    private DBDictionary dbDictionary = null;

    public DBFileTable(Connection connection) throws DTIException {
        conObj = connection;
        logger = Logger.getLogger(DTIInfo.getLoggerName());
        this.dbCatalog = DBCatalogInfo.getObj(conObj);
    }

    public String getTableName(String string) throws DataFormatException, DTIException, TableNotFoundException {
        String string2 = this.checkifDDF(string);
        if (string2.compareTo("") != 0) {
            return string2;
        }
        String string3 = this.ParsePath(string);
        if (this.savedPath.compareTo(string3) != 0) {
            this.dictPath = this.dbCatalog.GetMatchDictPath(string3);
            if (this.dbDictionary != null) {
                this.dbDictionary.free();
                this.dbDictionary = null;
            }
            try {
                this.dbDictionary = new DBDictionary(this.dictPath);
            }
            catch (DTIException dTIException) {
                return "";
            }
        }
        this.savedPath = string3;
        return this.dbDictionary.getMatchingTable(this.parsedfilename);
    }

    private String checkifDDF(String string) {
        int n = string.length();
        String string2 = "";
        String string3 = string.substring(n - 4);
        String string4 = "X$";
        if (string3.compareToIgnoreCase(".ddf") != 0) {
            return "";
        }
        String string5 = string.substring(n - 6, n - 4);
        int n2 = string.lastIndexOf(92);
        string2 = string5.compareToIgnoreCase("v2") == 0 ? string.substring(n2 + 1, n - 6) : string.substring(n2 + 1, n - 4);
        if (string2.compareToIgnoreCase("trig") == 0) {
            return String.valueOf(string4) + "Trigger";
        }
        return String.valueOf(string4) + string2.substring(0, 1).toUpperCase() + string2.substring(1, string2.length()).toLowerCase();
    }

    private String ParsePath(String string) throws DataFormatException {
        int n = string.lastIndexOf(92);
        int n2 = string.length();
        if (n <= 0 || n == n2) {
            throw new DataFormatException(Messages.get("dti.missing.datapath"));
        }
        String string2 = string.substring(0, n);
        this.parsedfilename = string.substring(n + 1, n2);
        return string2;
    }

    public void free() throws DTIException {
        if (this.dbDictionary != null) {
            this.dbDictionary.free();
        }
    }
}

