/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.jarprocessor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.update.internal.jarprocessor.IProcessStep;
import org.eclipse.update.internal.jarprocessor.JarProcessor;
import org.eclipse.update.internal.jarprocessor.PackStep;
import org.eclipse.update.internal.jarprocessor.PackUnpackStep;
import org.eclipse.update.internal.jarprocessor.SignCommandStep;
import org.eclipse.update.internal.jarprocessor.UnpackStep;
import org.eclipse.update.internal.jarprocessor.Utils;

public class ZipProcessor {
    private IProcessStep signStep = null;
    private IProcessStep packStep = null;
    private IProcessStep packUnpackStep = null;
    private IProcessStep unpackStep = null;
    private String workingDirectory = null;
    private Properties properties = null;
    private Set packExclusions = null;
    private Set signExclusions = null;
    private String command = null;
    private boolean packing = false;
    private boolean signing = false;
    private boolean repacking = false;
    private boolean unpacking = false;
    private boolean verbose = false;
    private boolean processAll = false;

    public void setWorkingDirectory(String dir) {
        this.workingDirectory = dir;
    }

    public String getWorkingDirectory() {
        if (this.workingDirectory == null) {
            this.workingDirectory = ".";
        }
        return this.workingDirectory;
    }

    public void setSignCommand(String command) {
        this.command = command;
        this.signing = command != null;
    }

    public void setPack(boolean pack) {
        this.packing = pack;
    }

    public void setRepack(boolean repack) {
        this.repacking = repack;
    }

    public void setUnpack(boolean unpack) {
        this.unpacking = unpack;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setProcessAll(boolean all) {
        this.processAll = all;
    }

    public void processZip(File zipFile) throws ZipException, IOException {
        File outputFile;
        File parent;
        if (this.verbose) {
            System.out.println("Processing " + zipFile.getPath());
        }
        ZipFile zip = new ZipFile(zipFile);
        this.initialize(zip);
        String extension = this.unpacking ? "pack.gz" : ".jar";
        File tempDir = new File(this.getWorkingDirectory(), "temp_" + zipFile.getName());
        JarProcessor processor = new JarProcessor();
        processor.setVerbose(this.verbose);
        processor.setProcessAll(this.processAll);
        processor.setWorkingDirectory(tempDir.getCanonicalPath());
        if (this.unpacking) {
            processor.addProcessStep(this.unpackStep);
        }
        if (!(parent = (outputFile = new File(this.getWorkingDirectory(), String.valueOf(zipFile.getName()) + ".temp")).getParentFile()).exists()) {
            parent.mkdirs();
        }
        ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(outputFile));
        Enumeration<? extends ZipEntry> entries = zip.entries();
        if (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            while (entry != null) {
                String name = entry.getName();
                InputStream entryStream = zip.getInputStream(entry);
                boolean pack = this.packing && !this.packExclusions.contains(name);
                boolean sign = this.signing && !this.signExclusions.contains(name);
                boolean repack = this.repacking && !this.packExclusions.contains(name);
                File extractedFile = null;
                if (entry.getName().endsWith(extension) && (pack || sign || repack || this.unpacking)) {
                    extractedFile = new File(tempDir, name);
                    parent = extractedFile.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    if (this.verbose) {
                        System.out.println("Extracting " + entry.getName());
                    }
                    FileOutputStream extracted = new FileOutputStream(extractedFile);
                    Utils.transferStreams(entryStream, extracted, true);
                    entryStream = null;
                    boolean skip = Utils.shouldSkipJar(extractedFile, this.processAll, this.verbose);
                    if (skip) {
                        entryStream = new FileInputStream(extractedFile);
                        if (this.verbose) {
                            System.out.println(String.valueOf(entry.getName()) + " is not marked, skipping.");
                        }
                    } else {
                        block34: {
                            if (this.unpacking) {
                                File result = processor.processJar(extractedFile);
                                name = String.valueOf(name.substring(0, name.length() - extractedFile.getName().length())) + result.getName();
                                extractedFile = result;
                            } else {
                                if (repack || sign) {
                                    processor.clearProcessSteps();
                                    if (repack) {
                                        processor.addProcessStep(this.packUnpackStep);
                                    }
                                    if (sign) {
                                        processor.addProcessStep(this.signStep);
                                    }
                                    extractedFile = processor.processJar(extractedFile);
                                }
                                if (pack) {
                                    processor.clearProcessSteps();
                                    processor.addProcessStep(this.packStep);
                                    File modifiedFile = processor.processJar(extractedFile);
                                    if (modifiedFile.exists()) {
                                        block33: {
                                            try {
                                                String newName = String.valueOf(name.substring(0, name.length() - extractedFile.getName().length())) + modifiedFile.getName();
                                                if (this.verbose) {
                                                    System.out.println("Adding " + newName + " to " + outputFile.getPath());
                                                    System.out.println();
                                                }
                                                ZipEntry zipEntry = new ZipEntry(newName);
                                                entryStream = new FileInputStream(modifiedFile);
                                                zipOut.putNextEntry(zipEntry);
                                                Utils.transferStreams(entryStream, zipOut, false);
                                                entryStream.close();
                                                Utils.clear(modifiedFile);
                                            }
                                            catch (IOException e) {
                                                Utils.close(entryStream);
                                                if (!this.verbose) break block33;
                                                e.printStackTrace();
                                                System.out.println("Warning: Problem reading " + modifiedFile.getPath() + ".");
                                            }
                                        }
                                        entryStream = null;
                                    } else if (this.verbose) {
                                        System.out.println("Warning: " + modifiedFile.getPath() + " not found.");
                                    }
                                }
                            }
                            if (extractedFile.exists()) {
                                try {
                                    entryStream = new FileInputStream(extractedFile);
                                }
                                catch (IOException e) {
                                    if (!this.verbose) break block34;
                                    e.printStackTrace();
                                    System.out.println("Warning: Problem reading " + extractedFile.getPath() + ".");
                                }
                            }
                        }
                        if (this.verbose && entryStream != null) {
                            System.out.println("Adding " + name + " to " + outputFile.getPath());
                        }
                    }
                }
                if (entryStream != null) {
                    block35: {
                        ZipEntry newEntry = new ZipEntry(name);
                        try {
                            zipOut.putNextEntry(newEntry);
                            Utils.transferStreams(entryStream, zipOut, false);
                            zipOut.closeEntry();
                        }
                        catch (ZipException zipException) {
                            if (!this.verbose) break block35;
                            System.out.println("Warning: " + name + " already exists in " + outputFile.getName() + ".  Skipping.");
                        }
                    }
                    entryStream.close();
                }
                if (extractedFile != null) {
                    Utils.clear(extractedFile);
                }
                if (this.verbose) {
                    System.out.println();
                    System.out.println("Processing " + zipFile.getPath());
                }
                ZipEntry zipEntry = entry = entries.hasMoreElements() ? entries.nextElement() : null;
            }
        }
        zipOut.close();
        zip.close();
        File finalFile = new File(this.getWorkingDirectory(), zipFile.getName());
        if (finalFile.exists()) {
            finalFile.delete();
        }
        outputFile.renameTo(finalFile);
        Utils.clear(tempDir);
    }

    private void initialize(ZipFile zip) {
        block7: {
            ZipEntry entry = zip.getEntry("pack.properties");
            this.properties = new Properties();
            if (entry != null) {
                InputStream stream = null;
                try {
                    try {
                        stream = zip.getInputStream(entry);
                        this.properties.load(stream);
                    }
                    catch (IOException e) {
                        if (this.verbose) {
                            e.printStackTrace();
                        }
                        Utils.close(stream);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    Utils.close(stream);
                    throw throwable;
                }
                Utils.close(stream);
            }
        }
        this.packExclusions = Utils.getPackExclusions(this.properties);
        this.signExclusions = Utils.getSignExclusions(this.properties);
        this.packUnpackStep = new PackUnpackStep(this.properties, this.verbose);
        this.packStep = new PackStep(this.properties, this.verbose);
        this.signStep = new SignCommandStep(this.properties, this.command, this.verbose);
        this.unpackStep = new UnpackStep(this.properties, this.verbose);
    }
}

