/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.notificationviewer.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class PersistStore {
    private static int PIECE_LEN = 6144;
    private Preferences userRoot = Preferences.userRoot().node("com/pervasive/utilities/notificationviewer");
    public static PersistStore INSTANCE = new PersistStore();

    private PersistStore() {
        try {
            this.userRoot.sync();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public void store(Serializable serializable, String string) throws IOException {
        byte[] byArray = this.objectToBytes(serializable);
        byte[][] byArray2 = this.breakIntoPieces(byArray);
        this.writePieces(string, byArray2);
        try {
            this.userRoot.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public Object load(String string) throws BackingStoreException, ClassNotFoundException, IOException {
        byte[][] byArray = this.readPieces(string);
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = this.combinePieces(byArray);
        return this.bytesToObject(byArray2);
    }

    public void remove(String string) throws BackingStoreException {
        Preferences preferences = this.userRoot.node(string);
        preferences.removeNode();
    }

    private void writePieces(String string, byte[][] byArray) {
        Preferences preferences = this.userRoot.node(string);
        for (int i = 0; i < byArray.length; ++i) {
            preferences.putByteArray("" + i, byArray[i]);
        }
    }

    private byte[][] readPieces(String string) throws BackingStoreException {
        Preferences preferences = this.userRoot.node(string);
        String[] stringArray = preferences.keys();
        if (stringArray.length == 0) {
            return null;
        }
        byte[][] byArrayArray = new byte[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            byArrayArray[i] = preferences.getByteArray(stringArray[i], null);
        }
        return byArrayArray;
    }

    private byte[] objectToBytes(Serializable serializable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        return byteArrayOutputStream.toByteArray();
    }

    private Object bytesToObject(byte[] byArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object object = objectInputStream.readObject();
        return object;
    }

    private byte[] combinePieces(byte[][] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n += byArray[i].length;
        }
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            System.arraycopy(byArray[i], 0, byArray2, n2, byArray[i].length);
            n2 += byArray[i].length;
        }
        return byArray2;
    }

    private byte[][] breakIntoPieces(byte[] byArray) {
        int n = 6144;
        int n2 = (byArray.length + n - 1) / PIECE_LEN;
        byte[][] byArrayArray = new byte[n2][];
        for (int i = 0; i < n2; ++i) {
            int n3 = i * PIECE_LEN;
            int n4 = n3 + PIECE_LEN;
            if (n4 > byArray.length) {
                n4 = byArray.length;
            }
            int n5 = n4 - n3;
            byArrayArray[i] = new byte[n5];
            System.arraycopy(byArray, n3, byArrayArray[i], 0, n5);
        }
        return byArrayArray;
    }
}

