/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.notificationviewer.model;

import com.pervasive.utilities.notificationviewer.model.Notification;
import com.pervasive.utilities.notificationviewer.model.NotificationFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class NotificationLogReader {
    private BufferedReader reader = null;

    public NotificationLogReader(File file) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"), 8192);
    }

    public List<Notification> readNotifications() throws IOException {
        ArrayList<Notification> arrayList = new ArrayList<Notification>();
        String string = this.reader.readLine();
        while (string != null) {
            String[] stringArray;
            Notification notification;
            if ((string = string.trim()).length() > 0 && (notification = NotificationFactory.INSTANCE.createNotification(stringArray = this.parseRecord(string))) != null) {
                arrayList.add(notification);
            }
            string = this.reader.readLine();
        }
        return arrayList;
    }

    public List<Notification> readNotificationsSinceTimestamp(long l) throws IOException {
        ArrayList<Notification> arrayList = new ArrayList<Notification>();
        String string = this.reader.readLine();
        while (string != null) {
            Notification notification;
            String[] stringArray;
            long l2;
            if ((string = string.trim()).length() > 0 && (l2 = Long.parseLong((stringArray = this.parseRecord(string))[0]) * 1000L) > l && (notification = NotificationFactory.INSTANCE.createNotification(stringArray)) != null) {
                arrayList.add(notification);
            }
            string = this.reader.readLine();
        }
        return arrayList;
    }

    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String[] parseRecord(String string) {
        Object object;
        String[] stringArray = string.split(",");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            object = this.trimLeading(stringArray[n]);
            if (!((String)object).startsWith("\"")) {
                arrayList.add(object);
                ++n;
                continue;
            }
            if (((String)object).endsWith("\"")) {
                arrayList.add(((String)object).substring(1, ((String)object).length() - 1));
                ++n;
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder(((String)object).substring(1));
            stringBuilder.append(',');
            for (n2 = n + 1; n2 < stringArray.length; ++n2) {
                object = this.trimTrailing(stringArray[n2]);
                if (((String)object).endsWith("\"")) {
                    stringBuilder.append(((String)object).substring(0, ((String)object).length() - 1));
                    arrayList.add(stringBuilder.toString());
                    break;
                }
                stringBuilder.append((String)object + ",");
            }
            n = n2 + 1;
        }
        object = new String[arrayList.size()];
        object = arrayList.toArray((T[])object);
        for (n = 0; n < ((Object)object).length; ++n) {
            object[n] = ((String)object[n]).trim();
        }
        return object;
    }

    private String trimLeading(String string) {
        int n;
        for (n = 0; n < string.length() && string.charAt(n) == ' '; ++n) {
        }
        return string.substring(n);
    }

    private String trimTrailing(String string) {
        int n;
        for (n = string.length() - 1; n >= 0 && string.charAt(n) == ' '; --n) {
        }
        return string.substring(0, n + 1);
    }
}

