/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.notificationviewer.model;

import java.util.Date;

public class Notification
implements Comparable<Notification> {
    private Date timestamp;
    private int errorLevel;
    private int id;
    private String caption;
    private String description;
    private String details;
    private String oemInfo;
    private long uid;
    private boolean read;

    public Notification() {
    }

    public Notification(Date date, int n, int n2) {
        this.setTimestamp(date);
        this.setId(n);
        this.setErrorLevel(n2);
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date date) {
        this.timestamp = date;
    }

    public int getErrorLevel() {
        return this.errorLevel;
    }

    public void setErrorLevel(int n) {
        this.errorLevel = n;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String string) {
        this.caption = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String string) {
        this.details = string;
    }

    public boolean isRead() {
        return this.read;
    }

    public void setRead(boolean bl) {
        this.read = bl;
    }

    public long getUID() {
        return this.uid;
    }

    public void setUID(long l) {
        this.uid = l;
    }

    public String getOEMInfo() {
        return this.oemInfo;
    }

    public void setOEMInfo(String string) {
        this.oemInfo = string;
    }

    @Override
    public int compareTo(Notification notification) {
        if (this.uid == notification.uid) {
            return 0;
        }
        int n = this.timestamp.compareTo(notification.timestamp);
        if (n != 0) {
            return -n;
        }
        if (this.errorLevel == notification.errorLevel) {
            return 1;
        }
        return this.errorLevel > notification.errorLevel ? -1 : 1;
    }

    public String toString() {
        return "Notification [uid=" + this.uid + ", description=" + this.description + ", errorLevel=" + this.errorLevel + ", id=" + this.id + ", isRead=" + this.read + ", timestamp=" + this.timestamp + "]";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (int)(this.uid ^ this.uid >>> 32);
        n = 31 * n + this.id;
        n = 31 * n + (this.read ? 1231 : 1237);
        n = 31 * n + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Notification notification = (Notification)object;
        return this.uid == notification.uid;
    }
}

