/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.notificationviewer;

import com.pervasive.utilities.notificationviewer.NotificationViewerApp;
import com.pervasive.utilities.notificationviewer.utils.MessageCatalog;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;

public class SystemTray
implements SelectionListener,
MenuDetectListener {
    private NotificationViewerApp app;
    private Shell shell;
    private TrayItem trayItem;
    private Menu menu;
    private ToolTip currentTip;
    private boolean showUnreadImage = false;
    private Image normalImage;
    private Image unreadImage;

    public SystemTray(NotificationViewerApp notificationViewerApp, Shell shell) {
        this.app = notificationViewerApp;
        this.shell = shell;
        this.normalImage = NotificationViewerApp.getImageRegistry().get("tray_no_unread");
        this.unreadImage = NotificationViewerApp.getImageRegistry().get("tray_unread");
        this.createTrayItem();
    }

    public boolean isTrayItemSupported() {
        return this.trayItem != null;
    }

    public void showUnreadImage(boolean bl) {
        if (!this.isTrayItemSupported()) {
            return;
        }
        if (this.showUnreadImage == bl) {
            return;
        }
        this.showUnreadImage = bl;
        this.trayItem.setImage(bl ? this.unreadImage : this.normalImage);
    }

    public void showBalloonMessage(String string, String string2, int n) {
        if (!this.isTrayItemSupported()) {
            return;
        }
        if (this.currentTip != null) {
            this.currentTip.setVisible(false);
            this.currentTip.dispose();
            this.currentTip = null;
        }
        if (string == null) {
            this.trayItem.setToolTip(null);
            return;
        }
        this.currentTip = new ToolTip(this.shell, 0x1000 | this.getIconTypeForErrorLevel(n));
        this.currentTip.setText(string2);
        this.currentTip.setMessage(string);
        this.currentTip.setAutoHide(false);
        this.trayItem.setToolTip(this.currentTip);
        this.currentTip.setVisible(true);
    }

    private int getIconTypeForErrorLevel(int n) {
        int n2 = 2;
        if (n == 2) {
            n2 = 8;
        } else if (n == 3) {
            n2 = 1;
        }
        return n2;
    }

    public void setTooltip(String string) {
        if (!this.isTrayItemSupported()) {
            return;
        }
        if (string == null) {
            this.trayItem.setToolTipText(MessageCatalog.getMsg("AppTitle"));
        } else {
            this.trayItem.setToolTipText(string);
        }
    }

    private void createTrayItem() {
        Display display = this.shell.getDisplay();
        Tray tray = display.getSystemTray();
        if (tray == null) {
            return;
        }
        this.trayItem = new TrayItem(tray, 0);
        this.trayItem.setImage(this.normalImage);
        this.trayItem.setToolTipText(MessageCatalog.getMsg("AppTitle"));
        this.createMenu();
        this.trayItem.addSelectionListener((SelectionListener)this);
        this.trayItem.addMenuDetectListener((MenuDetectListener)this);
    }

    private void createMenu() {
        this.menu = new Menu((Decorations)this.shell, 8);
        MenuItem menuItem = new MenuItem(this.menu, 8);
        menuItem.setText(MessageCatalog.getMsg("Tray.OpenAction.Label"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SystemTray.this.app.show();
            }
        });
        new MenuItem(this.menu, 2);
        MenuItem menuItem2 = new MenuItem(this.menu, 8);
        menuItem2.setText(MessageCatalog.getMsg("Tray.ExistAction.Label"));
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SystemTray.this.app.close();
            }
        });
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.app.show();
    }

    public void menuDetected(MenuDetectEvent menuDetectEvent) {
        this.menu.setVisible(true);
    }
}

