/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.notificationviewer;

import com.pervasive.utilities.notificationviewer.NotificationComp;
import com.pervasive.utilities.notificationviewer.NotificationSelectionListener;
import com.pervasive.utilities.notificationviewer.model.Notification;
import java.util.ArrayList;
import java.util.List;

public class NotificationSelectionManager {
    private List<NotificationSelectionListener> listeners = new ArrayList<NotificationSelectionListener>();
    private NotificationComp selectedComp;
    private Notification selectedNotification;

    NotificationSelectionManager() {
    }

    public void addNotificationSelectionListener(NotificationSelectionListener notificationSelectionListener) {
        if (!this.listeners.contains(notificationSelectionListener)) {
            this.listeners.add(notificationSelectionListener);
        }
    }

    public void removeNotificationSelectionListener(NotificationSelectionListener notificationSelectionListener) {
        this.listeners.remove(notificationSelectionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNotificationEvent(Notification notification) {
        List<NotificationSelectionListener> list = this.listeners;
        synchronized (list) {
            for (NotificationSelectionListener notificationSelectionListener : this.listeners) {
                notificationSelectionListener.notificationSelected(notification);
            }
        }
    }

    public void clearSelected() {
        this.selectedComp = null;
        this.selectedNotification = null;
        this.fireNotificationEvent(this.selectedNotification);
    }

    public Notification getSelected() {
        return this.selectedNotification;
    }

    public void componentSelected(NotificationComp notificationComp) {
        if (this.selectedComp != null) {
            this.selectedComp.deselect();
        }
        this.selectedComp = notificationComp;
        this.selectedNotification = this.selectedComp.getNotification();
        this.fireNotificationEvent(this.selectedNotification);
    }
}

