/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.v2;

import com.pervasive.jdbc.common.Debug;
import com.pervasive.jdbc.common.JDBCURL;
import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.common.Utils;
import com.pervasive.jdbc.lna.LNAConnection;
import com.pervasive.jdbc.lna.LNAEnvironment;
import com.pervasive.jdbc.lna.LNASession;
import com.pervasive.jdbc.lna.LNASocketSession;
import com.pervasive.jdbc.lna.LNASocketSessionST;
import com.pervasive.jdbc.lna.LNATunnelSession;
import com.pervasive.jdbc.lna.PervasiveConnectionListener;
import com.pervasive.jdbc.lna.SharedMemorySession;
import com.pervasive.jdbc.v2.CallableStatement;
import com.pervasive.jdbc.v2.DatabaseMetaData;
import com.pervasive.jdbc.v2.Driver;
import com.pervasive.jdbc.v2.PreparedStatement;
import com.pervasive.jdbc.v2.Statement;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Struct;
import java.util.EventObject;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class Connection
implements java.sql.Connection,
PervasiveConnectionListener {
    private LNAEnvironment d_lnaEnv;
    private LNAConnection d_lnaConn;
    private Map<String, Class<?>> d_typeMap;
    private JDBCURL d_jdbcURL;
    private Properties d_info;

    Connection(JDBCURL jDBCURL, Properties properties) throws SQLException {
        LNASession lNASession;
        boolean bl = false;
        if ((jDBCURL.getDebugLevel() & 1) != 0) {
            Debug.setDebugStream(jDBCURL.getDebugFile());
            bl = true;
        }
        this.d_jdbcURL = jDBCURL;
        this.d_info = properties;
        switch (jDBCURL.getType()) {
            case 1: {
                lNASession = new LNASocketSession(jDBCURL, this, bl);
                break;
            }
            case 2: {
                lNASession = new LNATunnelSession(jDBCURL);
                break;
            }
            case 3: {
                lNASession = new LNASocketSessionST(jDBCURL, this, bl);
                break;
            }
            case 4: {
                lNASession = new SharedMemorySession(jDBCURL, this, bl);
                break;
            }
            default: {
                throw new SQLException(LocalStrings.ERR_BAD_URL);
            }
        }
        try {
            Object object;
            lNASession.open();
            String string = lNASession.handshake(null);
            String string2 = "0.0.0.0";
            if (lNASession instanceof LNASocketSession) {
                object = (LNASocketSession)lNASession;
                string2 = ((LNASocketSession)object).getSockName();
            }
            this.d_lnaEnv = new LNAEnvironment(lNASession);
            if (jDBCURL.getTranslateOption()) {
                this.d_lnaEnv.setEncoding("UTF-8");
            } else {
                this.d_lnaEnv.setEncoding(jDBCURL.getEncoding());
            }
            try {
                object = this.getConnectString(jDBCURL, properties, false, string2);
                this.d_lnaConn = this.d_lnaEnv.connect((byte[])object);
            }
            catch (Exception exception) {
                byte[] byArray = this.getConnectString(jDBCURL, properties, true, string2);
                this.d_lnaConn = this.d_lnaEnv.connect(byArray);
            }
            if (jDBCURL.getTranslateOption()) {
                this.d_lnaEnv.setEncoding(this.d_lnaConn.getServerEncoding());
                this.d_lnaConn.setAutoTranslate();
            }
            if (properties.getProperty("password") != null) {
                properties.put("password", "***");
            }
        }
        catch (IOException iOException) {
            if (Debug.out != null) {
                iOException.printStackTrace(Debug.out);
            }
            throw new SQLException(iOException.toString(), iOException);
        }
    }

    private byte[] getConnectString(JDBCURL jDBCURL, Properties properties, boolean bl, String string) throws IOException {
        Object object;
        Serializable serializable;
        properties.put("ExecDesc", LocalStrings.DRIVER_NAME);
        if (bl) {
            properties.put("ServerDSN", jDBCURL.getDSN());
        } else {
            properties.put("DBQ", jDBCURL.getDSN());
        }
        properties.put("ArrayFetchOn", "1");
        if (!properties.containsKey("ArrayBufferSize")) {
            properties.put("ArrayBufferSize", "8");
        }
        Driver.getMajVer();
        properties.put("ClientVersion", Driver.getProductVer());
        String string2 = jDBCURL.getEncoding();
        if (jDBCURL.getTranslateOption()) {
            properties.put("PvClientEncoding", "UTF-8");
            properties.put("PvTranslate", "auto");
        } else if (string2 != null) {
            string2.toUpperCase();
            if (string2.indexOf("EUC-JP") != -1) {
                properties.put("CodePageConvert", "EUC-JP");
            }
            if (string2.indexOf("UTF-8") != -1) {
                properties.put("CodePageConvert", "UTF-8");
            }
            properties.put("PvClientEncoding", string2);
        }
        String string3 = string;
        String string4 = "";
        String string5 = null;
        if (string3.equals("0.0.0.0") && jDBCURL.getType() == 4) {
            string3 = "Shared Memory";
        }
        if (Connection.isJNILoaded()) {
            if (string3.equals("0.0.0.0")) {
                string3 = Utils.getMyHostAddress1();
            }
            if (Connection.isTermServerSession()) {
                string3 = Connection.appendSessionId(string3);
            }
            string4 = Utils.getMyAddressString1();
            string5 = Utils.getMyHostName1();
        } else {
            if (string3.equals("0.0.0.0")) {
                serializable = InetAddress.getLocalHost();
                string3 = ((InetAddress)serializable).getHostAddress();
            }
            string4 = string3;
        }
        if ((string5 == null || string2 != null && new String(string5.getBytes(string2), string2).indexOf(63) != -1) && (string5 = System.getenv("COMPUTERNAME")) == null && (string5 = System.getenv("HOSTNAME")) == null) {
            string5 = "(" + string3 + ")";
        }
        properties.put("ClntIP", string3);
        properties.put("AddressList", string4);
        properties.put("ClntHostName", string5);
        try {
            properties.put("ClntUserName", System.getProperty("user.name"));
        }
        catch (SecurityException securityException) {
            properties.put("ClntUserName", "");
        }
        serializable = new StringBuffer(256);
        byte[] byArray = null;
        int n = 0;
        boolean bl2 = false;
        String string6 = properties.getProperty("PvClientEncoding");
        Object object2 = properties.keys();
        while (object2.hasMoreElements()) {
            String string7 = (String)object2.nextElement();
            object = properties.getProperty(string7);
            if (string7.equalsIgnoreCase("user")) {
                string7 = "UID";
            } else if (string7.equalsIgnoreCase("password")) {
                string7 = "PWD";
                bl2 = true;
                ((StringBuffer)serializable).append(string7).append('=').append("***").append(';');
                byArray = string6 == null ? properties.getProperty("password").getBytes() : properties.getProperty("password").getBytes(string6);
                n = byArray.length;
                continue;
            }
            ((StringBuffer)serializable).append(string7).append('=').append((String)object).append(';');
        }
        object2 = null;
        object2 = string6 == null ? (Object)((StringBuffer)serializable).toString().getBytes() : (Object)((StringBuffer)serializable).toString().getBytes(string6);
        int n2 = ((Object)object2).length;
        object = new byte[n2 + 1 + 3 + n];
        System.arraycopy(object2, 0, object, 0, n2);
        if (bl2) {
            this.d_lnaEnv.encrypt(byArray);
            object[n2] = false;
            object[n2 + 1] = -1;
            object[n2 + 2] = -1;
            object[n2 + 3] = (byte)(n & 0xFF);
            System.arraycopy(byArray, 0, object, n2 + 4, n);
            byArray = null;
        }
        return object;
    }

    private static boolean isJNILoaded() {
        try {
            JDBCURL.loadJNI();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static String appendSessionId(String string) {
        int n = 0;
        n = Utils.getTerminalSessionId1();
        if (n > 0) {
            string = string + ":$" + n;
        }
        return string;
    }

    private static boolean isTermServerSession() {
        String string = System.getProperty("os.name").toLowerCase();
        return string != null && string.indexOf("win") == 0;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    protected LNAConnection getLNAConnection() {
        return this.d_lnaConn;
    }

    protected String getURL() {
        return this.d_jdbcURL.toString();
    }

    protected Properties getProperties() {
        return this.d_info;
    }

    @Override
    public java.sql.Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    @Override
    public java.sql.CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007);
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.d_lnaConn.getConnOpts().setAutoCommit(bl ? 1 : 0);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.d_lnaConn.getConnOpts().getAutoCommit() == 1;
    }

    @Override
    public void commit() throws SQLException {
        this.d_lnaConn.transact((short)0);
    }

    @Override
    public void rollback() throws SQLException {
        this.d_lnaConn.transact((short)1);
    }

    @Override
    public void close() throws SQLException {
        this.d_lnaEnv.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.d_lnaEnv.isClosed();
    }

    @Override
    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        return new DatabaseMetaData(this);
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        this.d_lnaConn.getConnOpts().setAccessMode(bl ? 1 : 0);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.d_lnaConn.getConnOpts().getAccessMode() == 1;
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        this.d_lnaConn.getConnOpts().setCurrentQualifier(string);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.d_lnaConn.getConnOpts().getCurrentQualifier();
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        int n2;
        switch (n) {
            case 0: 
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 8: {
                n2 = 8;
                break;
            }
            default: {
                throw new SQLException(LocalStrings.ERR_SQL_UNKNOWN_ISOLATION_LEVEL, "S1092", 0);
            }
        }
        this.d_lnaConn.getConnOpts().setTxnIsolation(n2);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        int n;
        int n2 = this.d_lnaConn.getConnOpts().getTxnIsolation();
        switch (n2) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            default: {
                n = 8;
            }
        }
        return n;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return (SQLWarning)this.d_lnaConn.getErrors(true);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.d_lnaConn.clearErrors();
    }

    @Override
    public void connectionErrorOccurred(EventObject eventObject) {
    }

    @Override
    public void connectionClosed(EventObject eventObject) {
    }

    @Override
    public java.sql.Statement createStatement(int n, int n2) throws SQLException {
        return new Statement(this, n, n2);
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return new PreparedStatement(this, string, n, n2);
    }

    @Override
    public java.sql.CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return new CallableStatement(this, string, n, n2);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.d_typeMap;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.d_typeMap = map;
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        if (n == 2) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public java.sql.Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (n3 == 2) {
            throw new SQLFeatureNotSupportedException();
        }
        return new Statement(this, n, n2);
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (n3 == 2) {
            throw new SQLFeatureNotSupportedException();
        }
        return new PreparedStatement(this, string, n, n2);
    }

    @Override
    public java.sql.CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        if (n3 == 2) {
            throw new SQLFeatureNotSupportedException();
        }
        return new CallableStatement(this, string, n, n2);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLException(LocalStrings.ERR_NO_OBJECT_WRAPPED);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public Properties getClientInfo() {
        return this.getProperties();
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        return this.d_info.getProperty(string);
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        throw new SQLClientInfoException(LocalStrings.ERR_CLIENT_INFO_NOT_SUPPORTED, null);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new SQLClientInfoException(LocalStrings.ERR_CLIENT_INFO_NOT_SUPPORTED, null);
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        if (this.isClosed()) {
            return false;
        }
        return this.testSQL(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testSQL(int n) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        ExecutorCompletionService<Boolean> executorCompletionService = new ExecutorCompletionService<Boolean>(executorService);
        executorCompletionService.submit(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() {
                java.sql.Statement statement = null;
                try {
                    statement = Connection.this.createStatement();
                    statement.executeQuery("select 1");
                }
                catch (SQLException sQLException) {
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                return true;
            }
        });
        boolean bl = false;
        try {
            Future future = executorCompletionService.poll(n == 0 ? Integer.MAX_VALUE : (long)n, TimeUnit.SECONDS);
            if (future != null) {
                bl = (Boolean)future.get();
            }
        }
        catch (Exception exception) {
        }
        finally {
            executorService.shutdownNow();
        }
        return bl;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.close();
    }

    @Override
    public void setSchema(String string) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }
}

